/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.wind;

import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.item.Paraglider;
import tictim.paraglider.client.ParagliderClientSettings;
import tictim.paraglider.network.ParagliderNetwork;
import tictim.paraglider.wind.Wind;
import tictim.paraglider.wind.WindChunk;
import tictim.paraglider.wind.WindNode;

public final class WindUtils {
    @Environment(value=EnvType.CLIENT)
    private static List<WindNode> nodes;
    @Environment(value=EnvType.CLIENT)
    private static double windParticleState;

    private WindUtils() {
    }

    public static void updateWind(@NotNull class_1937 level) {
        Wind wind = Wind.of((class_1936)level);
        if (wind == null) {
            return;
        }
        long gameTime = level.method_8510();
        if (gameTime % 4L == 0L) {
            List players = level.method_18456();
            for (class_1657 player : players) {
                if (!(player.method_6047().method_7909() instanceof Paraglider)) continue;
                wind.placeAround(player);
            }
        }
        wind.checkPlacedWind(level);
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            LongIterator it = wind.dirtyWindChunks().iterator();
            while (it.hasNext()) {
                long chunkPos = it.nextLong();
                WindChunk windChunk = wind.getChunk(chunkPos);
                if (windChunk == null) continue;
                class_2818 chunk = level.method_8497(class_1923.method_8325((long)chunkPos), class_1923.method_8332((long)chunkPos));
                ParagliderNetwork.get().syncWind(serverLevel.method_8503(), chunk, windChunk);
            }
        }
        wind.dirtyWindChunks().clear();
    }

    @Environment(value=EnvType.CLIENT)
    public static void placeWindParticles(@NotNull class_1937 level, @NotNull Wind wind) {
        if (class_310.method_1551().method_1493()) {
            return;
        }
        double s2 = (windParticleState += ParagliderClientSettings.get().windParticleFrequency()) - 1.0;
        if (!(s2 >= 0.0)) {
            return;
        }
        windParticleState = s2;
        if (nodes == null) {
            nodes = new ArrayList<WindNode>();
        }
        for (WindChunk windChunk : wind.windChunks()) {
            for (WindNode node : windChunk.getAllRootNodes()) {
                do {
                    nodes.add(node);
                } while ((node = node.next) != null);
            }
        }
        int bound = 5 + nodes.size();
        for (WindNode node : nodes) {
            if (ParagliderUtils.PARTICLE_RNG.nextInt(bound) != 0) continue;
            level.method_8494((class_2394)class_2398.field_11248, (double)node.x + ParagliderUtils.PARTICLE_RNG.nextDouble(), (double)node.y + 0.5, (double)node.z + ParagliderUtils.PARTICLE_RNG.nextDouble(), 0.0, 1.0, 0.0);
        }
        nodes.clear();
    }
}

