/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.plugin;

import net.minecraft.class_1792;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.item.Paraglider;
import tictim.paraglider.api.movement.MovementPlugin;
import tictim.paraglider.api.movement.MovementPluginAction;
import tictim.paraglider.api.movement.ParagliderPlayerStates;
import tictim.paraglider.api.plugin.ConflictResolver;
import tictim.paraglider.api.plugin.ParagliderPlugin;
import tictim.paraglider.api.stamina.Stamina;
import tictim.paraglider.config.Cfg;
import tictim.paraglider.wind.Wind;

@ParagliderPlugin
public class ParagliderDefaultPlugin
implements MovementPlugin {
    private static final ConflictResolver<MovementPlugin, MovementPluginAction> RESOLVER = (a, p) -> {
        if (a instanceof MovementPluginAction.NewState) {
            return ConflictResolver.Resolution.PROCEED;
        }
        return ConflictResolver.Resolution.ABORT;
    };

    @Override
    public void registerNewStates(@NotNull MovementPlugin.PlayerStateRegister register) {
        register.register(ParagliderPlayerStates.IDLE, 20, new class_2960[0]);
        register.register(ParagliderPlayerStates.FLYING, 20, new class_2960[0]);
        register.register(ParagliderPlayerStates.ON_VEHICLE, 20, new class_2960[0]);
        register.register(ParagliderPlayerStates.SWIMMING, -6, ParagliderPlayerStates.Flags.FLAG_RUNNING);
        register.register(ParagliderPlayerStates.UNDERWATER, 3, ParagliderPlayerStates.Flags.FLAG_RUNNING);
        register.register(ParagliderPlayerStates.BREATHING_UNDERWATER, 20, ParagliderPlayerStates.Flags.FLAG_RUNNING);
        register.register(ParagliderPlayerStates.PARAGLIDING, -3, ParagliderPlayerStates.Flags.FLAG_PARAGLIDING);
        register.register(ParagliderPlayerStates.PANIC_PARAGLIDING, -3, ParagliderPlayerStates.Flags.FLAG_PARAGLIDING);
        register.register(ParagliderPlayerStates.ASCENDING, -3, ParagliderPlayerStates.Flags.FLAG_PARAGLIDING, ParagliderPlayerStates.Flags.FLAG_ASCENDING);
        register.register(ParagliderPlayerStates.RUNNING, -10, ParagliderPlayerStates.Flags.FLAG_RUNNING);
        register.register(ParagliderPlayerStates.MIDAIR, 0, new class_2960[0]);
    }

    @Override
    public void registerStateConnections(@NotNull MovementPlugin.PlayerStateConnectionRegister register) {
        register.addBranch(ParagliderPlayerStates.IDLE, (p, s, b, f) -> p.method_31549().field_7479 || p.method_6128(), ParagliderPlayerStates.FLYING, 7.0);
        register.addBranch(ParagliderPlayerStates.IDLE, (p, s, b, f) -> p.method_5854() != null, ParagliderPlayerStates.ON_VEHICLE, 6.0);
        register.addBranch(ParagliderPlayerStates.IDLE, (p, s, b, f) -> p.method_5681(), ParagliderPlayerStates.SWIMMING, 5.0);
        register.addBranch(ParagliderPlayerStates.IDLE, (p, s, b, f) -> p.method_5799(), ParagliderPlayerStates.UNDERWATER, 4.0);
        register.addBranch(ParagliderPlayerStates.UNDERWATER, (p, s, b, f) -> ParagliderUtils.canBreatheUnderwater(p), ParagliderPlayerStates.BREATHING_UNDERWATER);
        register.addBranch(ParagliderPlayerStates.IDLE, (p, s, b, f) -> {
            Paraglider item;
            class_1792 patt2617$temp;
            return b && !p.method_24828() && !p.method_6128() && (patt2617$temp = p.method_6047().method_7909()) instanceof Paraglider && (item = (Paraglider)patt2617$temp).canDoParagliding(p.method_6047());
        }, ParagliderPlayerStates.PARAGLIDING, 3.0);
        register.addBranch(ParagliderPlayerStates.PARAGLIDING, (p, s, b, f) -> f >= (double)1.45f && !p.method_7337() && Stamina.get(p).isDepleted(), ParagliderPlayerStates.PANIC_PARAGLIDING);
        register.addBranch(ParagliderPlayerStates.PARAGLIDING, (p, s, b, f) -> Cfg.get().ascendingWinds() && Wind.isInside(p.method_37908(), p.method_5829()), ParagliderPlayerStates.ASCENDING);
        register.addBranch(ParagliderPlayerStates.PARAGLIDING, (p, s, b, f) -> f < (double)1.45f && !s.has(ParagliderPlayerStates.Flags.FLAG_PARAGLIDING), ParagliderPlayerStates.IDLE);
        register.addBranch(ParagliderPlayerStates.IDLE, (p, s, b, f) -> p.method_5624() && !p.method_6115(), ParagliderPlayerStates.RUNNING, 2.0);
        register.addBranch(ParagliderPlayerStates.IDLE, (p, s, b, f) -> !p.method_24828(), ParagliderPlayerStates.MIDAIR, 1.0);
    }

    @Override
    @NotNull
    public ConflictResolver<MovementPlugin, MovementPluginAction> getMovementPluginConflictResolver() {
        return RESOLVER;
    }
}

