/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl.movement;

import java.util.Objects;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.ParagliderAPI;
import tictim.paraglider.api.Serde;
import tictim.paraglider.api.item.Paraglider;
import tictim.paraglider.api.movement.ParagliderPlayerStates;
import tictim.paraglider.api.movement.PlayerState;
import tictim.paraglider.api.stamina.Stamina;
import tictim.paraglider.api.vessel.VesselContainer;
import tictim.paraglider.config.Cfg;
import tictim.paraglider.contents.ParagliderAdvancements;
import tictim.paraglider.impl.movement.PlayerMovement;
import tictim.paraglider.impl.movement.PlayerMovementValues;
import tictim.paraglider.impl.movement.StaminaReductionLogicHandler;
import tictim.paraglider.impl.vessel.SimpleVesselContainer;
import tictim.paraglider.network.ParagliderNetwork;

public class ServerPlayerMovement
extends PlayerMovement
implements Serde {
    private boolean resync;
    private boolean heartContainerChanged = true;
    private boolean staminaVesselChanged = true;
    private boolean movementChanged;
    private int panicParaglidingDelay = 10;
    private boolean panicParagliding = false;
    private double prevY;
    private double accumulatedFallDistance;
    private double prevStaminaReduction;

    public ServerPlayerMovement(@NotNull class_3222 player) {
        super((class_1657)player);
    }

    @NotNull
    public class_3222 player() {
        return (class_3222)super.player();
    }

    @Override
    @NotNull
    protected Stamina createStamina() {
        return ParagliderAPI.staminaFactory().createServerInstance(this.player());
    }

    @Override
    @NotNull
    protected VesselContainer createVesselContainer() {
        return new SimpleVesselContainer((class_1657)this.player()){

            @Override
            protected void onChange(@NotNull SimpleVesselContainer.ActionType actionType, int change) {
                switch (actionType) {
                    case HEART_CONTAINER: {
                        ServerPlayerMovement.this.markHeartContainerChanged();
                        break;
                    }
                    case STAMINA_VESSEL: {
                        ServerPlayerMovement.this.markStaminaVesselChanged();
                    }
                }
            }
        };
    }

    @Override
    public void update() {
        boolean vesselsChanged;
        boolean resync = this.resync;
        this.resync = false;
        boolean bl = vesselsChanged = this.heartContainerChanged || this.staminaVesselChanged;
        if (this.heartContainerChanged) {
            double delta;
            double value = Cfg.get().additionalMaxHealth(this.vessels().heartContainer());
            class_1324 attrib = this.player().method_5996(class_5134.field_23716);
            if (attrib != null) {
                class_1322 prev = attrib.method_6199(PlayerMovementValues.HEART_CONTAINER_UUID);
                if (prev != null) {
                    attrib.method_6202(prev);
                }
                if (value != 0.0) {
                    attrib.method_26837(new class_1322(PlayerMovementValues.HEART_CONTAINER_UUID, "Heart Containers", value, class_1322.class_1323.field_6328));
                }
                delta = value - (prev != null ? prev.method_6186() : 0.0);
            } else {
                delta = 0.0;
            }
            this.player().method_6033(Math.min(this.player().method_6063(), this.player().method_6032() + Math.max(0.0f, (float)delta)));
            this.heartContainerChanged = false;
        }
        if (this.staminaVesselChanged) {
            this.stamina().setStamina(Math.min(this.stamina().stamina(), this.stamina().maxStamina()));
            this.staminaVesselChanged = false;
        }
        this.accumulatedFallDistance = this.player().method_24828() || this.player().method_23318() > this.prevY ? 0.0 : (this.accumulatedFallDistance += this.prevY - this.player().method_23318());
        PlayerState prevState = this.state();
        this.setState(ParagliderMod.instance().getPlayerConnectionMap().evaluate(ParagliderMod.instance().getLocalPlayerStateMap(), (class_1657)this.player(), this.state(), this.player().method_7337() || !this.stamina().isDepleted() || this.canDoPanicParagliding(), this.accumulatedFallDistance));
        double d = this.staminaReductionRate = this.state().staminaDelta() != 0 ? StaminaReductionLogicHandler.getReductionRate((class_1657)this.player(), this.state()) : 0.0;
        if (this.prevStaminaReduction != this.staminaReductionRate) {
            this.markMovementChanged();
        }
        if (!prevState.equals(this.state())) {
            this.markMovementChanged();
        }
        this.stamina().update(this);
        if (!this.player().method_7337() && this.stamina().isDepleted()) {
            ParagliderUtils.addExhaustion((class_1309)this.player());
        } else {
            ParagliderUtils.removeExhaustion((class_1309)this.player());
        }
        this.applyMovement();
        if (resync || this.movementChanged) {
            ParagliderNetwork.get().syncMovement(this.player(), this.state().id(), this.stamina().stamina(), this.stamina().isDepleted(), this.recoveryDelay(), this.staminaReductionRate());
            this.movementChanged = false;
        }
        if (resync || vesselsChanged) {
            ParagliderNetwork.get().syncVessels(this.player(), this.stamina().stamina(), this.vessels().heartContainer(), this.vessels().staminaVessel());
            if (vesselsChanged && Cfg.get().maxHeartContainers() <= this.vessels().heartContainer() && Cfg.get().maxStaminaVessels() <= this.vessels().staminaVessel()) {
                ParagliderUtils.giveAdvancement(this.player(), ParagliderAdvancements.ALL_VESSELS, "code_triggered");
            }
        }
        this.prevY = this.player().method_23318();
        this.prevStaminaReduction = this.staminaReductionRate;
        for (int i = 0; i < this.player().method_31548().method_5439(); ++i) {
            class_1799 stack = this.player().method_31548().method_5438(i);
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof Paraglider)) continue;
            Paraglider p = (Paraglider)class_17922;
            p.setParagliding(stack, i == this.player().method_31548().field_7545 && this.state().has(ParagliderPlayerStates.Flags.FLAG_PARAGLIDING));
        }
    }

    @Override
    protected void applyMovement() {
        super.applyMovement();
        boolean paragliding = this.state().has(ParagliderPlayerStates.Flags.FLAG_PARAGLIDING);
        if (paragliding) {
            this.player().field_13987.field_14138 = 0;
            class_1799 stack = this.player().method_6047();
            class_1792 class_17922 = stack.method_7909();
            if (class_17922 instanceof Paraglider) {
                Paraglider p = (Paraglider)class_17922;
                p.damageParaglider((class_1657)this.player(), stack);
            }
        }
        if (!this.player().method_7337() && this.stamina().isDepleted()) {
            if (this.panicParaglidingDelay > 0) {
                if (!this.player().method_24828()) {
                    --this.panicParaglidingDelay;
                } else {
                    this.resetPanicParaglidingState();
                }
            } else if (this.panicParagliding) {
                this.panicParaglidingDelay = 30;
                this.panicParagliding = false;
            } else if (paragliding) {
                this.panicParaglidingDelay = 15;
                this.panicParagliding = true;
            }
        }
    }

    public boolean canDoPanicParagliding() {
        return this.panicParagliding || this.panicParaglidingDelay <= 0;
    }

    public void resetPanicParaglidingState() {
        this.panicParaglidingDelay = 10;
        this.panicParagliding = false;
    }

    public void markForSync() {
        this.resync = true;
    }

    public void markHeartContainerChanged() {
        this.heartContainerChanged = true;
    }

    public void markStaminaVesselChanged() {
        this.staminaVesselChanged = true;
    }

    public void markMovementChanged() {
        this.movementChanged = true;
    }

    @Override
    public void read(@NotNull class_2487 tag) {
        if (tag.method_10573("stamina", 3)) {
            VesselContainer tag2;
            Serde serde;
            Stamina stamina = this.stamina();
            if (stamina instanceof Serde) {
                serde = (Serde)((Object)stamina);
                tag2 = new class_2487();
                tag2.method_10569("stamina", tag.method_10550("stamina"));
                tag2.method_10556("depleted", tag.method_10577("depleted"));
                serde.read((class_2487)tag2);
            }
            if ((tag2 = this.vessels()) instanceof Serde) {
                serde = (Serde)((Object)tag2);
                tag2 = new class_2487();
                tag2.method_10569("heartContainers", tag.method_10550("heartContainers"));
                tag2.method_10569("staminaVessels", tag.method_10550("staminaVessels"));
                tag2.method_10569("essences", tag.method_10550("essence"));
                serde.read((class_2487)tag2);
            }
        } else {
            Serde serde;
            Object object = this.stamina();
            if (object instanceof Serde) {
                serde = (Serde)object;
                serde.read(tag.method_10562("stamina"));
            }
            if ((object = this.vessels()) instanceof Serde) {
                serde = (Serde)object;
                serde.read(tag.method_10562("vessels"));
            }
        }
        this.setRecoveryDelay(tag.method_10550("recoveryDelay"));
        this.panicParaglidingDelay = tag.method_10550("panicParaglidingDelay");
        this.panicParagliding = tag.method_10577("panicParagliding");
        this.heartContainerChanged = true;
        this.staminaVesselChanged = true;
    }

    @Override
    @NotNull
    public class_2487 write() {
        Serde serde;
        class_2487 tag = new class_2487();
        Object object = this.stamina();
        if (object instanceof Serde) {
            serde = (Serde)object;
            tag.method_10566("stamina", (class_2520)Objects.requireNonNull(serde.write(), this.stamina() + "#write() returned null!"));
        }
        if ((object = this.vessels()) instanceof Serde) {
            serde = (Serde)object;
            tag.method_10566("vessels", (class_2520)Objects.requireNonNull(serde.write(), this.vessels() + "#write() returned null!"));
        }
        tag.method_10569("recoveryDelay", this.recoveryDelay());
        tag.method_10569("panicParaglidingDelay", this.panicParaglidingDelay);
        tag.method_10556("panicParagliding", this.panicParagliding);
        return tag;
    }
}

