/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl.movement;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.api.movement.ParagliderPlayerStates;
import tictim.paraglider.api.movement.PlayerState;
import tictim.paraglider.api.movement.PlayerStateCondition;
import tictim.paraglider.impl.movement.PlayerStateMap;

public final class PlayerStateConnectionMap {
    private final Map<class_2960, ConnectionList> connections;

    public PlayerStateConnectionMap(@NotNull @NotNull Map<@NotNull class_2960, @NotNull ConnectionList> connections) {
        this.connections = connections;
    }

    @NotNull
    public @NotNull @Unmodifiable Map<@NotNull class_2960, @NotNull ConnectionList> connections() {
        return Collections.unmodifiableMap(this.connections);
    }

    @NotNull
    public PlayerState evaluate(@NotNull PlayerStateMap stateMap, @NotNull class_1657 player, @NotNull PlayerState prevState, boolean canDoParagliding, double accumulatedFallDistance) {
        Object2IntOpenHashMap states = new Object2IntOpenHashMap();
        class_2960 currentState = ParagliderPlayerStates.IDLE;
        @Nullable ConnectionList currentConnections = this.connections.get(currentState);
        int currentIndex = 0;
        block0: while (currentConnections != null) {
            while (currentIndex < currentConnections.branches.size()) {
                Branch c;
                if (!(c = currentConnections.branches.get(currentIndex++)).condition().test(player, prevState, canDoParagliding, accumulatedFallDistance)) continue;
                states.put((Object)currentState, currentIndex);
                currentState = c.state();
                currentConnections = this.connections.get(currentState);
                currentIndex = states.getInt((Object)currentState);
                continue block0;
            }
            if (currentConnections.fallback == null) {
                return stateMap.expectState(currentState);
            }
            states.put((Object)currentState, currentIndex);
            currentState = currentConnections.fallback;
            currentConnections = this.connections.get(currentState);
            currentIndex = states.getInt((Object)currentState);
        }
        return stateMap.expectState(currentState);
    }

    public String toString() {
        return "PlayerStateConnectionMap{, connections=" + this.connections + "}";
    }

    public record ConnectionList(@NotNull @NotNull @Unmodifiable List<@NotNull Branch> branches, @Nullable class_2960 fallback) {
        public ConnectionList(@NotNull @NotNull @Unmodifiable List<@NotNull Branch> branches, @Nullable class_2960 fallback) {
            this.branches = List.copyOf((Collection)Objects.requireNonNull(branches, "branches == null"));
            for (Branch branch : this.branches) {
                Objects.requireNonNull(branch);
            }
            this.fallback = fallback;
        }
    }

    public record Branch(@NotNull PlayerStateCondition condition, @NotNull class_2960 state) {
    }
}

