/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.fabric.event;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.movement.Movement;
import tictim.paraglider.api.movement.ParagliderPlayerStates;
import tictim.paraglider.api.stamina.Stamina;
import tictim.paraglider.client.ParagliderClientSettings;
import tictim.paraglider.client.render.InGameStaminaWheelRenderer;
import tictim.paraglider.client.screen.DisableStaminaRender;
import tictim.paraglider.config.DebugCfg;

public final class ParagliderClientEventHandler {
    private ParagliderClientEventHandler() {
    }

    public static void renderHUD(class_332 guiGraphics) {
        ParagliderClientEventHandler.renderDebugText(guiGraphics);
        ParagliderClientEventHandler.renderStaminaWheel(guiGraphics);
    }

    private static void renderStaminaWheel(class_332 guiGraphics) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1755 instanceof DisableStaminaRender || !Stamina.get((class_1657)mc.field_1724).renderStaminaWheel() || !ParagliderMod.instance().getPlayerStateMap().hasStaminaConsumption()) {
            return;
        }
        ParagliderClientSettings settings = ParagliderClientSettings.get();
        int x = class_3532.method_15340((int)((int)Math.round(settings.staminaWheelX() * (double)guiGraphics.method_51421())), (int)11, (int)(guiGraphics.method_51421() - 2 - 10));
        int y = class_3532.method_15340((int)((int)Math.round(settings.staminaWheelY() * (double)guiGraphics.method_51443())), (int)11, (int)(guiGraphics.method_51443() - 2 - 10));
        InGameStaminaWheelRenderer.get().renderStamina(guiGraphics, x, y, 25.0);
    }

    private static void renderDebugText(class_332 guiGraphics) {
        if (!DebugCfg.get().debugPlayerMovement()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1690.field_1866) {
            return;
        }
        class_746 p = mc.field_1724;
        if (p == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        ParagliderUtils.addDebugText((class_1657)p, list);
        ParagliderClientEventHandler.renderLines(guiGraphics, mc.field_1772, list);
    }

    private static void renderLines(class_332 guiGraphics, class_327 font, List<String> list) {
        int y;
        int x;
        int width;
        String string;
        int i;
        for (i = 0; i < list.size(); ++i) {
            string = list.get(i);
            if (Strings.isNullOrEmpty((String)string)) continue;
            width = font.method_1727(string);
            x = guiGraphics.method_51421() - 2 - width;
            Objects.requireNonNull(font);
            y = 2 + 9 * i;
            Objects.requireNonNull(font);
            guiGraphics.method_25294(x - 1, y - 1, x + width + 1, y + 9 - 1, -1873784752);
        }
        for (i = 0; i < list.size(); ++i) {
            string = list.get(i);
            if (Strings.isNullOrEmpty((String)string)) continue;
            width = font.method_1727(string);
            x = guiGraphics.method_51421() - 2 - width;
            Objects.requireNonNull(font);
            y = 2 + 9 * i;
            guiGraphics.method_51433(font, string, x, y, 0xE0E0E0, false);
        }
    }

    public static boolean beforeAttack(class_746 player) {
        return Movement.get((class_1657)player).state().has(ParagliderPlayerStates.Flags.FLAG_PARAGLIDING);
    }

    public static boolean beforeBlockOutline() {
        class_746 player = class_310.method_1551().field_1724;
        return player == null || !Movement.get((class_1657)player).state().has(ParagliderPlayerStates.Flags.FLAG_PARAGLIDING);
    }
}

