/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.recipe;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.bargain.Bargain;
import tictim.paraglider.api.bargain.BargainResult;
import tictim.paraglider.api.bargain.DemandPreview;
import tictim.paraglider.api.bargain.OfferPreview;
import tictim.paraglider.api.vessel.VesselContainer;
import tictim.paraglider.bargain.preview.EssenceDemandPreview;
import tictim.paraglider.bargain.preview.EssenceOfferPreview;
import tictim.paraglider.bargain.preview.HeartContainerDemandPreview;
import tictim.paraglider.bargain.preview.HeartContainerOfferPreview;
import tictim.paraglider.bargain.preview.QuantifiedIngredient;
import tictim.paraglider.bargain.preview.QuantifiedItem;
import tictim.paraglider.bargain.preview.StaminaVesselDemandPreview;
import tictim.paraglider.bargain.preview.StaminaVesselOfferPreview;
import tictim.paraglider.contents.Contents;

public class SimpleBargain
implements Bargain {
    private final class_2960 id;
    private final class_2960 bargainType;
    private final List<QuantifiedIngredient> itemDemands;
    private final int heartContainerDemands;
    private final int staminaVesselDemands;
    private final int essenceDemands;
    private final List<QuantifiedItem> itemOffers;
    private final int heartContainerOffers;
    private final int staminaVesselOffers;
    private final int essenceOffers;
    private final Set<String> userTags;
    private final Set<String> tags;
    @Nullable
    private List<DemandPreview> demandPreviews;
    @Nullable
    private List<OfferPreview> offerPreviews;

    public SimpleBargain(@NotNull class_2960 id, @NotNull class_2960 bargainType, @NotNull @NotNull List<@NotNull QuantifiedIngredient> itemDemands, int heartContainerDemands, int staminaVesselDemands, int essenceDemands, @NotNull @NotNull List<@NotNull QuantifiedItem> itemOffers, int heartContainerOffers, int staminaVesselOffers, int essenceOffers, @NotNull @NotNull Set<@NotNull String> userTags) {
        this.id = Objects.requireNonNull(id);
        this.bargainType = bargainType;
        this.itemDemands = ImmutableList.copyOf(itemDemands);
        for (QuantifiedIngredient itemDemand : this.itemDemands) {
            Objects.requireNonNull(itemDemand);
        }
        this.heartContainerDemands = heartContainerDemands;
        this.staminaVesselDemands = staminaVesselDemands;
        this.essenceDemands = essenceDemands;
        this.itemOffers = ImmutableList.copyOf(itemOffers);
        this.heartContainerOffers = heartContainerOffers;
        this.staminaVesselOffers = staminaVesselOffers;
        this.essenceOffers = essenceOffers;
        this.userTags = Set.copyOf(userTags);
        this.tags = new ObjectOpenHashSet(userTags);
        if (!this.itemDemands.isEmpty()) {
            this.tags.add("consumes_item");
        }
        if (this.heartContainerDemands > 0) {
            this.tags.add("consumes_heart_container");
        }
        if (this.staminaVesselDemands > 0) {
            this.tags.add("consumes_stamina_vessel");
        }
        if (this.essenceDemands > 0) {
            this.tags.add("consumes_essence");
        }
        if (!this.itemOffers.isEmpty()) {
            this.tags.add("gives_item");
        }
        if (this.heartContainerOffers > 0) {
            this.tags.add("gives_heart_container");
        }
        if (this.staminaVesselOffers > 0) {
            this.tags.add("gives_stamina_vessel");
        }
        if (this.essenceOffers > 0) {
            this.tags.add("gives_essence");
        }
    }

    @Override
    @NotNull
    public class_2960 getBargainType() {
        return this.bargainType;
    }

    @NotNull
    public List<QuantifiedIngredient> getItemDemands() {
        return this.itemDemands;
    }

    public int getHeartContainerDemands() {
        return this.heartContainerDemands;
    }

    public int getStaminaVesselDemands() {
        return this.staminaVesselDemands;
    }

    public int getEssenceDemands() {
        return this.essenceDemands;
    }

    @NotNull
    public List<QuantifiedItem> getItemOffers() {
        return this.itemOffers;
    }

    public int getHeartContainerOffers() {
        return this.heartContainerOffers;
    }

    public int getStaminaVesselOffers() {
        return this.staminaVesselOffers;
    }

    public int getEssenceOffers() {
        return this.essenceOffers;
    }

    @NotNull
    public Set<String> getUserTags() {
        return this.userTags;
    }

    @Override
    public boolean isAvailableFor(@NotNull class_1657 player, @Nullable class_2338 pos) {
        return true;
    }

    @Override
    @NotNull
    public @NotNull @Unmodifiable List<@NotNull DemandPreview> previewDemands() {
        if (this.demandPreviews != null) {
            return this.demandPreviews;
        }
        this.demandPreviews = new ArrayList<DemandPreview>();
        this.demandPreviews.addAll(this.itemDemands);
        if (this.heartContainerDemands > 0) {
            this.demandPreviews.add(new HeartContainerDemandPreview(this.heartContainerDemands));
        }
        if (this.staminaVesselDemands > 0) {
            this.demandPreviews.add(new StaminaVesselDemandPreview(this.staminaVesselDemands));
        }
        if (this.essenceDemands > 0) {
            this.demandPreviews.add(new EssenceDemandPreview(this.essenceDemands));
        }
        return this.demandPreviews;
    }

    @Override
    @NotNull
    public @NotNull @Unmodifiable List<@NotNull OfferPreview> previewOffers() {
        if (this.offerPreviews != null) {
            return this.offerPreviews;
        }
        this.offerPreviews = new ArrayList<OfferPreview>();
        this.offerPreviews.addAll(this.itemOffers);
        if (this.heartContainerOffers > 0) {
            this.offerPreviews.add(new HeartContainerOfferPreview(this.heartContainerOffers));
        }
        if (this.staminaVesselOffers > 0) {
            this.offerPreviews.add(new StaminaVesselOfferPreview(this.staminaVesselOffers));
        }
        if (this.essenceOffers > 0) {
            this.offerPreviews.add(new EssenceOfferPreview(this.essenceOffers));
        }
        return this.offerPreviews;
    }

    @Override
    @NotNull
    public BargainResult bargain(@NotNull class_1657 player, boolean simulate) {
        VesselContainer container = VesselContainer.get(player);
        HashSet<String> reasons = new HashSet<String>();
        class_1661 inventory = player.method_31548();
        Int2IntOpenHashMap consumptions = new Int2IntOpenHashMap();
        for (QuantifiedIngredient i : this.itemDemands) {
            if (ParagliderUtils.calculateConsumption(i, (class_1263)inventory, consumptions)) continue;
            reasons.add("not_enough_items");
            break;
        }
        if (container.takeHeartContainers(this.heartContainerDemands, true, false) < this.heartContainerDemands) {
            reasons.add("not_enough_hearts");
        }
        if (container.takeStaminaVessels(this.staminaVesselDemands, true, false) < this.staminaVesselDemands) {
            reasons.add("not_enough_stamina");
        }
        if (container.takeEssences(this.essenceDemands, true, false) < this.essenceDemands) {
            reasons.add("not_enough_essences");
        }
        if (!reasons.isEmpty()) {
            return BargainResult.fail(reasons);
        }
        int heartDiff = this.heartContainerOffers - this.heartContainerDemands;
        int staminaDiff = this.staminaVesselOffers - this.staminaVesselDemands;
        int essenceDiff = this.essenceOffers - this.essenceDemands;
        if (heartDiff > 0 && container.giveHeartContainers(heartDiff, true, false) < heartDiff) {
            reasons.add("heart_full");
        }
        if (staminaDiff > 0 && container.giveStaminaVessels(staminaDiff, true, false) < staminaDiff) {
            reasons.add("stamina_full");
        }
        if (essenceDiff > 0 && container.giveEssences(essenceDiff, true, false) < essenceDiff) {
            reasons.add("essence_full");
        }
        if (!reasons.isEmpty()) {
            return BargainResult.fail(reasons);
        }
        if (!simulate) {
            for (Int2IntMap.Entry e : consumptions.int2IntEntrySet()) {
                int i = e.getIntKey();
                int c = e.getIntValue();
                if (c <= 0) continue;
                class_1799 stack = inventory.method_5438(i);
                if (stack.method_7947() > c) {
                    stack.method_7934(c);
                    continue;
                }
                if (stack.method_7947() != c) {
                    ParagliderMod.LOGGER.error("Quantity of item {} (slot number {}) differs from simulation.", (Object)stack, (Object)i);
                }
                inventory.method_5447(i, class_1799.field_8037);
            }
            for (QuantifiedItem item : this.itemOffers) {
                ParagliderUtils.giveItem(player, item.getItemWithQuantity());
            }
            if (heartDiff != 0 && (heartDiff > 0 ? container.giveHeartContainers(heartDiff, false, true) != heartDiff : container.takeHeartContainers(-heartDiff, false, true) != -heartDiff)) {
                ParagliderMod.LOGGER.error("Heart Container transaction of bargain {} failed to resolve after successful simulation.", (Object)this.id);
            }
            if (staminaDiff != 0 && (staminaDiff > 0 ? container.giveStaminaVessels(staminaDiff, false, true) != staminaDiff : container.takeStaminaVessels(-staminaDiff, false, true) != -staminaDiff)) {
                ParagliderMod.LOGGER.error("Stamina Vessel transaction of bargain {} failed to resolve after successful simulation.", (Object)this.id);
            }
            if (essenceDiff != 0 && (essenceDiff > 0 ? container.giveEssences(essenceDiff, false, true) != essenceDiff : container.takeEssences(-essenceDiff, false, true) != -essenceDiff)) {
                ParagliderMod.LOGGER.error("Essence transaction of bargain {} failed to resolve after successful simulation.", (Object)this.id);
            }
        }
        return BargainResult.success();
    }

    @Override
    @NotNull
    public @NotNull @Unmodifiable Set<@NotNull String> getBargainTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    @NotNull
    public class_2960 method_8114() {
        return this.id;
    }

    @NotNull
    public class_1865<?> method_8119() {
        return Contents.get().bargainRecipeSerializer();
    }

    @NotNull
    public class_3956<?> method_17716() {
        return Contents.get().bargainRecipeType();
    }
}

