/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.config.FeatureCfg;

public final class ParagliderVillageStructures {
    private ParagliderVillageStructures() {
    }

    public static void addVillageStructures(@NotNull MinecraftServer server) {
        if (!FeatureCfg.get().enableStructures()) {
            return;
        }
        class_2378 reg = (class_2378)server.method_30611().method_33310(class_7924.field_41249).orElseThrow();
        ParagliderMod.LOGGER.debug("Start adding village structures");
        ParagliderVillageStructures.appendPool((class_2378<class_3785>)reg, new class_2960("village/desert/houses"), Pair.of((Object)class_3784.method_30425((String)"paraglider:gerudo_village_goddess_statue"), (Object)1), Pair.of((Object)class_3784.method_30425((String)"paraglider:desert_village_horned_statue"), (Object)1));
        ParagliderVillageStructures.appendPool((class_2378<class_3785>)reg, new class_2960("village/plains/houses"), Pair.of((Object)class_3784.method_30425((String)"paraglider:hateno_village_goddess_statue"), (Object)1), Pair.of((Object)class_3784.method_30425((String)"paraglider:plains_village_horned_statue"), (Object)1));
        ParagliderVillageStructures.appendPool((class_2378<class_3785>)reg, new class_2960("village/savanna/houses"), Pair.of((Object)class_3784.method_30425((String)"paraglider:rito_village_goddess_statue"), (Object)3), Pair.of((Object)class_3784.method_30425((String)"paraglider:savanna_village_horned_statue"), (Object)1));
        ParagliderVillageStructures.appendPool((class_2378<class_3785>)reg, new class_2960("village/snowy/houses"), Pair.of((Object)class_3784.method_30425((String)"paraglider:snowy_village_horned_statue"), (Object)1));
        ParagliderVillageStructures.appendPool((class_2378<class_3785>)reg, new class_2960("village/taiga/houses"), Pair.of((Object)class_3784.method_30425((String)"paraglider:kakariko_village_goddess_statue"), (Object)3), Pair.of((Object)class_3784.method_30425((String)"paraglider:taiga_village_horned_statue"), (Object)1));
        ParagliderMod.LOGGER.debug("Finished adding village structures");
    }

    @SafeVarargs
    private static void appendPool(class_2378<class_3785> templatePoolRegistry, class_2960 id, Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer> ... elementToWeight) {
        class_3785 pool = (class_3785)templatePoolRegistry.method_10223(id);
        if (pool == null) {
            ParagliderMod.LOGGER.warn("Template pool '{}' doesn't exist", (Object)id);
            return;
        }
        if (elementToWeight.length == 0) {
            return;
        }
        ArrayList<Pair> newWeightedPool = new ArrayList<Pair>(pool.field_16864.size() + elementToWeight.length);
        newWeightedPool.addAll(pool.field_16864);
        for (Pair<Function<class_3785.class_3786, ? extends class_3784>, Integer> p : elementToWeight) {
            newWeightedPool.add(Pair.of((Object)((class_3784)((Function)p.getFirst()).apply(class_3785.class_3786.field_16687)), (Object)((Integer)p.getSecond())));
        }
        pool.field_16864 = newWeightedPool;
        pool.field_16680.clear();
        for (Pair pair : pool.field_16864) {
            class_3784 structurepoolelement = (class_3784)pair.getFirst();
            for (int i = 0; i < (Integer)pair.getSecond(); ++i) {
                pool.field_16680.add((Object)structurepoolelement);
            }
        }
        ParagliderMod.LOGGER.debug("Added {} elements to template pool '{}'", (Object)elementToWeight.length, (Object)id);
    }
}

