/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client.screen;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.client.ParagliderClientSettings;
import tictim.paraglider.client.screen.BargainScreen;
import tictim.paraglider.client.screen.StaminaWheelSettingScreen;

public class ParagliderSettingScreen
extends class_437 {
    private final class_2561 saveButtonText = class_2561.method_43471((String)"paragliderSettings.save");
    private final class_2561 saveButtonTextUnsaved = class_2561.method_43471((String)"paragliderSettings.save.unsaved");
    private final List<class_339> widgets = new ArrayList<class_339>();
    @Nullable
    private ParticleSliderWidget particleSliderWidget;
    @Nullable
    private class_4185 saveSettingsButton;
    @Nullable
    private SaveLoadAction saveLoadAction;

    public ParagliderSettingScreen() {
        super((class_2561)class_2561.method_43473());
    }

    public void saveSettings() {
        if (this.particleSliderWidget != null && this.particleSliderWidget.dirty) {
            ParagliderClientSettings.get().setWindParticleFrequency(this.particleSliderWidget.value());
            this.particleSliderWidget.dirty = false;
        }
        SaveLoadAction saveLoadAction = new SaveLoadAction(false, null);
        class_156.method_27958().execute(() -> saveLoadAction.notifySaveResult(ParagliderClientSettings.get().save()));
        this.saveLoadAction = saveLoadAction;
    }

    public void loadSettings() {
        this.enableWidgets(false);
        SaveLoadAction saveLoadAction = new SaveLoadAction(true, b -> this.enableWidgets(true));
        class_156.method_27958().execute(() -> saveLoadAction.notifySaveResult(ParagliderClientSettings.get().load()));
        this.saveLoadAction = saveLoadAction;
    }

    private void enableWidgets(boolean enabled) {
        for (class_339 widget : this.widgets) {
            widget.field_22763 = enabled;
        }
    }

    protected void method_25426() {
        this.widgets.clear();
        this.widgets.add((class_339)class_4185.method_46430((class_2561)class_2561.method_43471((String)"paragliderSettings.staminaWheelSettings"), b -> Objects.requireNonNull(this.field_22787).method_1507((class_437)new StaminaWheelSettingScreen(this))).method_46437(128, 20).method_46431());
        this.particleSliderWidget = new ParticleSliderWidget(128, 20, this.particleSliderWidget);
        this.widgets.add((class_339)this.particleSliderWidget);
        int totalHeight = (this.widgets.size() - 1) * 10;
        for (class_339 w : this.widgets) {
            totalHeight += w.method_25364();
        }
        int y = (this.field_22790 - totalHeight) / 2;
        for (class_339 w : this.widgets) {
            w.method_46421((this.field_22789 - w.method_25368()) / 2);
            w.method_46419(y);
            y += w.method_25364() + 10;
        }
        this.saveSettingsButton = class_4185.method_46430((class_2561)this.saveButtonText, b -> this.saveSettings()).method_46434(this.field_22789 - 128 - 10, this.field_22790 - 20 - 10 - 20 - 10 - 20 - 10, 128, 20).method_46431();
        this.widgets.add((class_339)this.saveSettingsButton);
        this.widgets.add((class_339)class_4185.method_46430((class_2561)class_2561.method_43471((String)"paragliderSettings.openFolder"), b -> class_156.method_668().method_673(ParagliderClientSettings.get().configPath().getParent().toUri())).method_46434(this.field_22789 - 128 - 10, this.field_22790 - 20 - 10 - 20 - 10, 128, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"paragliderSettings.openFolder.tooltip"))).method_46431());
        this.widgets.add((class_339)class_4185.method_46430((class_2561)class_2561.method_43471((String)"paragliderSettings.reload"), b -> this.loadSettings()).method_46434(this.field_22789 - 128 - 10, this.field_22790 - 20 - 10, 128, 20).method_46431());
        for (class_339 widget : this.widgets) {
            this.method_37063((class_364)widget);
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(graphics);
        if (this.saveSettingsButton != null) {
            this.saveSettingsButton.method_25355(this.particleSliderWidget != null && this.particleSliderWidget.dirty ? this.saveButtonTextUnsaved : this.saveButtonText);
        }
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        if (this.saveLoadAction != null) {
            int alpha;
            this.saveLoadAction.update();
            int n = alpha = !this.saveLoadAction.isComplete() ? 255 : BargainScreen.getDialogAlpha(ParagliderUtils.ms() - this.saveLoadAction.saveCompleteTimestamp);
            if (alpha == 0) {
                this.saveLoadAction = null;
            } else {
                class_2561 class_25612 = this.saveLoadAction.text();
                Objects.requireNonNull(this.field_22793);
                graphics.method_51439(this.field_22793, class_25612, 5, this.field_22790 - 9 - 5, alpha << 24 | 0xFFFFFF, true);
            }
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        class_3675.class_306 mouseKey = class_3675.method_15985((int)keyCode, (int)scanCode);
        if (ParagliderUtils.isActiveAndMatches(this.field_22787.field_1690.field_1822, mouseKey) || ParagliderUtils.getKey(ParagliderMod.instance().getParagliderSettingsKey()).equals((Object)mouseKey)) {
            this.method_25419();
            return true;
        }
        return false;
    }

    private static final class ParticleSliderWidget
    extends class_357 {
        private boolean dirty;
        private static final DecimalFormat fmt = new DecimalFormat("0%");

        public ParticleSliderWidget(int width, int height, @Nullable ParticleSliderWidget prevInstance) {
            super(0, 0, width, height, (class_2561)class_2561.method_43473(), 0.0);
            if (prevInstance != null) {
                this.method_47400(prevInstance.method_51254());
                this.method_25355(prevInstance.method_25369());
                this.field_22753 = prevInstance.field_22753;
                this.dirty = prevInstance.dirty;
            } else {
                this.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"paragliderSettings.windParticleFreq.tooltip")));
                this.field_22753 = ParagliderClientSettings.get().windParticleFrequency();
                this.method_25355(ParticleSliderWidget.message(this.field_22753));
                this.dirty = false;
            }
        }

        public double value() {
            return this.field_22753;
        }

        protected void method_25346() {
            this.method_25355(ParticleSliderWidget.message(this.field_22753));
        }

        protected void method_25344() {
            this.dirty = true;
        }

        private static class_2561 message(double value) {
            return class_2561.method_43469((String)"paragliderSettings.windParticleFreq", (Object[])new Object[]{fmt.format(value)});
        }
    }

    private static final class SaveLoadAction {
        private final boolean isLoading;
        @Nullable
        private BooleanConsumer callback;
        private volatile State state = State.WAITING;
        private volatile long saveCompleteTimestamp;

        private SaveLoadAction(boolean isLoading, @Nullable BooleanConsumer callback) {
            this.isLoading = isLoading;
            this.callback = callback;
        }

        void update() {
            if (this.callback != null && this.isComplete()) {
                this.callback.accept(this.state == State.SUCCESS);
                this.callback = null;
            }
        }

        void notifySaveResult(boolean success) {
            if (this.state != State.WAITING) {
                return;
            }
            this.state = success ? State.SUCCESS : State.FAIL;
            this.saveCompleteTimestamp = ParagliderUtils.ms();
        }

        boolean isComplete() {
            return this.state != State.WAITING;
        }

        @NotNull
        class_2561 text() {
            return this.isLoading ? this.state.loadText : this.state.saveText;
        }

        static enum State {
            WAITING("paragliderSettings.saving", "paragliderSettings.loading"),
            SUCCESS("paragliderSettings.saving.success", "paragliderSettings.loading.success"),
            FAIL("paragliderSettings.saving.failure", "paragliderSettings.loading.failure", class_124.field_1061);

            final class_2561 saveText;
            final class_2561 loadText;

            private State(String saveKey, String loadKey) {
                this.saveText = class_2561.method_43471((String)saveKey);
                this.loadText = class_2561.method_43471((String)loadKey);
            }

            private State(String saveKey, String loadKey, class_124 fmt) {
                this.saveText = class_2561.method_43471((String)saveKey).method_27692(fmt);
                this.loadText = class_2561.method_43471((String)loadKey).method_27692(fmt);
            }
        }
    }
}

