/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_6382;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.bargain.Bargain;
import tictim.paraglider.api.bargain.DemandPreview;
import tictim.paraglider.api.bargain.OfferPreview;
import tictim.paraglider.bargain.BargainCatalog;
import tictim.paraglider.client.render.BargainScreenStaminaWheelRenderer;
import tictim.paraglider.client.render.StaminaWheelRenderer;
import tictim.paraglider.client.screen.DisableStaminaRender;
import tictim.paraglider.network.ParagliderNetwork;

public class BargainScreen
extends class_437
implements DisableStaminaRender {
    private static final class_2960 MERCHANT_GUI_TEXTURE = new class_2960("textures/gui/container/villager2.png");
    private static final long ITEM_CYCLE_TIME = 1000L;
    private static final long DIALOG_FADEOUT_START = 1750L;
    private static final long DIALOG_FADEOUT_END = 2000L;
    private static final int SCROLL_BOX_THING_WIDTH = 97;
    private static final int SCROLL_BOX_THING_HEIGHT = 142;
    public final int sessionId;
    private final BargainButton[] buttons = new BargainButton[7];
    private Map<class_2960, BargainCatalog> catalog;
    private List<Pair<BargainCatalog, Bargain>> catalogByOrder;
    private int buttonIndexOffset;
    private boolean isDragging;
    private long createdTime;
    private long currentTickTimestamp;
    @Nullable
    private class_243 lookAt;
    @Nullable
    private class_2561 dialog;
    private long dialogTimestamp;
    private boolean dialogUpdated;
    private StaminaWheelRenderer staminaWheelRenderer;
    private static final int BUTTON_INPUT_X_OFFSET_START = 2;
    private static final int BUTTON_INPUT_X_OFFSET_END = 22;
    private static final int BUTTON_OUTPUT_X_OFFSET_START = 50;
    private static final int BUTTON_OUTPUT_X_OFFSET_END = 70;

    public static int getDialogAlpha(long elapsedTime) {
        if (elapsedTime >= 2000L) {
            return 0;
        }
        if (elapsedTime <= 1750L) {
            return 255;
        }
        int alpha = class_3532.method_15340((int)((int)((2000L - elapsedTime) * 255L / 250L)), (int)0, (int)255);
        return alpha > 4 ? alpha : 0;
    }

    public BargainScreen(int sessionId, @NotNull Map<class_2960, BargainCatalog> catalog, @Nullable class_243 lookAt, @Nullable class_2561 dialog) {
        super((class_2561)class_2561.method_43473());
        this.sessionId = sessionId;
        this.setCatalog(catalog);
        this.setLookAt(lookAt);
        this.setDialog(dialog);
    }

    public void setCatalog(@NotNull Map<class_2960, BargainCatalog> catalog) {
        this.catalog = catalog;
        this.catalogByOrder = catalog.values().stream().sorted(Comparator.comparing(BargainCatalog::bargain)).map(key -> Pair.of((Object)key, (Object)BargainScreen.getBargain(key.bargain()))).toList();
    }

    @Nullable
    private static Bargain getBargain(class_2960 id) {
        Bargain b;
        Object t;
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return null;
        }
        class_1863 recipeManager = mc.field_1687.method_8433();
        Optional optionalRecipe = recipeManager.method_8130(id);
        return optionalRecipe.isPresent() && (t = optionalRecipe.get()) instanceof Bargain ? (b = (Bargain)t) : null;
    }

    public void setLookAt(@Nullable class_243 lookAt) {
        this.lookAt = lookAt;
    }

    public void setDialog(@Nullable class_2561 dialog) {
        this.dialog = dialog;
        this.dialogUpdated = dialog != null;
    }

    protected void method_25426() {
        this.currentTickTimestamp = this.createdTime = ParagliderUtils.ms();
        this.staminaWheelRenderer = new BargainScreenStaminaWheelRenderer();
        super.method_25426();
        int y = this.getTop() + 1;
        for (int i = 0; i < 7; ++i) {
            this.buttons[i] = (BargainButton)this.method_37063((class_364)new BargainButton(31, y + 20 * i, i));
        }
    }

    public int getLeft() {
        return 30;
    }

    public int getTop() {
        return (this.field_22790 - 142) / 2;
    }

    public int getBottom() {
        return this.getTop() + 142;
    }

    private void renderScroller(class_332 guiGraphics, int left, int top) {
        int yOffset;
        int offScreenBargains = this.catalog.size() + 1 - 7;
        if (offScreenBargains > 1) {
            int j = 139 - (27 + (offScreenBargains - 1) * 139 / offScreenBargains);
            int k = 1 + j / offScreenBargains + 139 / offScreenBargains;
            yOffset = Math.min(113, this.buttonIndexOffset * k);
            if (this.buttonIndexOffset == offScreenBargains - 1) {
                yOffset = 113;
            }
        } else {
            yOffset = 0;
        }
        guiGraphics.method_25291(MERCHANT_GUI_TEXTURE, left + 90, top + 1 + yOffset, 0, 0.0f, 199.0f, 6, 27, 512, 256);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(guiGraphics);
        long newTimestamp = ParagliderUtils.ms();
        if (BargainScreen.method_25442()) {
            this.createdTime += newTimestamp - this.currentTickTimestamp;
        }
        this.currentTickTimestamp = newTimestamp;
        this.renderBg(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        for (BargainButton button : this.buttons) {
            button.renderToolTip(guiGraphics, mouseX, mouseY);
        }
        this.processLookAt(partialTicks);
    }

    protected void renderBg(class_332 guiGraphics) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_25290(MERCHANT_GUI_TEXTURE, this.getLeft(), this.getTop(), 4.0f, 17.0f, 97, 142, 512, 256);
        this.staminaWheelRenderer.renderStamina(guiGraphics, this.getLeft() + 97 + 5, this.getTop() - 5 - 10, 0.0);
        if (this.dialog != null) {
            int alpha;
            if (this.dialogUpdated) {
                this.dialogTimestamp = this.currentTickTimestamp;
                this.dialogUpdated = false;
            }
            if ((alpha = BargainScreen.getDialogAlpha(this.currentTickTimestamp - this.dialogTimestamp)) > 0) {
                guiGraphics.method_27534(this.field_22793, this.dialog, this.field_22789 / 2, this.getBottom() + 9, alpha << 24 | 0xFFFFFF);
            }
        }
        if (!this.catalog.isEmpty()) {
            this.renderScroller(guiGraphics, this.getLeft(), this.getTop());
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
            for (BargainButton button : this.buttons) {
                button.renderItems(guiGraphics);
            }
            guiGraphics.method_51448().method_22909();
            for (BargainButton button : this.buttons) {
                if (button.method_49606()) {
                    this.renderPreview(guiGraphics, button.actualIndex());
                }
                button.field_22764 = button.index < this.catalog.size();
            }
            RenderSystem.enableDepthTest();
        }
    }

    public void method_25420(class_332 guiGraphics) {
        if (this.field_22787.field_1687 != null) {
            guiGraphics.method_25296(0, 0, this.field_22789, this.field_22790, 0x70101010, -1609560048);
        } else {
            this.method_25434(guiGraphics);
        }
    }

    @Nullable
    private Pair<BargainCatalog, Bargain> getBargain(int bargainIndex) {
        return bargainIndex < 0 || bargainIndex >= this.catalogByOrder.size() ? null : this.catalogByOrder.get(bargainIndex);
    }

    private void renderPreview(class_332 guiGraphics, int bargainIndex) {
        int textMag;
        Pair<BargainCatalog, Bargain> pair = this.getBargain(bargainIndex);
        if (pair == null) {
            return;
        }
        Bargain bargain = (Bargain)pair.getSecond();
        if (bargain == null) {
            BargainCatalog catalog = (BargainCatalog)pair.getFirst();
            int left = this.getLeft() + 97 + 20;
            int top = this.getTop();
            guiGraphics.method_25303(this.field_22793, catalog.bargain().toString(), left, top, 0xFF0000);
            return;
        }
        List<DemandPreview> demands = bargain.previewDemands();
        if (demands.isEmpty()) {
            return;
        }
        BargainCatalog catalog = (BargainCatalog)pair.getFirst();
        int mag = demands.size() <= 2 ? 8 : (demands.size() <= 8 ? 4 : 2);
        int n = textMag = demands.size() <= 8 ? 2 : 1;
        int rows = demands.size() <= 2 ? 2 : (demands.size() <= 8 ? 4 : 8);
        int left = this.getLeft() + 97 + 20;
        int top = this.getTop();
        for (int i = 0; i < demands.size(); ++i) {
            DemandPreview demand = demands.get(i);
            int xOff = left + i % rows * (16 * mag);
            int yOff = top + i / rows * (16 * mag);
            class_4587 modelViewStack = RenderSystem.getModelViewStack();
            modelViewStack.method_22903();
            modelViewStack.method_46416((float)xOff, (float)yOff, 0.0f);
            modelViewStack.method_22905((float)mag, (float)mag, 1.0f);
            RenderSystem.applyModelViewMatrix();
            guiGraphics.method_51445(this.cycle(demand.preview()), 0, 0);
            modelViewStack.method_22909();
            RenderSystem.applyModelViewMatrix();
            int count = catalog.getCount(i);
            String s = (Serializable)(count >= demand.quantity() ? Integer.valueOf(count) : "" + class_124.field_1061 + count + class_124.field_1070) + "/" + demand.quantity();
            class_4587 pose = new class_4587();
            pose.method_46416((float)xOff, (float)yOff, 0.0f);
            pose.method_46416((float)(15 * mag + 2 * textMag), (float)(16 * mag - 7 * textMag), 200.0f);
            pose.method_22905((float)textMag, (float)textMag, 1.0f);
            this.field_22793.method_27521(s, (float)(-this.field_22793.method_1727(s)), 0.0f, -1, true, pose.method_23760().method_23761(), (class_4597)guiGraphics.method_51450(), class_327.class_6415.field_33993, 0, 0xF000F0);
            guiGraphics.method_51452();
        }
    }

    private void processLookAt(float partialTicks) {
        if (this.lookAt == null) {
            return;
        }
        class_746 player = this.field_22787.field_1724;
        class_243 eyePosition = player.method_5836(partialTicks);
        double lookX = this.lookAt.method_10216() - eyePosition.field_1352;
        double lookY = this.lookAt.method_10214() - eyePosition.field_1351;
        double lookZ = this.lookAt.method_10215() - eyePosition.field_1350;
        double xzLength = Math.sqrt(lookX * lookX + lookZ * lookZ);
        double rotationPitch = class_3532.method_15393((float)((float)(-class_3532.method_15349((double)lookY, (double)xzLength) * 57.29577951308232)));
        double rotationYaw = class_3532.method_15393((float)((float)(class_3532.method_15349((double)lookZ, (double)lookX) * 57.29577951308232) - 90.0f));
        double lerpPercentage = (double)partialTicks * 0.3;
        player.method_36457(BargainScreen.lerpAngle(lerpPercentage, class_3532.method_15393((float)player.method_36455()), rotationPitch));
        player.method_36456(BargainScreen.lerpAngle(lerpPercentage, class_3532.method_15393((float)player.method_36454()), rotationYaw));
        player.method_5847(player.method_36454());
        player.field_6004 = player.method_36455();
        player.field_5982 = player.method_36454();
        player.field_6259 = player.field_6241;
        player.field_6220 = player.field_6283 = player.field_6241;
    }

    private static float lerpAngle(double percentage, double start, double end) {
        return (float)class_3532.method_16436((double)percentage, (double)(start < end ? (end - start > 180.0 ? start + 360.0 : start) : (start - end > 180.0 ? start - 360.0 : start)), (double)end);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        int bargainSize = this.catalog.size();
        if (bargainSize > 7) {
            this.buttonIndexOffset = class_3532.method_15340((int)((int)((double)this.buttonIndexOffset - delta)), (int)0, (int)(bargainSize - 7));
        }
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.isDragging) {
            return super.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        int offScreenBargains = this.catalog.size() - 7;
        this.buttonIndexOffset = class_3532.method_15340((int)((int)((mouseY - (double)this.getTop() + 1.0 - 13.5) / 112.0 * (double)offScreenBargains + 0.5)), (int)0, (int)offScreenBargains);
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.isDragging = false;
        int left = this.getLeft();
        int top = this.getTop();
        if (this.catalog.size() > 7 && mouseX > (double)(left + 90) && mouseX < (double)(left + 90 + 6) && mouseY > (double)(top + 1) && mouseY <= (double)(top + 1 + 139 + 1)) {
            this.isDragging = true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers) || this.field_22787 == null) {
            return true;
        }
        class_3675.class_306 key = class_3675.method_15985((int)keyCode, (int)scanCode);
        if (ParagliderUtils.isActiveAndMatches(this.field_22787.field_1690.field_1822, key)) {
            this.method_25419();
            return true;
        }
        return false;
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25419() {
        ParagliderNetwork.get().bargainEndToServer(this.sessionId);
        super.method_25419();
    }

    @NotNull
    private class_1799 cycle(@NotNull List<class_1799> stacks) {
        int i = this.cycleIndex(stacks.size());
        return i < 0 || i >= stacks.size() ? class_1799.field_8037 : stacks.get(i);
    }

    private int cycleIndex(int counts) {
        if (counts <= 0) {
            return -1;
        }
        return (int)(Math.abs(this.currentTickTimestamp - this.createdTime) / 1000L % (long)counts);
    }

    private static int determineItemPosition(int n, int length, int start, int end) {
        if (n >= length) {
            throw new IllegalArgumentException("length");
        }
        if (end < start) {
            throw new IllegalArgumentException("end < start");
        }
        if (length == 1) {
            return (start + end) / 2;
        }
        int span = end - start;
        int spanPerElement = Math.min(16, span / (length - 1));
        if (spanPerElement == 0) {
            return start - (length - 1 - span) / 2 + n;
        }
        int leftover = span % spanPerElement;
        return start + leftover / 2 + spanPerElement * n;
    }

    private final class BargainButton
    extends class_4264 {
        private final int index;
        @Nullable
        private class_1799 fallbackIcon;

        public BargainButton(int x, int y, int index) {
            super(x, y, 89, 20, (class_2561)class_2561.method_43473());
            this.index = index;
            this.field_22764 = false;
        }

        public void method_25306() {
            BargainCatalog catalog = this.catalog();
            if (catalog != null) {
                ParagliderNetwork.get().bargain(BargainScreen.this.sessionId, catalog.bargain());
            }
        }

        public int actualIndex() {
            return this.index + BargainScreen.this.buttonIndexOffset;
        }

        @Nullable
        public BargainCatalog catalog() {
            Pair<BargainCatalog, Bargain> pair = BargainScreen.this.getBargain(this.actualIndex());
            return pair == null ? null : (BargainCatalog)pair.getFirst();
        }

        @Nullable
        public Bargain bargain() {
            Pair<BargainCatalog, Bargain> pair = BargainScreen.this.getBargain(this.actualIndex());
            return pair == null ? null : (Bargain)pair.getSecond();
        }

        private void renderTradeIndicator(class_332 guiGraphics) {
            BargainCatalog catalog = this.catalog();
            RenderSystem.enableBlend();
            guiGraphics.method_25291(MERCHANT_GUI_TEXTURE, this.method_46426() + 39, this.method_46427() + 5, 0, catalog == null || catalog.canBargain() ? 15.0f : 25.0f, 171.0f, 10, 9, 512, 256);
        }

        protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
            BargainCatalog catalog = this.catalog();
            this.field_22763 = catalog != null && catalog.canBargain();
            super.method_48579(guiGraphics, mouseX, mouseY, partialTicks);
            this.field_22763 = true;
            this.renderTradeIndicator(guiGraphics);
        }

        public void method_48589(class_332 guiGraphics, class_327 font, int color) {
        }

        private class_1799 fallbackIcon() {
            if (this.fallbackIcon != null) {
                return this.fallbackIcon;
            }
            this.fallbackIcon = new class_1799((class_1935)class_1802.field_8077);
            return this.fallbackIcon;
        }

        private void renderItems(class_332 guiGraphics) {
            int itemX;
            class_1799 stack;
            if (!this.field_22764) {
                return;
            }
            Bargain bargain = this.bargain();
            if (bargain == null) {
                return;
            }
            List<DemandPreview> demands = bargain.previewDemands();
            for (int i = demands.size() - 1; i >= 0; --i) {
                DemandPreview demand = demands.get(i);
                List<class_1799> stacks = demand.preview();
                if (stacks.isEmpty()) {
                    stack = this.fallbackIcon();
                } else {
                    stack = BargainScreen.this.cycle(stacks);
                    if (stack.method_7960()) {
                        stack = this.fallbackIcon();
                    }
                }
                itemX = this.method_46426() + BargainScreen.determineItemPosition(i, demands.size(), 2, 22);
                guiGraphics.method_51445(stack, itemX, this.method_46427() + 2);
                if (demand.quantity() == 1) continue;
                guiGraphics.method_51432(BargainScreen.this.field_22793, stack, itemX, this.method_46427() + 2, String.valueOf(demand.quantity()));
            }
            List<OfferPreview> offers = bargain.previewOffers();
            for (int i = offers.size() - 1; i >= 0; --i) {
                OfferPreview offer = offers.get(i);
                stack = offer.preview();
                if (stack.method_7960()) {
                    stack = this.fallbackIcon();
                }
                itemX = this.method_46426() + BargainScreen.determineItemPosition(i, offers.size(), 50, 70);
                guiGraphics.method_51445(stack, itemX, this.method_46427() + 2);
                if (offer.quantity() == 1) continue;
                guiGraphics.method_51432(BargainScreen.this.field_22793, stack, itemX, this.method_46427() + 2, String.valueOf(offer.quantity()));
            }
        }

        private void renderToolTip(class_332 guiGraphics, int mouseX, int mouseY) {
            if (!this.field_22762) {
                return;
            }
            Bargain bargain = this.bargain();
            if (bargain == null) {
                return;
            }
            List<DemandPreview> demands = bargain.previewDemands();
            DemandPreview closestDemand = null;
            int closestDemandDistance = Integer.MAX_VALUE;
            for (int i = 0; i < demands.size(); ++i) {
                int itemX = this.method_46426() + BargainScreen.determineItemPosition(i, demands.size(), 2, 22);
                if (mouseX < itemX || mouseX >= itemX + 16) continue;
                int dist = Math.abs(itemX + 8 - mouseX);
                if (closestDemandDistance <= dist) break;
                closestDemandDistance = dist;
                closestDemand = demands.get(i);
            }
            if (closestDemand != null) {
                List<class_1799> preview = closestDemand.preview();
                int i = BargainScreen.this.cycleIndex(preview.size());
                guiGraphics.method_51434(BargainScreen.this.field_22793, i < 0 || i >= preview.size() ? List.of(class_2561.method_43470((String)"No Preview")) : closestDemand.getTooltip(i), mouseX, mouseY);
                return;
            }
            List<OfferPreview> offers = bargain.previewOffers();
            OfferPreview closestOffer = null;
            int closestOfferDistance = Integer.MAX_VALUE;
            for (int i = 0; i < offers.size(); ++i) {
                int itemX = this.method_46426() + BargainScreen.determineItemPosition(i, offers.size(), 50, 70);
                if (mouseX < itemX || mouseX >= itemX + 16) continue;
                int dist = Math.abs(itemX + 8 - mouseX);
                if (closestOfferDistance <= dist) break;
                closestOfferDistance = dist;
                closestOffer = offers.get(i);
            }
            if (closestOffer != null) {
                guiGraphics.method_51434(BargainScreen.this.field_22793, closestOffer.getTooltip(), mouseX, mouseY);
            }
        }

        protected void method_47399(class_6382 o) {
        }
    }
}

