/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_241;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_746;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.api.ParagliderAPI;
import tictim.paraglider.api.item.Paraglider;
import tictim.paraglider.config.Cfg;
import tictim.paraglider.config.DebugCfg;

public abstract class StaminaWheelRenderer {
    private final Wheel wheel = new Wheel();
    private static final double[] renderPoints = new double[]{0.0, 0.125, 0.375, 0.625, 0.875, 1.0};

    public void renderStamina(@NotNull class_332 graphics, double x, double y, double z) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        this.makeWheel((class_1657)player, this.wheel);
        this.render(graphics, this.wheel, x, y, z, this.isDebugEnabled((class_1657)player));
        this.wheel.reset();
    }

    protected boolean isDebugEnabled(@NotNull class_1657 player) {
        return DebugCfg.get().debugPlayerMovement() && player.method_6079().method_7909() instanceof Paraglider;
    }

    protected abstract void makeWheel(@NotNull class_1657 var1, @NotNull Wheel var2);

    protected void render(@NotNull class_332 graphics, @NotNull Wheel wheel, double x, double y, double z, boolean debug) {
        RenderSystem.disableDepthTest();
        if (debug) {
            class_327 font = class_310.method_1551().field_1772;
            for (int i = 0; i < wheel.count; ++i) {
                String string = wheel.entries.get(i).toString();
                Objects.requireNonNull(font);
                graphics.method_25303(font, string, 20, 10 + 9 * i, -1);
            }
        }
        StaminaWheelRenderer.draw(graphics, wheel, x, y, z, 10.0, debug);
    }

    private static void draw(@NotNull class_332 graphics, @NotNull Wheel wheel, double x, double y, double z, double radius, boolean debug) {
        ArrayList<class_241> debugVertices = debug ? new ArrayList<class_241>() : null;
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        for (WheelLevel wheelLevel : WheelLevel.values()) {
            for (int i = 0; i < wheel.count; ++i) {
                double currentStart;
                double end;
                double start;
                Wheel.Entry entry = wheel.entries.get(i);
                int alpha = class_5253.class_5254.method_27762((int)entry.color);
                if (alpha <= 0 || (start = wheelLevel.getProportion(entry.from)) >= 1.0 || (end = wheelLevel.getProportion(entry.to)) <= 0.0) continue;
                RenderSystem.setShaderColor((float)((float)class_5253.class_5254.method_27765((int)entry.color) / 255.0f), (float)((float)class_5253.class_5254.method_27766((int)entry.color) / 255.0f), (float)((float)class_5253.class_5254.method_27767((int)entry.color) / 255.0f), (float)((float)alpha / 255.0f));
                RenderSystem.setShaderTexture((int)0, (class_2960)wheelLevel.texture);
                class_289 tesselator = class_289.method_1348();
                class_287 b = tesselator.method_1349();
                b.method_1328(class_293.class_5596.field_27381, class_290.field_1585);
                b.method_22912(x, y, z).method_22913(0.5f, 0.5f).method_1344();
                for (int j = 0; j < renderPoints.length - 1 && !((currentStart = renderPoints[j]) >= end); ++j) {
                    double currentEnd = renderPoints[j + 1];
                    if (currentEnd <= start) continue;
                    if (currentStart <= start) {
                        StaminaWheelRenderer.vert(b, x, y, z, start, radius, debugVertices);
                    }
                    if (currentEnd >= end) break;
                    StaminaWheelRenderer.vert(b, x, y, z, currentEnd, radius, debugVertices);
                }
                StaminaWheelRenderer.vert(b, x, y, z, end, radius, debugVertices);
                tesselator.method_1350();
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (debugVertices != null) {
            class_4587 stack = graphics.method_51448();
            stack.method_22903();
            stack.method_22904(x, y, z);
            class_327 font = class_310.method_1551().field_1772;
            for (class_241 vec : debugVertices) {
                float f;
                String s = vec.field_1343 + " " + vec.field_1342;
                int n = (int)(vec.field_1343 > 0.0f ? vec.field_1343 * (float)radius + 2.0f : vec.field_1343 * (float)radius - 2.0f - (float)font.method_1727(s));
                if (vec.field_1342 > 0.0f) {
                    float f2 = vec.field_1342 * (float)(-radius) - 2.0f;
                    Objects.requireNonNull(font);
                    f = f2 - 9.0f;
                } else {
                    f = vec.field_1342 * (float)(-radius) + 2.0f;
                }
                graphics.method_25303(font, s, n, (int)f, -16711936);
            }
            stack.method_22909();
        }
    }

    private static void vert(class_287 b, double x, double y, double z, double point, double radius, @Nullable List<class_241> debugVertices) {
        double vy;
        double vx;
        if (point == 0.0 || point == 1.0) {
            vx = 0.0;
            vy = 1.0;
        } else if (point == 0.125) {
            vx = -1.0;
            vy = 1.0;
        } else if (point == 0.375) {
            vx = -1.0;
            vy = -1.0;
        } else if (point == 0.625) {
            vx = 1.0;
            vy = -1.0;
        } else if (point == 0.875) {
            vx = 1.0;
            vy = 1.0;
        } else if (point < 0.125 || point > 0.875) {
            vx = -Math.tan(point * (Math.PI * 2));
            vy = 1.0;
        } else if (point < 0.375) {
            vx = -1.0;
            vy = 1.0 / Math.tan(point * (Math.PI * 2));
        } else if (point < 0.625) {
            vx = Math.tan(point * (Math.PI * 2));
            vy = -1.0;
        } else {
            vx = 1.0;
            vy = -1.0 / Math.tan(point * (Math.PI * 2));
        }
        b.method_22912(x + vx * radius, y + vy * -radius, z).method_22913((float)(vx / 2.0 + 0.5), (float)(vy / 2.0 + 0.5)).method_1344();
        if (debugVertices != null) {
            debugVertices.add(new class_241((float)vx, (float)vy));
        }
    }

    public static final class Wheel {
        private final List<Entry> entries = new ArrayList<Entry>();
        private int count;

        public void fill(int from, int to, int color) {
            if (from >= to) {
                return;
            }
            for (int i = 0; i < this.count; ++i) {
                Entry e = this.entries.get(i);
                if (e.to <= from) continue;
                this.insert(e.from < from ? i + 1 : i, from, to, color);
                return;
            }
            this.insert(this.count, from, to, color);
        }

        private void insert(int index, int from, int to, int color) {
            int lastIndex = this.entries.size() - 1;
            Entry entry = lastIndex > this.count ? this.entries.remove(lastIndex) : new Entry();
            this.entries.add(index, entry);
            ++this.count;
            entry.from = from;
            entry.to = to;
            entry.color = color;
            for (int i = index + 1; i < this.count; ++i) {
                Entry e = this.entries.get(i);
                if (e.to > to) {
                    e.from = to;
                    return;
                }
                this.remove(i--);
            }
        }

        private void remove(int index) {
            this.entries.add(this.entries.remove(index));
            --this.count;
        }

        public void reset() {
            this.count = 0;
        }

        private static final class Entry {
            private int from;
            private int to;
            private int color;

            private Entry() {
            }

            public String toString() {
                return String.format("%d ~ %d: #%X", this.from, this.to, this.color);
            }
        }
    }

    public static enum WheelLevel {
        FIRST(ParagliderAPI.id("textures/stamina/first.png")),
        SECOND(ParagliderAPI.id("textures/stamina/second.png")),
        THIRD(ParagliderAPI.id("textures/stamina/third.png"));

        public final class_2960 texture;

        private WheelLevel(class_2960 texture) {
            this.texture = Objects.requireNonNull(texture);
        }

        public int start() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case FIRST -> 0;
                case SECOND -> (int)((double)Cfg.get().maxStamina() / 3.0);
                case THIRD -> (int)((double)(Cfg.get().maxStamina() * 2) / 3.0);
            };
        }

        public int end() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case FIRST -> (int)((double)Cfg.get().maxStamina() / 3.0);
                case SECOND -> (int)((double)(Cfg.get().maxStamina() * 2) / 3.0);
                case THIRD -> Cfg.get().maxStamina();
            };
        }

        public double getProportion(int value) {
            int start = this.start();
            if (start >= value) {
                return 0.0;
            }
            int end = this.end();
            if (end <= value) {
                return 1.0;
            }
            return (double)(value - start) / (double)(end - start);
        }
    }
}

