/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderMod;

public final class ParagliderClientSettings {
    private static final double DEFAULT_STAMINA_WHEEL_X = 0.382903981264637;
    private static final double DEFAULT_STAMINA_WHEEL_Y = 0.46875;
    private static final double DEFAULT_PARTICLE_FREQ = 1.0;
    @NotNull
    private final Path configPath;
    private double staminaWheelX = 0.382903981264637;
    private double staminaWheelY = 0.46875;
    private double windParticleFrequency = 1.0;

    @NotNull
    public static ParagliderClientSettings get() {
        return ParagliderMod.instance().getClientSettings();
    }

    public ParagliderClientSettings(@NotNull Path gameDirectory) {
        this.configPath = gameDirectory.resolve("paragliderSettings.nbt");
    }

    @NotNull
    public Path configPath() {
        return this.configPath;
    }

    public double staminaWheelX() {
        return this.staminaWheelX;
    }

    public void setStaminaWheelX(double staminaWheelX) {
        this.staminaWheelX = ParagliderClientSettings.filterBadValue(staminaWheelX, 0.382903981264637);
    }

    public double staminaWheelY() {
        return this.staminaWheelY;
    }

    public void setStaminaWheelY(double staminaWheelY) {
        this.staminaWheelY = ParagliderClientSettings.filterBadValue(staminaWheelY, 0.46875);
    }

    public double windParticleFrequency() {
        return this.windParticleFrequency;
    }

    public void setWindParticleFrequency(double windParticleFrequency) {
        this.windParticleFrequency = ParagliderClientSettings.filterBadValue(windParticleFrequency, 1.0);
    }

    private static double filterBadValue(double d, double defaultValue) {
        if (Double.isNaN(d)) {
            return defaultValue;
        }
        return class_3532.method_15350((double)d, (double)0.0, (double)1.0);
    }

    public void setStaminaWheel(double staminaWheelX, double staminaWheelY) {
        this.setStaminaWheelX(staminaWheelX);
        this.setStaminaWheelY(staminaWheelY);
    }

    public boolean load() {
        try {
            if (Files.exists(this.configPath, new LinkOption[0])) {
                try (DataInputStream dis = new DataInputStream(Files.newInputStream(this.configPath, new OpenOption[0]));){
                    class_2487 tag = class_2507.method_10627((DataInput)dis);
                    class_2487 staminaWheel = tag.method_10562("staminaWheel");
                    this.setStaminaWheelX(staminaWheel.method_10574("x"));
                    this.setStaminaWheelY(staminaWheel.method_10574("y"));
                    this.setWindParticleFrequency(tag.method_10573("windParticleFreq", 8) ? tag.method_10574("windParticleFreq") : 1.0);
                }
            } else {
                this.setStaminaWheelX(0.382903981264637);
                this.setStaminaWheelY(0.46875);
                this.setWindParticleFrequency(1.0);
            }
            return true;
        }
        catch (IOException | RuntimeException ex) {
            ParagliderMod.LOGGER.error("Error occurred while loading paraglider settings: ", (Throwable)ex);
            return false;
        }
    }

    public boolean save() {
        try {
            class_2487 tag = new class_2487();
            class_2487 staminaWheel = new class_2487();
            staminaWheel.method_10549("x", this.staminaWheelX());
            staminaWheel.method_10549("y", this.staminaWheelY());
            tag.method_10566("staminaWheel", (class_2520)staminaWheel);
            tag.method_10549("windParticleFreq", this.windParticleFrequency());
            try (DataOutputStream dos = new DataOutputStream(Files.newOutputStream(this.configPath, StandardOpenOption.CREATE));){
                class_2507.method_10628((class_2487)tag, (DataOutput)dos);
            }
            return true;
        }
        catch (IOException | RuntimeException ex) {
            ParagliderMod.LOGGER.error("Error occurred while saving paraglider settings: ", (Throwable)ex);
            return false;
        }
    }

    public String toString() {
        return "ParagliderClientSettings{configPath=" + this.configPath + ", staminaWheelX=" + this.staminaWheelX + ", staminaWheelY=" + this.staminaWheelY + ", windParticleFrequency=" + this.windParticleFrequency + "}";
    }
}

