/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.villagernames_common_forge.util;

import com.natamus.collective_common_forge.functions.EntityFunctions;
import com.natamus.villagernames_common_forge.config.ConfigHandler;
import com.natamus.villagernames_common_forge.data.Variables;
import com.natamus.villagernames_common_forge.util.Names;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;

public class Util {
    private static final List<String> namesToOverwrite = new ArrayList<String>(Arrays.asList("Bowman", "Crossbowman", "Horseman", "Nomad", "Recruit", "Shieldman"));

    public static boolean shouldOverwriteName(Entity entity) {
        return namesToOverwrite.contains(entity.m_7755_().getString());
    }

    public static MutableComponent getTradeScreenTitle() {
        Component name = (Component)Variables.tradedVillagerPair.getFirst();
        Component profession = (Component)Variables.tradedVillagerPair.getSecond();
        if (!ConfigHandler.showProfessionOnTradeScreen) {
            return name.m_6881_();
        }
        if (name.equals(Component.m_237119_()) || profession.equals(Component.m_237119_())) {
            return null;
        }
        MutableComponent newTitle = Component.m_237119_();
        newTitle = !ConfigHandler.switchNameAndProfessionTradeScreen ? newTitle.m_7220_(name).m_130946_(" | ").m_7220_(profession) : newTitle.m_7220_(profession).m_130946_(" | ").m_7220_(name);
        return newTitle;
    }

    public static int unnameLoadedVillagers(ServerLevel serverLevel) {
        int unnameCount = 0;
        for (Entity entity : serverLevel.m_8583_()) {
            if (!(entity instanceof Villager) && !EntityFunctions.isModdedVillager((Entity)entity) || !entity.m_8077_()) continue;
            entity.m_6593_(null);
            entity.m_20137_("villagernames.named");
            ++unnameCount;
        }
        return unnameCount;
    }

    public static int nameLoadedVillagers(ServerLevel serverLevel) {
        int nameCount = 0;
        for (Entity entity : serverLevel.m_8583_()) {
            if (!(entity instanceof Villager) && !EntityFunctions.isModdedVillager((Entity)entity) || entity.m_8077_()) continue;
            EntityFunctions.nameEntity((Entity)entity, (String)Names.getRandomName());
            entity.m_20049_("villagernames.named");
            ++nameCount;
        }
        return nameCount;
    }

    public static int renameLoadedVillagers(ServerLevel serverLevel) {
        Util.unnameLoadedVillagers(serverLevel);
        return Util.nameLoadedVillagers(serverLevel);
    }
}

