/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.polymorph.common.util;

import com.illusivesoulworks.polymorph.api.common.capability.IBlockEntityRecipeData;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2586;
import net.minecraft.class_3222;

public class BlockEntityTicker {
    private static final Map<class_2586, IBlockEntityRecipeData> TICKABLE_BLOCKS = new ConcurrentHashMap<class_2586, IBlockEntityRecipeData>();

    public static void tick() {
        ArrayList<class_2586> toRemove = new ArrayList<class_2586>();
        for (Map.Entry<class_2586, IBlockEntityRecipeData> entry : TICKABLE_BLOCKS.entrySet()) {
            class_2586 be = entry.getKey();
            if (be.method_11015() || be.method_10997() == null || be.method_10997().method_8608()) {
                toRemove.add(be);
                continue;
            }
            entry.getValue().tick();
        }
        for (class_2586 be : toRemove) {
            TICKABLE_BLOCKS.remove(be);
        }
    }

    public static void add(class_3222 serverPlayer, IBlockEntityRecipeData recipeData) {
        IBlockEntityRecipeData data = TICKABLE_BLOCKS.get(recipeData.getOwner());
        if (data != null) {
            data.addListener(serverPlayer);
        } else {
            recipeData.addListener(serverPlayer);
            TICKABLE_BLOCKS.put((class_2586)recipeData.getOwner(), recipeData);
        }
    }

    public static void remove(class_3222 serverPlayer) {
        ArrayList<class_2586> toRemove = new ArrayList<class_2586>();
        for (Map.Entry<class_2586, IBlockEntityRecipeData> entry : TICKABLE_BLOCKS.entrySet()) {
            entry.getValue().removeListener(serverPlayer);
            if (!entry.getValue().getListeners().isEmpty()) continue;
            toRemove.add(entry.getKey());
        }
        for (class_2586 blockEntity : toRemove) {
            TICKABLE_BLOCKS.remove(blockEntity);
        }
    }

    public static void clear() {
        TICKABLE_BLOCKS.clear();
    }
}

