/*
 * Decompiled with CFR 0.152.
 */
package dev.mrsterner.besmirchment.mixin;

import dev.mrsterner.besmirchment.common.BSMConfig;
import dev.mrsterner.besmirchment.common.entity.ai.DemonAttackWithOwnerGoal;
import dev.mrsterner.besmirchment.common.entity.ai.DemonFollowOwnerGoal;
import dev.mrsterner.besmirchment.common.entity.ai.DemonSitGoal;
import dev.mrsterner.besmirchment.common.entity.ai.DemonTrackAttackerGoal;
import dev.mrsterner.besmirchment.common.entity.interfaces.TameableDemon;
import dev.mrsterner.besmirchment.common.registry.BSMObjects;
import java.util.Optional;
import java.util.UUID;
import moriyashiine.bewitchment.api.BewitchmentAPI;
import moriyashiine.bewitchment.common.entity.DemonMerchant;
import moriyashiine.bewitchment.common.entity.living.DemonEntity;
import moriyashiine.bewitchment.common.entity.living.util.BWHostileEntity;
import moriyashiine.bewitchment.common.item.TaglockItem;
import moriyashiine.bewitchment.common.misc.BWUtil;
import moriyashiine.bewitchment.common.registry.BWMaterials;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1531;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DemonEntity.class})
public abstract class DemonEntityMixin
extends BWHostileEntity
implements TameableDemon,
DemonMerchant {
    private static final class_2940<Byte> TAMEABLE_FLAGS = class_2945.method_12791(DemonEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Optional<UUID>> OWNER_UUID = class_2945.method_12791(DemonEntity.class, (class_2941)class_2943.field_13313);
    private boolean sitting;

    protected DemonEntityMixin(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Nullable
    public class_1309 method_5968() {
        return super.method_5968();
    }

    @Inject(method={"initGoals"}, at={@At(value="HEAD")}, cancellable=true)
    private void initGoals(CallbackInfo ci) {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1366((class_1314)this, 1.0, true));
        this.field_6201.method_6277(3, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1309.class, 10, true, false, entity -> !this.isTamed() && !(entity instanceof class_1531) && BWUtil.getArmorPieces((class_1309)entity, stack -> stack.method_7909() instanceof class_1738 && ((class_1738)stack.method_7909()).method_7686() == BWMaterials.BESMIRCHED_ARMOR) < 3 && (entity.method_6046() != BewitchmentAPI.DEMON || entity instanceof class_1657)));
        this.field_6201.method_6277(1, new DemonSitGoal<DemonEntity>((DemonEntity)this));
        this.field_6201.method_6277(3, new DemonFollowOwnerGoal<DemonEntity>((DemonEntity)this, 1.0, 10.0f, 2.0f, false));
        this.field_6185.method_6277(1, new DemonTrackAttackerGoal<DemonEntity>((DemonEntity)this));
        this.field_6185.method_6277(2, new DemonAttackWithOwnerGoal<DemonEntity>((DemonEntity)this));
        ci.cancel();
    }

    @Inject(method={"interactMob"}, at={@At(value="HEAD")}, cancellable=true)
    private void interactMob(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        class_1799 itemStack = player.method_5998(hand);
        class_1792 item = itemStack.method_7909();
        if (!this.method_37908().field_9236 && this.isTamed() && player.method_5715()) {
            if ((double)this.method_37908().field_9229.method_43057() < 0.1) {
                this.method_6025(2.0f);
                this.method_37908().method_8421((class_1297)this, (byte)7);
            }
            if (item == class_1802.field_17534) {
                this.method_6025(40.0f);
                this.method_6092(new class_1293(class_1294.field_5924, 1, 1200, true, true));
                if (!player.method_31549().field_7477) {
                    itemStack.method_7934(1);
                }
                this.method_37908().method_8421((class_1297)this, (byte)7);
                cir.setReturnValue((Object)class_1269.field_5812);
                return;
            }
            class_1269 actionResult = super.method_5992(player, hand);
            if ((!actionResult.method_23665() || this.method_6109()) && this.isOwner((class_1309)player)) {
                this.setSitting(!this.isSitting());
                player.method_7353((class_2561)class_2561.method_43471((String)("besmirchment.message.demon_" + (this.isSitting() ? "sit" : "follow"))), true);
                this.field_6282 = false;
                this.field_6189.method_6340();
                this.method_5980(null);
                cir.setReturnValue((Object)class_1269.field_5812);
            }
        } else if (BSMConfig.enableTamableDemons && !this.isTamed() && item == BSMObjects.DEMONIC_DEED && TaglockItem.hasTaglock((class_1799)itemStack) && !this.method_6510()) {
            if (!player.method_31549().field_7477) {
                itemStack.method_7956(1, (class_1309)player, breakingPlayer -> itemStack.method_7934(1));
            }
            this.setTamed(true);
            this.setOwnerUuid(TaglockItem.getTaglockUUID((class_1799)itemStack));
            this.field_6189.method_6340();
            this.method_5980(null);
            this.setSitting(true);
            this.method_37908().method_8421((class_1297)this, (byte)7);
            cir.setReturnValue((Object)class_1269.field_5812);
        }
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    public void writeCustomDataToTag(class_2487 tag, CallbackInfo ci) {
        if (this.getOwnerUuid() != null) {
            tag.method_25927("Owner", this.getOwnerUuid());
        }
        tag.method_10556("Sitting", this.sitting);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    public void readCustomDataFromTag(class_2487 tag, CallbackInfo ci) {
        UUID ownerUUID;
        super.method_5749(tag);
        if (tag.method_25928("Owner")) {
            ownerUUID = tag.method_25926("Owner");
        } else {
            String string = tag.method_10558("Owner");
            ownerUUID = class_3321.method_14546((MinecraftServer)this.method_5682(), (String)string);
        }
        if (ownerUUID != null) {
            try {
                this.setOwnerUuid(ownerUUID);
                this.setTamed(true);
            }
            catch (Throwable var4) {
                this.setTamed(false);
            }
        }
        this.sitting = tag.method_10577("Sitting");
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    protected void initDataTracker(CallbackInfo ci) {
        this.field_6011.method_12784(TAMEABLE_FLAGS, (Object)0);
        this.field_6011.method_12784(OWNER_UUID, Optional.empty());
    }

    @Override
    @Unique
    public void showEmoteParticle(boolean positive) {
        class_2400 particleEffect = class_2398.field_11201;
        if (!positive) {
            particleEffect = class_2398.field_11251;
        }
        for (int i = 0; i < 7; ++i) {
            double d = this.field_5974.method_43059() * 0.02;
            double e = this.field_5974.method_43059() * 0.02;
            double f = this.field_5974.method_43059() * 0.02;
            this.method_37908().method_8406((class_2394)particleEffect, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d, e, f);
        }
    }

    @Override
    public boolean isSitting() {
        return this.sitting;
    }

    @Override
    public void setSitting(boolean sitting) {
        this.sitting = sitting;
    }

    @Override
    public boolean isOwner(class_1309 entity) {
        return entity == this.getOwner();
    }

    @Override
    public boolean isTamed() {
        return ((Byte)this.field_6011.method_12789(TAMEABLE_FLAGS) & 4) != 0;
    }

    @Override
    public void setTamed(boolean tamed) {
        byte b = (Byte)this.field_6011.method_12789(TAMEABLE_FLAGS);
        if (tamed) {
            this.field_6011.method_12778(TAMEABLE_FLAGS, (Object)((byte)(b | 4)));
        } else {
            this.field_6011.method_12778(TAMEABLE_FLAGS, (Object)((byte)(b & 0xFFFFFFFB)));
        }
        this.onTamedChanged();
    }

    @Override
    @Nullable
    public UUID getOwnerUuid() {
        return ((Optional)this.field_6011.method_12789(OWNER_UUID)).orElse(null);
    }

    @Override
    public void setOwnerUuid(@Nullable UUID uuid) {
        this.field_6011.method_12778(OWNER_UUID, Optional.ofNullable(uuid));
    }

    @Override
    public void setOwner(class_1657 player) {
        this.setTamed(true);
        this.setOwnerUuid(player.method_5667());
    }

    @Override
    @Nullable
    public class_1309 getOwner() {
        try {
            UUID uUID = this.getOwnerUuid();
            return uUID == null ? null : this.method_37908().method_18470(uUID);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }
}

