/*
 * Decompiled with CFR 0.152.
 */
package dev.mrsterner.besmirchment.common.block.entity;

import dev.mrsterner.besmirchment.common.registry.BSMBlockEntityTypes;
import dev.mrsterner.besmirchment.common.transformation.LichAccessor;
import dev.mrsterner.besmirchment.common.transformation.LichLogic;
import dev.mrsterner.besmirchment.common.world.BSMWorldState;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class PhylacteryBlockEntity
extends class_2586 {
    public static final int MAX_SOULS = 8;
    public int souls;

    public PhylacteryBlockEntity(class_2338 pos, class_2680 state) {
        super(BSMBlockEntityTypes.PHYLACTERY, pos, state);
    }

    public class_2487 method_16887() {
        class_2487 nbt = super.method_16887();
        this.method_11007(nbt);
        return nbt;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void sync(class_1937 world, class_2338 pos) {
        if (world != null && !world.field_9236) {
            world.method_8413(pos, this.method_11010(), this.method_11010(), 2);
        }
    }

    public void method_11007(class_2487 tag) {
        tag.method_10569("Souls", this.souls);
        super.method_11007(tag);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.souls = nbt.method_10550("Souls");
    }

    public int addSouls(int amount) {
        int cachedAmount = this.souls;
        this.souls = class_3532.method_15340((int)(this.souls + amount), (int)0, (int)8);
        this.updatePlayerCache();
        this.method_5431();
        return this.souls - cachedAmount;
    }

    public boolean drainSoul(int amount) {
        if (this.souls - amount >= 0) {
            this.souls -= amount;
            this.updatePlayerCache();
            this.method_5431();
            return true;
        }
        return false;
    }

    public void updatePlayerCache() {
        if (this.field_11863 instanceof class_3218) {
            BSMWorldState worldState = BSMWorldState.get(this.field_11863);
            UUID foundUUID = LichLogic.getPlayerForPhylactery(worldState, this.field_11867);
            if (foundUUID != null) {
                for (class_3222 player : PlayerLookup.all((MinecraftServer)this.field_11863.method_8503())) {
                    if (!player.method_5667().equals(foundUUID)) continue;
                    ((LichAccessor)player).updateCachedSouls();
                }
            }
            worldState.method_80();
        }
    }
}

