/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.ui.container;

import io.wispforest.owo.ui.container.WrappingParentComponent;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;

public class OverlayContainer<C extends Component>
extends WrappingParentComponent<C> {
    protected boolean closeOnClick = true;

    protected OverlayContainer(C child) {
        super(Sizing.fill(100), Sizing.fill(100), child);
        this.positioning(Positioning.absolute(0, 0));
        this.surface(Surface.VANILLA_TRANSLUCENT);
    }

    @Override
    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        super.draw(context, mouseX, mouseY, partialTicks, delta);
        this.drawChildren(context, mouseX, mouseY, partialTicks, delta, this.childView);
    }

    @Override
    public void drawFocusHighlight(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
    }

    @Override
    public void mount(ParentComponent parent, int x, int y) {
        super.mount(parent, x, y);
        this.parent.focusHandler().focus(this, Component.FocusSource.KEYBOARD_CYCLE);
    }

    @Override
    public boolean onMouseDown(double mouseX, double mouseY, int button) {
        boolean handled = super.onMouseDown(mouseX, mouseY, button);
        if (!handled && this.closeOnClick) {
            this.remove();
            return true;
        }
        return handled;
    }

    @Override
    public boolean onKeyPress(int keyCode, int scanCode, int modifiers) {
        boolean handled = super.onKeyPress(keyCode, scanCode, modifiers);
        if (keyCode == 256) {
            this.remove();
            return true;
        }
        return handled;
    }

    @Override
    public boolean canFocus(Component.FocusSource source) {
        return source == Component.FocusSource.KEYBOARD_CYCLE;
    }

    @Override
    protected int childMountX() {
        return ((Insets)this.padding.get()).left() + (this.width - this.child.fullSize().width()) / 2;
    }

    @Override
    protected int childMountY() {
        return ((Insets)this.padding.get()).top() + (this.height() - this.child.fullSize().height()) / 2;
    }

    public OverlayContainer<C> closeOnClick(boolean closeOnClick) {
        this.closeOnClick = closeOnClick;
        return this;
    }

    public boolean closeOnClick() {
        return this.closeOnClick;
    }
}

