/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.bases.McdwSword;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.EnchantmentsID;
import chronosacaria.mcdw.enums.IMeleeWeaponID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import org.jetbrains.annotations.NotNull;

public enum SwordsID implements IMeleeWeaponID,
IInnateEnchantment
{
    SWORD_BEESTINGER(true, (class_1832)class_1834.field_8923, 0, -1.1f, "minecraft:iron_ingot"),
    SWORD_BROADSWORD(true, (class_1832)class_1834.field_8923, 5, -3.0f, "minecraft:iron_ingot"),
    SWORD_BROKEN_SAWBLADE(true, (class_1832)class_1834.field_8923, 3, -2.4f, "minecraft:iron_ingot"),
    SWORD_CLAYMORE(true, (class_1832)class_1834.field_8923, 7, -3.2f, "minecraft:iron_ingot"),
    SWORD_CORAL_BLADE(true, (class_1832)class_1834.field_8923, 3, -2.4f, "minecraft:iron_ingot"),
    SWORD_CUTLASS(true, (class_1832)class_1834.field_8923, 2, -2.3f, "minecraft:iron_ingot"),
    SWORD_DANCERS_SWORD(true, (class_1832)class_1834.field_8923, 3, -2.0f, "minecraft:iron_ingot"),
    SWORD_DARK_KATANA(true, (class_1832)class_1834.field_22033, 4, -2.9f, "minecraft:netherite_scrap"),
    SWORD_DIAMOND_SWORD_VAR(true, (class_1832)class_1834.field_8930, 3, -2.4f, "minecraft:diamond"),
    SWORD_FREEZING_FOIL(true, (class_1832)class_1834.field_8923, 1, -1.1f, "minecraft:iron_ingot"),
    SWORD_FROST_SLAYER(true, (class_1832)class_1834.field_8930, 6, -3.2f, "minecraft:diamond"),
    SWORD_GREAT_AXEBLADE(true, (class_1832)class_1834.field_8923, 7, -3.2f, "minecraft:iron_ingot"),
    SWORD_HAWKBRAND(true, (class_1832)class_1834.field_8923, 6, -2.9f, "minecraft:iron_ingot"),
    SWORD_HEARTSTEALER(true, (class_1832)class_1834.field_8930, 6, -3.2f, "minecraft:diamond"),
    SWORD_IRON_SWORD_VAR(true, (class_1832)class_1834.field_8923, 3, -2.4f, "minecraft:iron_ingot"),
    SWORD_KATANA(true, (class_1832)class_1834.field_8923, 4, -2.9f, "minecraft:iron_ingot"),
    SWORD_MASTERS_KATANA(true, (class_1832)class_1834.field_8930, 4, -2.9f, "minecraft:diamond"),
    SWORD_MECHANIZED_SAWBLADE(true, (class_1832)class_1834.field_8930, 3, -2.4f, "minecraft:blaze_rod"),
    SWORD_NAMELESS_BLADE(true, (class_1832)class_1834.field_8923, 4, -2.3f, "minecraft:iron_ingot"),
    SWORD_OBSIDIAN_CLAYMORE(true, (class_1832)class_1834.field_22033, 6, -3.3f, "minecraft:netherite_scrap"),
    SWORD_RAPIER(true, (class_1832)class_1834.field_8923, 0, -1.14f, "minecraft:iron_ingot"),
    SWORD_SINISTER(true, (class_1832)class_1834.field_8923, 6, -2.9f, "minecraft:iron_ingot"),
    SWORD_SPONGE_STRIKER(true, (class_1832)class_1834.field_8930, 3, -2.4f, "minecraft:diamond"),
    SWORD_THE_STARLESS_NIGHT(true, (class_1832)class_1834.field_22033, 6, -3.3f, "minecraft:netherite_scrap");

    private final boolean isEnabled;
    private final class_1832 material;
    private final int damage;
    private final float attackSpeed;
    private final String[] repairIngredient;

    private SwordsID(boolean isEnabled, class_1832 material, int damage, float attackSpeed, String ... repairIngredient) {
        this.isEnabled = isEnabled;
        this.material = material;
        this.damage = damage;
        this.attackSpeed = attackSpeed;
        this.repairIngredient = repairIngredient;
    }

    public static EnumMap<SwordsID, McdwSword> getItemsEnum() {
        return ItemsRegistry.SWORD_ITEMS;
    }

    public static HashMap<SwordsID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.SWORD_SPAWN_RATES;
    }

    public static HashMap<SwordsID, IMeleeWeaponID.MeleeStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.swordStats;
    }

    @Override
    public boolean getIsEnabled() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.swordStats.get((Object)this).isEnabled;
    }

    public McdwSword getItem() {
        return SwordsID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return SwordsID.getSpawnRates().get(this);
    }

    public HashMap<SwordsID, IMeleeWeaponID.MeleeStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.swordStats;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats() {
        return SwordsID.getWeaponStats().get(this);
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.swordStats.get(this);
    }

    @Override
    public class_1832 getMaterial() {
        return this.material;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getMeleeStats() {
        return new IMeleeWeaponID.MeleeStats().meleeStats(this.isEnabled, CleanlinessHelper.materialToString(this.material), this.damage, this.attackSpeed, this.repairIngredient);
    }

    @Override
    public Map<class_1887, Integer> getInnateEnchantments() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case SWORD_BEESTINGER -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.BUSY_BEE});
            case SWORD_BROKEN_SAWBLADE, SWORD_CORAL_BLADE, SWORD_CUTLASS, SWORD_DIAMOND_SWORD_VAR, SWORD_IRON_SWORD_VAR, SWORD_KATANA, SWORD_OBSIDIAN_CLAYMORE, SWORD_RAPIER -> Map.of();
            case SWORD_CLAYMORE -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, class_1893.field_9121);
            case SWORD_BROADSWORD -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{class_1893.field_9121, EnchantmentsID.SWIRLING});
            case SWORD_DANCERS_SWORD -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.RAMPAGING});
            case SWORD_DARK_KATANA -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.SMITING});
            case SWORD_FREEZING_FOIL -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.FREEZING});
            case SWORD_FROST_SLAYER -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{class_1893.field_9121, EnchantmentsID.FREEZING});
            case SWORD_GREAT_AXEBLADE -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{class_1893.field_9121, EnchantmentsID.DYNAMO});
            case SWORD_HAWKBRAND, SWORD_MASTERS_KATANA, SWORD_SINISTER -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.CRITICAL_HIT});
            case SWORD_HEARTSTEALER -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{class_1893.field_9121, EnchantmentsID.LEECHING});
            case SWORD_MECHANIZED_SAWBLADE -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, class_1893.field_9124);
            case SWORD_NAMELESS_BLADE -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.WEAKENING});
            case SWORD_SPONGE_STRIKER -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.ENIGMA_RESONATOR});
            case SWORD_THE_STARLESS_NIGHT -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.SHARED_PAIN});
        };
    }

    @Override
    @NotNull
    public class_1799 getInnateEnchantedStack(class_1792 item) {
        return item.method_7854();
    }

    public McdwSword makeWeapon() {
        McdwSword mcdwSword = new McdwSword(this, CleanlinessHelper.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().damage, this.getWeaponItemStats().attackSpeed, this.getWeaponItemStats().repairIngredient);
        SwordsID.getItemsEnum().put(this, mcdwSword);
        return mcdwSword;
    }
}

