/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.bases.McdwStaff;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.EnchantmentsID;
import chronosacaria.mcdw.enums.IMeleeWeaponID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1887;
import org.jetbrains.annotations.NotNull;

public enum StavesID implements IMeleeWeaponID,
IInnateEnchantment
{
    STAFF_BATTLESTAFF(true, (class_1832)class_1834.field_8922, 2, -2.6f, "minecraft:planks"),
    STAFF_BATTLESTAFF_OF_TERROR(true, (class_1832)class_1834.field_8923, 5, -2.6f, "minecraft:iron_ingot"),
    STAFF_GROWING_STAFF(true, (class_1832)class_1834.field_8923, 5, -2.6f, "minecraft:iron_ingot");

    private final boolean isEnabled;
    private final class_1832 material;
    private final int damage;
    private final float attackSpeed;
    private final String[] repairIngredient;

    private StavesID(boolean isEnabled, class_1832 material, int damage, float attackSpeed, String ... repairIngredient) {
        this.isEnabled = isEnabled;
        this.material = material;
        this.damage = damage;
        this.attackSpeed = attackSpeed;
        this.repairIngredient = repairIngredient;
    }

    public static EnumMap<StavesID, McdwStaff> getItemsEnum() {
        return ItemsRegistry.STAFF_ITEMS;
    }

    public static HashMap<StavesID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.STAFF_SPAWN_RATES;
    }

    public static HashMap<StavesID, IMeleeWeaponID.MeleeStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.staffStats;
    }

    @Override
    public boolean getIsEnabled() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.staffStats.get((Object)this).isEnabled;
    }

    public McdwStaff getItem() {
        return StavesID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return StavesID.getSpawnRates().get(this);
    }

    public HashMap<StavesID, IMeleeWeaponID.MeleeStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.staffStats;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats() {
        return StavesID.getWeaponStats().get(this);
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.staffStats.get(this);
    }

    @Override
    public class_1832 getMaterial() {
        return this.material;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getMeleeStats() {
        return new IMeleeWeaponID.MeleeStats().meleeStats(this.isEnabled, CleanlinessHelper.materialToString(this.material), this.damage, this.attackSpeed, this.repairIngredient);
    }

    @Override
    public Map<class_1887, Integer> getInnateEnchantments() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case STAFF_BATTLESTAFF -> Map.of();
            case STAFF_BATTLESTAFF_OF_TERROR -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.EXPLODING});
            case STAFF_GROWING_STAFF -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.COMMITTED});
        };
    }

    @Override
    @NotNull
    public class_1799 getInnateEnchantedStack(class_1792 item) {
        return item.method_7854();
    }

    public McdwStaff makeWeapon() {
        McdwStaff mcdwStaff = new McdwStaff(this, CleanlinessHelper.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().damage, this.getWeaponItemStats().attackSpeed, this.getWeaponItemStats().repairIngredient);
        StavesID.getItemsEnum().put(this, mcdwStaff);
        return mcdwStaff;
    }
}

