/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.bases.McdwHammer;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.EnchantmentsID;
import chronosacaria.mcdw.enums.IMeleeWeaponID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import org.jetbrains.annotations.NotNull;

public enum HammersID implements IMeleeWeaponID,
IInnateEnchantment
{
    HAMMER_BONECLUB(true, (class_1832)class_1834.field_8923, 7, -3.2f, "minecraft:bone_block"),
    HAMMER_BONE_CUDGEL(true, (class_1832)class_1834.field_22033, 7, -3.2f, "minecraft:netherite_scrap"),
    HAMMER_FLAIL(true, (class_1832)class_1834.field_8923, 5, -2.8f, "minecraft:iron_ingot"),
    HAMMER_GRAVITY(true, (class_1832)class_1834.field_8930, 6, -3.2f, "minecraft:diamond"),
    HAMMER_GREAT_HAMMER(true, (class_1832)class_1834.field_8923, 6, -3.2f, "minecraft:iron_ingot"),
    HAMMER_MACE(true, (class_1832)class_1834.field_8923, 5, -2.8f, "minecraft:iron_ingot"),
    HAMMER_STORMLANDER(true, (class_1832)class_1834.field_8930, 7, -3.2f, "minecraft:diamond"),
    HAMMER_SUNS_GRACE(true, (class_1832)class_1834.field_8930, 4, -2.8f, "minecraft:diamond");

    private final boolean isEnabled;
    private final class_1832 material;
    private final int damage;
    private final float attackSpeed;
    private final String[] repairIngredient;

    private HammersID(boolean isEnabled, class_1832 material, int damage, float attackSpeed, String ... repairIngredient) {
        this.isEnabled = isEnabled;
        this.material = material;
        this.damage = damage;
        this.attackSpeed = attackSpeed;
        this.repairIngredient = repairIngredient;
    }

    public static EnumMap<HammersID, McdwHammer> getItemsEnum() {
        return ItemsRegistry.HAMMER_ITEMS;
    }

    public static HashMap<HammersID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.HAMMER_SPAWN_RATES;
    }

    public static HashMap<HammersID, IMeleeWeaponID.MeleeStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.hammerStats;
    }

    @Override
    public boolean getIsEnabled() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.hammerStats.get((Object)this).isEnabled;
    }

    public McdwHammer getItem() {
        return HammersID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return HammersID.getSpawnRates().get(this);
    }

    public HashMap<HammersID, IMeleeWeaponID.MeleeStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.hammerStats;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats() {
        return HammersID.getWeaponStats().get(this);
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.hammerStats.get(this);
    }

    @Override
    public class_1832 getMaterial() {
        return this.material;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getMeleeStats() {
        return new IMeleeWeaponID.MeleeStats().meleeStats(this.isEnabled, CleanlinessHelper.materialToString(this.material), this.damage, this.attackSpeed, this.repairIngredient);
    }

    @Override
    public Map<class_1887, Integer> getInnateEnchantments() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case HAMMER_BONECLUB -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, class_1893.field_9121);
            case HAMMER_GREAT_HAMMER, HAMMER_MACE -> Map.of();
            case HAMMER_FLAIL -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.CHAINS});
            case HAMMER_BONE_CUDGEL -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{class_1893.field_9121, EnchantmentsID.ILLAGERS_BANE});
            case HAMMER_GRAVITY -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.GRAVITY});
            case HAMMER_STORMLANDER -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.THUNDERING});
            case HAMMER_SUNS_GRACE -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.RADIANCE});
        };
    }

    @Override
    @NotNull
    public class_1799 getInnateEnchantedStack(class_1792 item) {
        return item.method_7854();
    }

    public McdwHammer makeWeapon() {
        McdwHammer mcdwHammer = new McdwHammer(this, CleanlinessHelper.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().damage, this.getWeaponItemStats().attackSpeed, this.getWeaponItemStats().repairIngredient);
        HammersID.getItemsEnum().put(this, mcdwHammer);
        return mcdwHammer;
    }
}

