/*
 * Decompiled with CFR 0.152.
 */
package chronosacaria.mcdw.enums;

import chronosacaria.mcdw.Mcdw;
import chronosacaria.mcdw.api.interfaces.IInnateEnchantment;
import chronosacaria.mcdw.api.util.CleanlinessHelper;
import chronosacaria.mcdw.bases.McdwGlaive;
import chronosacaria.mcdw.configs.McdwNewStatsConfig;
import chronosacaria.mcdw.enums.EnchantmentsID;
import chronosacaria.mcdw.enums.IMeleeWeaponID;
import chronosacaria.mcdw.registries.ItemsRegistry;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1887;
import org.jetbrains.annotations.NotNull;

public enum GlaivesID implements IMeleeWeaponID,
IInnateEnchantment
{
    GLAIVE_CACKLING_BROOM(true, (class_1832)class_1834.field_8923, 5, -3.0f, "minecraft:iron_ingot"),
    GLAIVE_GLAIVE(true, (class_1832)class_1834.field_8923, 5, -3.0f, "minecraft:iron_ingot"),
    GLAIVE_GRAVE_BANE(true, (class_1832)class_1834.field_8923, 6, -3.0f, "minecraft:iron_ingot"),
    GLAIVE_VENOM_GLAIVE(true, (class_1832)class_1834.field_8923, 6, -3.0f, "minecraft:iron_ingot");

    private final boolean isEnabled;
    private final class_1832 material;
    private final int damage;
    private final float attackSpeed;
    private final String[] repairIngredient;

    private GlaivesID(boolean isEnabled, class_1832 material, int damage, float attackSpeed, String ... repairIngredient) {
        this.isEnabled = isEnabled;
        this.material = material;
        this.damage = damage;
        this.attackSpeed = attackSpeed;
        this.repairIngredient = repairIngredient;
    }

    public static EnumMap<GlaivesID, McdwGlaive> getItemsEnum() {
        return ItemsRegistry.GLAIVE_ITEMS;
    }

    public static HashMap<GlaivesID, Integer> getSpawnRates() {
        return Mcdw.CONFIG.mcdwNewlootConfig.GLAIVE_SPAWN_RATES;
    }

    public static HashMap<GlaivesID, IMeleeWeaponID.MeleeStats> getWeaponStats() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.glaiveStats;
    }

    @Override
    public boolean getIsEnabled() {
        return Mcdw.CONFIG.mcdwNewStatsConfig.glaiveStats.get((Object)this).isEnabled;
    }

    public McdwGlaive getItem() {
        return GlaivesID.getItemsEnum().get(this);
    }

    @Override
    public Integer getItemSpawnRate() {
        return GlaivesID.getSpawnRates().get(this);
    }

    public HashMap<GlaivesID, IMeleeWeaponID.MeleeStats> getWeaponStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.glaiveStats;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats() {
        return GlaivesID.getWeaponStats().get(this);
    }

    @Override
    public IMeleeWeaponID.MeleeStats getWeaponItemStats(McdwNewStatsConfig mcdwNewStatsConfig) {
        return mcdwNewStatsConfig.glaiveStats.get(this);
    }

    @Override
    public class_1832 getMaterial() {
        return this.material;
    }

    @Override
    public int getDamage() {
        return this.damage;
    }

    @Override
    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    @Override
    public String[] getRepairIngredient() {
        return this.repairIngredient;
    }

    @Override
    public IMeleeWeaponID.MeleeStats getMeleeStats() {
        return new IMeleeWeaponID.MeleeStats().meleeStats(this.isEnabled, CleanlinessHelper.materialToString(this.material), this.damage, this.attackSpeed, this.repairIngredient);
    }

    @Override
    public Map<class_1887, Integer> getInnateEnchantments() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case GLAIVE_CACKLING_BROOM, GLAIVE_GRAVE_BANE -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.SMITING});
            case GLAIVE_GLAIVE -> Map.of();
            case GLAIVE_VENOM_GLAIVE -> CleanlinessHelper.mcdw$checkInnateEnchantmentEnabled(1, new Object[]{EnchantmentsID.POISON_CLOUD});
        };
    }

    @Override
    @NotNull
    public class_1799 getInnateEnchantedStack(class_1792 item) {
        return item.method_7854();
    }

    public McdwGlaive makeWeapon() {
        McdwGlaive mcdwGlaive = new McdwGlaive(this, CleanlinessHelper.stringToMaterial(this.getWeaponItemStats().material), this.getWeaponItemStats().damage, this.getWeaponItemStats().attackSpeed, this.getWeaponItemStats().repairIngredient);
        GlaivesID.getItemsEnum().put(this, mcdwGlaive);
        return mcdwGlaive;
    }
}

