/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.common.ai.tasks;

import com.obscuria.obscureapi.common.ai.tasks.AICondition;

public abstract class AITask {
    private AICondition condition = () -> true;
    private int cooldown = 0;
    private int tick = 0;
    private boolean fixed = false;
    private boolean completed = false;
    private int flow = 0;

    public final AITask setCooldown(int cooldown) {
        this.cooldown = cooldown;
        return this;
    }

    public final AITask setFlow(int flow) {
        this.flow = flow;
        return this;
    }

    public final AITask setFixed(boolean flag) {
        this.fixed = flag;
        return this;
    }

    public final AITask setCondition(AICondition condition) {
        this.condition = condition;
        return this;
    }

    public final void setCompleted(boolean flag) {
        this.completed = flag;
    }

    public final int getFlow() {
        return this.flow;
    }

    public final boolean test() {
        return this.condition.test();
    }

    public final boolean isCompleted() {
        return this.completed;
    }

    public final boolean isFixed() {
        return this.fixed;
    }

    public final boolean baseCanUse() {
        return this.tick <= 0 && this.condition.test();
    }

    public final void baseStop() {
        this.completed = false;
        this.tick = this.cooldown;
    }

    public final void tickCooldown() {
        if (this.tick > 0) {
            --this.tick;
        }
    }

    public boolean canUse() {
        return true;
    }

    public void start() {
    }

    public void tick() {
    }

    public void stop() {
    }
}

