/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.client;

import com.obscuria.obscureapi.api.tools.ExceptionFilter;
import com.obscuria.obscureapi.client.ExternalData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_1084;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ExternalTexture
implements ExternalData<class_2960> {
    public static final class_2960 BLANK = new class_2960("obscure_api", "textures/blank_external_texture.png");
    private final String LINK;
    private final class_2960 OFFLINE;
    private final class_2960 ONLINE;
    private final String NAME;
    private final boolean AUTO_UPLOAD;
    private final Consumer<ExternalTexture> CALLBACK;
    private boolean uploaded = false;
    @Nullable
    private CompletableFuture<?> future = null;

    private ExternalTexture(class_2960 location, String name, class_2960 offline, String link, boolean autoUpload, Consumer<ExternalTexture> callback) {
        this.OFFLINE = offline;
        this.ONLINE = new class_2960(location.method_12836(), location.method_12832() + "/" + name);
        this.NAME = name;
        this.AUTO_UPLOAD = autoUpload;
        this.CALLBACK = callback;
        this.LINK = link;
        if (this.AUTO_UPLOAD) {
            this.upload();
        }
    }

    public static ExternalTexture create(class_2960 location, String name, String link) {
        return ExternalTexture.create(location, name, BLANK, link, false);
    }

    public static ExternalTexture create(class_2960 location, String name, class_2960 offline, String link) {
        return ExternalTexture.create(location, name, offline, link, false);
    }

    public static ExternalTexture create(class_2960 location, String name, class_2960 offline, String link, boolean autoUpload) {
        return ExternalTexture.create(location, name, offline, link, autoUpload, externalTexture -> {});
    }

    public static ExternalTexture create(class_2960 location, String name, class_2960 offline, String link, boolean autoUpload, Consumer<ExternalTexture> callback) {
        return new ExternalTexture(location, name, offline, link, autoUpload, callback);
    }

    @Override
    public boolean isInProgress() {
        return this.future != null;
    }

    @Override
    public boolean isUploaded() {
        return this.uploaded;
    }

    @Override
    public class_2960 get() {
        if (this.uploaded) {
            return this.ONLINE;
        }
        if (this.AUTO_UPLOAD) {
            this.upload();
        }
        return this.OFFLINE;
    }

    public ExternalTexture upload() {
        if (this.isInProgress()) {
            return this;
        }
        try {
            this.future = CompletableFuture.runAsync(() -> {
                ExceptionFilter.of(() -> {
                    HttpURLConnection httpurlconnection = (HttpURLConnection)new URL(this.LINK).openConnection(class_310.method_1551().method_1487());
                    httpurlconnection.setDoInput(true);
                    httpurlconnection.setDoOutput(false);
                    httpurlconnection.connect();
                    class_1011 nativeImage = class_1011.method_4309((InputStream)httpurlconnection.getInputStream());
                    httpurlconnection.disconnect();
                    Path path = Paths.get(FabricLoader.getInstance().getConfigDir().toAbsolutePath().toString(), "Obscuria", "Data");
                    ExceptionFilter.of(() -> Files.createDirectory(path, new FileAttribute[0]));
                    File file = new File(path + "/" + this.NAME);
                    nativeImage.method_4325(file);
                    class_310.method_1551().method_1531().method_4616(this.ONLINE, (class_1044)new Texture(this.ONLINE, path + "/" + this.NAME));
                    this.uploaded = true;
                    this.future = null;
                }, e -> {
                    this.future = null;
                });
                if (this.uploaded) {
                    this.CALLBACK.accept(this);
                }
            }, class_156.method_18349());
            return this;
        }
        catch (Exception exception) {
            return this;
        }
    }

    @Environment(value=EnvType.CLIENT)
    static class Texture
    extends class_1049 {
        final String PATH;

        public Texture(class_2960 location, String path) {
            super(location);
            this.PATH = path;
        }

        protected class_1049.class_4006 method_18153(class_3300 manager) {
            try {
                return new class_1049.class_4006(new class_1084(true, true), class_1011.method_4309((InputStream)new FileInputStream(this.PATH)));
            }
            catch (IOException e) {
                return new class_1049.class_4006(e);
            }
        }
    }
}

