/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.api.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5702;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public final class EntityUtils {
    public static List<class_1309> getRelativeEntities(class_1309 entity, Class<? extends class_1309> targets, float forward, float left, float up, float area) {
        return EntityUtils.getRelativeEntities(entity, targets, forward, left, up, area, false, false);
    }

    public static List<class_1309> getRelativeEntities(class_1309 entity, Class<? extends class_1309> targets, class_243 pos, float area) {
        return EntityUtils.getRelativeEntities(entity, targets, pos, area, false, false);
    }

    public static List<class_1309> getRelativeEntities(class_1309 entity, Class<? extends class_1309> targets, float forward, float left, float up, float area, boolean visibleOnly) {
        return EntityUtils.getRelativeEntities(entity, targets, forward, left, up, area, visibleOnly, false);
    }

    public static List<class_1309> getRelativeEntities(class_1309 entity, Class<? extends class_1309> targets, class_243 pos, float area, boolean visibleOnly) {
        return EntityUtils.getRelativeEntities(entity, targets, pos, area, visibleOnly, false);
    }

    public static List<class_1309> getRelativeEntities(class_1309 entity, Class<? extends class_1309> targets, float forward, float left, float up, float area, boolean visibleOnly, boolean circle) {
        return EntityUtils.getRelativeEntities(entity, targets, EntityUtils.getRelativePos((class_1297)entity, forward, left, up), area, visibleOnly, circle);
    }

    public static List<class_1309> getRelativeEntities(class_1309 entity, Class<? extends class_1309> targets, class_243 pos, float area, boolean visibleOnly, boolean circle) {
        List list = entity.method_37908().method_8390(targets, new class_238(pos, pos).method_1014((double)area), e -> true);
        ArrayList<class_1309> entities = new ArrayList<class_1309>();
        list.forEach(entry -> {
            if (!(visibleOnly && !entity.method_6057((class_1297)entry) || circle && !(pos.method_1022(entry.method_19538()) <= (double)area))) {
                entities.add((class_1309)entry);
            }
        });
        return entities;
    }

    public static class_243 getRelativePos(class_1297 entity, float forward, float left, float up) {
        class_241 vec2 = new class_241(entity.method_5695(1.0f), entity.method_5705(1.0f));
        class_243 vec3 = entity.method_33571();
        float f = class_3532.method_15362((float)((vec2.field_1342 + 90.0f) * ((float)Math.PI / 180)));
        float f1 = class_3532.method_15374((float)((vec2.field_1342 + 90.0f) * ((float)Math.PI / 180)));
        float f2 = class_3532.method_15362((float)(-vec2.field_1343 * ((float)Math.PI / 180)));
        float f3 = class_3532.method_15374((float)(-vec2.field_1343 * ((float)Math.PI / 180)));
        float f4 = class_3532.method_15362((float)((-vec2.field_1343 + 90.0f) * ((float)Math.PI / 180)));
        float f5 = class_3532.method_15374((float)((-vec2.field_1343 + 90.0f) * ((float)Math.PI / 180)));
        class_243 vec31 = new class_243((double)(f * f2), (double)f3, (double)(f1 * f2));
        class_243 vec32 = new class_243((double)(f * f4), (double)f5, (double)(f1 * f4));
        class_243 vec33 = vec31.method_1036(vec32).method_1021(-1.0);
        double d0 = vec31.field_1352 * (double)forward + vec32.field_1352 * (double)up + vec33.field_1352 * (double)left;
        double d1 = vec31.field_1351 * (double)forward + vec32.field_1351 * (double)up + vec33.field_1351 * (double)left;
        double d2 = vec31.field_1350 * (double)forward + vec32.field_1350 * (double)up + vec33.field_1350 * (double)left;
        return new class_243(vec3.field_1352 + d0, vec3.field_1351 + d1, vec3.field_1350 + d2);
    }

    public static float getYAngleBetween(class_1297 first, class_1297 second) {
        return EntityUtils.getYAngleBetween(first.method_23317(), first.method_23321(), second.method_23317(), second.method_23321());
    }

    public static float getYAngleBetween(double x1, double z1, double x2, double z2) {
        double result = x2 > x1 ? Math.atan2(x2 - x1, z1 - z2) * 180.0 / Math.PI : (x2 < x1 ? 360.0 - Math.atan2(x1 - x2, z1 - z2) * 180.0 / Math.PI : Math.atan2(0.0, 0.0));
        return (float)(result + 180.0 > 360.0 ? result - 180.0 : result + 180.0);
    }

    public static void setMotion(class_1297 entity, class_243 velocity) {
        entity.method_18799(velocity);
        entity.field_6037 = true;
    }

    public static void addMotion(class_1297 entity, class_243 velocity) {
        EntityUtils.setMotion(entity, entity.method_18798().method_1019(velocity));
    }

    public static void setMotion(class_1297 entity, float x, float y, float z) {
        EntityUtils.setMotion(entity, new class_243((double)x, (double)y, (double)z));
    }

    public static void setMotionX(class_1297 entity, float x) {
        entity.method_18800((double)x, entity.method_18798().field_1351, entity.method_18798().field_1350);
    }

    public static void setMotionY(class_1297 entity, float y) {
        entity.method_18800(entity.method_18798().field_1352, (double)y, entity.method_18798().field_1350);
    }

    public static void setMotionZ(class_1297 entity, float z) {
        entity.method_18800(entity.method_18798().field_1352, entity.method_18798().field_1351, (double)z);
    }

    public static void addMotion(class_1297 entity, float x, float y, float z) {
        EntityUtils.addMotion(entity, new class_243((double)x, (double)y, (double)z));
    }

    public static class_1676 shootProjectile(class_1676 projectile, class_1297 entity, float pitch, float yaw, float newPitch, float speed, float spread) {
        class_1676 projectileEntity = EntityUtils.shootProjectileIgnoreMotion(projectile, entity, pitch, yaw, newPitch, speed, spread);
        class_243 vec = entity.method_18798();
        projectileEntity.method_18799(projectileEntity.method_18798().method_1031(vec.field_1352, entity.method_24828() ? 0.0 : vec.field_1351, vec.field_1350));
        return projectileEntity;
    }

    @Contract(value="_, _, _, _, _, _, _ -> param1")
    public static class_1676 shootProjectileIgnoreMotion(class_1676 projectile, class_1297 entity, float pitch, float yaw, float newPitch, float speed, float spread) {
        float f = (float)(-Math.sin((double)yaw * (Math.PI / 180)) * Math.cos((double)pitch * (Math.PI / 180)));
        float f1 = (float)(-Math.sin((double)(pitch + newPitch) * (Math.PI / 180)));
        float f2 = (float)(Math.cos((double)yaw * (Math.PI / 180)) * Math.cos((double)pitch * (Math.PI / 180)));
        projectile.method_7485((double)f, (double)f1, (double)f2, speed, spread);
        projectile.method_7432(entity);
        return projectile;
    }

    public static class_3965 rayTrace(class_1937 level, class_1297 entity, Predicate<class_2680> predicate, double maxDist) {
        class_243 eye = entity.method_5836(1.0f);
        float f2 = (float)Math.cos((double)(-entity.method_5791()) * (Math.PI / 180) - Math.PI);
        float f3 = (float)Math.sin((double)(-entity.method_5791()) * (Math.PI / 180) - Math.PI);
        float f4 = (float)(-Math.cos((double)(-entity.method_36455()) * (Math.PI / 180)));
        float f5 = (float)Math.sin((double)(-entity.method_36455()) * (Math.PI / 180));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        class_243 vector = eye.method_1031((double)f6 * maxDist, (double)f5 * maxDist, (double)f7 * maxDist);
        return level.method_32880(new class_5702(eye, vector, predicate));
    }

    public static class_3965 rayTrace(class_1937 level, class_1309 entity, Predicate<class_2680> predicate) {
        double maxDist = 4.0;
        return EntityUtils.rayTrace(level, (class_1297)entity, predicate, 4.0);
    }

    public static class_3965 rayTrace(class_1937 level, class_1297 entity, double maxDist) {
        return EntityUtils.rayTrace(level, entity, class_4970.class_4971::method_51367, maxDist);
    }

    public static class_3965 rayTrace(class_1937 level, class_1309 entity) {
        double maxDist = 4.0;
        return EntityUtils.rayTrace(level, (class_1297)entity, maxDist);
    }

    public static class_3965 rayTraceFluid(class_1937 level, class_1297 entity, double maxDist) {
        return EntityUtils.rayTrace(level, entity, class_4970.class_4971::method_51176, maxDist);
    }

    public static class_3965 rayTraceFluid(class_1937 level, class_1309 entity) {
        double maxDist = 4.0;
        return EntityUtils.rayTrace(level, (class_1297)entity, maxDist);
    }

    @Nullable
    public static class_1297 rayTraceEntity(class_1657 entity, Class<? extends class_1297> target, int distance, Predicate<class_1297> predicate) {
        class_243 direction = EntityUtils.direction((class_1297)entity);
        for (double i = 0.0; i < (double)distance + 0.375; i += 0.5) {
            class_243 pos = new class_243(entity.method_23317() + direction.field_1352 * i, entity.method_23320() - 0.2 + direction.field_1351 * i, entity.method_23321() + direction.field_1350 * i);
            if (entity.method_37908().method_8320(new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350)).method_51367()) break;
            for (class_1297 targetEntity : entity.method_37908().method_8390(target, new class_238(pos.field_1352 - 0.1, pos.field_1351 - 0.1, pos.field_1350 - 0.1, pos.field_1352 + 0.1, pos.field_1351 + 0.1, pos.field_1350 + 0.1), e -> e.method_5628() != entity.method_5628())) {
                if (!predicate.test(targetEntity)) continue;
                return targetEntity;
            }
        }
        return null;
    }

    public static class_243 direction(class_1297 entity) {
        float rotationYaw = entity.method_5791();
        float rotationPitch = entity.method_36455();
        float x = (float)(-Math.sin(Math.toRadians(rotationYaw)) * Math.cos(Math.toRadians(rotationPitch)));
        float y = (float)(-Math.sin(Math.toRadians(rotationPitch)));
        float z = (float)(Math.cos(Math.toRadians(rotationYaw)) * Math.cos(Math.toRadians(rotationPitch)));
        return new class_243((double)x, (double)y, (double)z);
    }

    public static class_1799 helmet(class_1309 entity) {
        return entity.method_6118(class_1304.field_6169);
    }

    public static class_1799 chestplate(class_1309 entity) {
        return entity.method_6118(class_1304.field_6174);
    }

    public static class_1799 leggings(class_1309 entity) {
        return entity.method_6118(class_1304.field_6172);
    }

    public static class_1799 boots(class_1309 entity) {
        return entity.method_6118(class_1304.field_6166);
    }

    public static class_1799 mainHand(class_1309 entity) {
        return entity.method_6118(class_1304.field_6173);
    }

    public static class_1799 offhand(class_1309 entity) {
        return entity.method_6118(class_1304.field_6171);
    }

    public static boolean canSpawnAtPosition(class_4538 level, class_2338 spawnPos, class_1299<?> type) {
        class_238 size = new class_238(spawnPos).method_1009((double)type.method_17685(), (double)type.method_17686(), (double)type.method_17685());
        return class_2338.method_29715((class_238)size).noneMatch(pos -> level.method_8320(pos).method_51367() || level.method_8316(pos).method_15767(class_3486.field_15518));
    }
}

