/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.waveycapes.renderlayers;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tr7zw.waveycapes.CapeRenderInfo;
import dev.tr7zw.waveycapes.CapeRenderer;
import dev.tr7zw.waveycapes.NMSUtil;
import dev.tr7zw.waveycapes.VanillaCapeRenderer;
import dev.tr7zw.waveycapes.WaveyCapesBase;
import dev.tr7zw.waveycapes.support.ModSupport;
import dev.tr7zw.waveycapes.support.SupportManager;
import dev.tr7zw.waveycapes.util.NMSHelper;
import dev.tr7zw.waveycapes.versionless.CapeHolder;
import dev.tr7zw.waveycapes.versionless.CapeMovement;
import dev.tr7zw.waveycapes.versionless.CapeStyle;
import dev.tr7zw.waveycapes.versionless.ModBase;
import dev.tr7zw.waveycapes.versionless.WindMode;
import dev.tr7zw.waveycapes.versionless.sim.BasicSimulation;
import dev.tr7zw.waveycapes.versionless.util.Vector3;
import dev.tr7zw.waveycapes.versionless.util.Vector4;
import net.minecraft.class_1664;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class CustomCapeRenderLayer
extends class_3887<class_742, class_591<class_742>> {
    private static final int PART_COUNT = 16;
    private class_630[] customCape = NMSUtil.buildCape(64, 64, x -> 0, y -> y);
    private static VanillaCapeRenderer vanillaCape = new VanillaCapeRenderer();

    public CustomCapeRenderLayer(class_3883<class_742, class_591<class_742>> renderLayerParent) {
        super(renderLayerParent);
    }

    public void render(class_4587 poseStack, class_4597 multiBufferSource, int i, class_742 abstractClientPlayer, float f, float g, float delta, float j, float k, float l) {
        CapeRenderInfo capeRenderInfo = new CapeRenderInfo(abstractClientPlayer);
        if (capeRenderInfo.isPlayerInvisible()) {
            return;
        }
        CapeRenderer renderer = this.getCapeRenderer(capeRenderInfo, multiBufferSource);
        if (renderer == null) {
            return;
        }
        if (capeRenderInfo.hasElytraEquipped()) {
            return;
        }
        if (!abstractClientPlayer.method_7348(class_1664.field_7559)) {
            return;
        }
        CapeHolder holder = capeRenderInfo.getCapeHolder();
        holder.updateSimulation(16);
        poseStack.method_22903();
        ((class_591)this.method_17165()).field_3391.method_22703(poseStack);
        if (capeRenderInfo.hasChestplateEquipped()) {
            poseStack.method_46416(0.0f, -0.053125f, 0.06875f);
        }
        if (ModBase.config.capeStyle == CapeStyle.SMOOTH && renderer.vanillaUvValues()) {
            this.renderSmoothCape(poseStack, multiBufferSource, renderer, capeRenderInfo, delta, i);
        } else {
            class_630[] parts = this.customCape;
            for (int part = 0; part < 16; ++part) {
                class_630 model = parts[part];
                this.modifyPoseStack(poseStack, capeRenderInfo, delta, part);
                renderer.render(capeRenderInfo, part, model, poseStack, multiBufferSource, i, class_4608.field_21444);
                poseStack.method_22909();
            }
        }
        poseStack.method_22909();
    }

    private void renderSmoothCape(class_4587 poseStack, class_4597 multiBufferSource, CapeRenderer capeRenderer, CapeRenderInfo capeRenderInfo, float delta, int light) {
        class_4588 bufferBuilder = capeRenderer.getVertexConsumer(multiBufferSource, capeRenderInfo);
        if (bufferBuilder == null) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Matrix4f oldPositionMatrix = null;
        for (int part = 0; part < 16; ++part) {
            this.modifyPoseStack(poseStack, capeRenderInfo, delta, part);
            if (oldPositionMatrix == null) {
                oldPositionMatrix = poseStack.method_23760().method_23761();
            }
            float capeWidth = 0.625f;
            float capeHeight = 1.0f;
            float capeDepth = 0.0625f;
            if (part == 0) {
                CustomCapeRenderLayer.addTopVertex(bufferBuilder, poseStack.method_23760().method_23761(), oldPositionMatrix, capeWidth / 2.0f, 0.0f, 0.0f, -capeWidth / 2.0f, 0.0f, -capeDepth, light);
            }
            if (part == 15) {
                CustomCapeRenderLayer.addBottomVertex(bufferBuilder, poseStack.method_23760().method_23761(), poseStack.method_23760().method_23761(), capeWidth / 2.0f, (float)(part + 1) * (capeHeight / 16.0f), 0.0f, -capeWidth / 2.0f, (float)(part + 1) * (capeHeight / 16.0f), -capeDepth, light);
            }
            CustomCapeRenderLayer.addLeftVertex(bufferBuilder, poseStack.method_23760().method_23761(), oldPositionMatrix, -capeWidth / 2.0f, (float)(part + 1) * (capeHeight / 16.0f), 0.0f, -capeWidth / 2.0f, (float)part * (capeHeight / 16.0f), -capeDepth, part, light);
            CustomCapeRenderLayer.addRightVertex(bufferBuilder, poseStack.method_23760().method_23761(), oldPositionMatrix, capeWidth / 2.0f, (float)(part + 1) * (capeHeight / 16.0f), 0.0f, capeWidth / 2.0f, (float)part * (capeHeight / 16.0f), -capeDepth, part, light);
            CustomCapeRenderLayer.addBackVertex(bufferBuilder, poseStack.method_23760().method_23761(), oldPositionMatrix, capeWidth / 2.0f, (float)(part + 1) * (capeHeight / 16.0f), -capeDepth, -capeWidth / 2.0f, (float)part * (capeHeight / 16.0f), -capeDepth, part, light);
            CustomCapeRenderLayer.addFrontVertex(bufferBuilder, oldPositionMatrix, poseStack.method_23760().method_23761(), capeWidth / 2.0f, (float)(part + 1) * (capeHeight / 16.0f), 0.0f, -capeWidth / 2.0f, (float)part * (capeHeight / 16.0f), 0.0f, part, light);
            oldPositionMatrix = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            poseStack.method_22909();
        }
    }

    private void modifyPoseStack(class_4587 poseStack, CapeRenderInfo capeRenderInfo, float h, int part) {
        if (WaveyCapesBase.config.capeMovement != CapeMovement.VANILLA) {
            this.modifyPoseStackSimulation(poseStack, capeRenderInfo, h, part);
            return;
        }
        this.modifyPoseStackVanilla(poseStack, capeRenderInfo.getPlayer(), h, part);
    }

    private void modifyPoseStackSimulation(class_4587 poseStack, CapeRenderInfo capeRenderInfo, float delta, int part) {
        BasicSimulation simulation = capeRenderInfo.getCapeHolder().getSimulation();
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.0, 0.125);
        float x = simulation.getPoints().get(part).getLerpX(delta) - simulation.getPoints().get(0).getLerpX(delta);
        if (x > 0.0f) {
            x = 0.0f;
        }
        float y = simulation.getPoints().get(0).getLerpY(delta) - (float)part - simulation.getPoints().get(part).getLerpY(delta);
        float z = simulation.getPoints().get(0).getLerpZ(delta) - simulation.getPoints().get(part).getLerpZ(delta);
        float sidewaysRotationOffset = 0.0f;
        float partRotation = this.getRotation(delta, part, simulation);
        float height = 0.0f;
        float naturalWindSwing = this.getNatrualWindSwing(part, capeRenderInfo.isPlayerUnderwater());
        poseStack.method_22907(NMSHelper.XP.rotationDegrees(6.0f + height + naturalWindSwing));
        poseStack.method_22907(NMSHelper.ZP.rotationDegrees(sidewaysRotationOffset / 2.0f));
        poseStack.method_22907(NMSHelper.YP.rotationDegrees(180.0f - sidewaysRotationOffset / 2.0f));
        poseStack.method_46416(-z / 16.0f, y / 16.0f, x / 16.0f);
        poseStack.method_22904(0.0, 0.03, -0.03);
        poseStack.method_46416(0.0f, (float)part * 1.0f / 16.0f, (float)(part * 0 / 16));
        poseStack.method_22907(NMSHelper.XP.rotationDegrees(-partRotation));
        poseStack.method_46416(0.0f, (float)(-part) * 1.0f / 16.0f, (float)(-part * 0 / 16));
        poseStack.method_22904(0.0, -0.03, 0.03);
    }

    private float getRotation(float delta, int part, BasicSimulation simulation) {
        if (part == 15) {
            return this.getRotation(delta, part - 1, simulation);
        }
        return (float)this.getAngle(simulation.getPoints().get(part).getLerpedPos(delta), simulation.getPoints().get(part + 1).getLerpedPos(delta));
    }

    private double getAngle(Vector3 a, Vector3 b) {
        Vector3 angle = b.subtract(a);
        return Math.toDegrees(Math.atan2(angle.x, angle.y)) + 180.0;
    }

    private void modifyPoseStackVanilla(class_4587 poseStack, class_742 abstractClientPlayer, float h, int part) {
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.0, 0.125);
        double d = class_3532.method_16436((double)h, (double)abstractClientPlayer.field_7524, (double)abstractClientPlayer.field_7500) - class_3532.method_16436((double)h, (double)abstractClientPlayer.field_6014, (double)abstractClientPlayer.method_23317());
        double e = class_3532.method_16436((double)h, (double)abstractClientPlayer.field_7502, (double)abstractClientPlayer.field_7521) - class_3532.method_16436((double)h, (double)abstractClientPlayer.field_6036, (double)abstractClientPlayer.method_23318());
        double m = class_3532.method_16436((double)h, (double)abstractClientPlayer.field_7522, (double)abstractClientPlayer.field_7499) - class_3532.method_16436((double)h, (double)abstractClientPlayer.field_5969, (double)abstractClientPlayer.method_23321());
        float n = abstractClientPlayer.field_6220 + abstractClientPlayer.field_6283 - abstractClientPlayer.field_6220;
        double o = class_3532.method_15374((float)(n * ((float)Math.PI / 180)));
        double p = -class_3532.method_15362((float)(n * ((float)Math.PI / 180)));
        float height = (float)e * 10.0f;
        height = class_3532.method_15363((float)height, (float)-6.0f, (float)32.0f);
        float swing = (float)(d * o + m * p) * CustomCapeRenderLayer.easeOutSine(0.0625f * (float)part) * 100.0f;
        swing = class_3532.method_15363((float)swing, (float)0.0f, (float)(150.0f * CustomCapeRenderLayer.easeOutSine(0.0625f * (float)part)));
        float sidewaysRotationOffset = (float)(d * p - m * o) * 100.0f;
        sidewaysRotationOffset = class_3532.method_15363((float)sidewaysRotationOffset, (float)-20.0f, (float)20.0f);
        float t = class_3532.method_16439((float)h, (float)abstractClientPlayer.field_7505, (float)abstractClientPlayer.field_7483);
        float naturalWindSwing = this.getNatrualWindSwing(part, abstractClientPlayer.method_5869());
        poseStack.method_22907(NMSHelper.XP.rotationDegrees(6.0f + swing / 2.0f + (height += class_3532.method_15374((float)(class_3532.method_16439((float)h, (float)abstractClientPlayer.field_6039, (float)abstractClientPlayer.field_5973) * 6.0f)) * 32.0f * t) + naturalWindSwing));
        poseStack.method_22907(NMSHelper.ZP.rotationDegrees(sidewaysRotationOffset / 2.0f));
        poseStack.method_22907(NMSHelper.YP.rotationDegrees(180.0f - sidewaysRotationOffset / 2.0f));
    }

    private static float easeOutSine(float x) {
        return class_3532.method_15374((float)((float)((double)x * Math.PI / 2.0)));
    }

    private float getNatrualWindSwing(int part, boolean underwater) {
        long highlightedPart = System.currentTimeMillis() / (long)(underwater ? 9 : 3) % 360L;
        float relativePart = (float)(part + 1) / 16.0f;
        if (WaveyCapesBase.config.windMode == WindMode.WAVES) {
            return (float)(Math.sin(Math.toRadians(relativePart * 360.0f - (float)highlightedPart)) * 3.0);
        }
        return 0.0f;
    }

    private static void addBackVertex(class_4588 bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
            Matrix4f k = matrix;
            matrix = oldMatrix;
            oldMatrix = k;
        }
        float minU = 0.015625f;
        float maxU = 0.171875f;
        float minV = 0.03125f;
        float maxV = 0.53125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / 16.0f;
        maxV = minV + vPerPart * (float)(part + 1);
        Vector3 normalVec = CustomCapeRenderLayer.getNormalVec(oldMatrix, oldMatrix, matrix, new Vector3(x1, y2, z1), new Vector3(x2, y2, z1), new Vector3(x1, y1, z2), light == 0xF000F0);
        NMSHelper.addVertex(bufferBuilder, oldMatrix, x1, y2, z1, maxU, minV += vPerPart * (float)part, class_4608.field_21444, light, normalVec.x, normalVec.y, normalVec.z);
        NMSHelper.addVertex(bufferBuilder, oldMatrix, x2, y2, z1, minU, minV, class_4608.field_21444, light, normalVec.x, normalVec.y, normalVec.z);
        NMSHelper.addVertex(bufferBuilder, matrix, x2, y1, z2, minU, maxV, class_4608.field_21444, light, normalVec.x, normalVec.y, normalVec.z);
        NMSHelper.addVertex(bufferBuilder, matrix, x1, y1, z2, maxU, maxV, class_4608.field_21444, light, normalVec.x, normalVec.y, normalVec.z);
    }

    private static void addFrontVertex(class_4588 bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
            Matrix4f k = matrix;
            matrix = oldMatrix;
            oldMatrix = k;
        }
        float minU = 0.1875f;
        float maxU = 0.34375f;
        float minV = 0.03125f;
        float maxV = 0.53125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / 16.0f;
        maxV = minV + vPerPart * (float)(part + 1);
        Vector3 normalVec = CustomCapeRenderLayer.getNormalVec(oldMatrix, oldMatrix, matrix, new Vector3(x1, y1, z1), new Vector3(x2, y1, z1), new Vector3(x1, y2, z2), light == 0xF000F0);
        NMSHelper.addVertex(bufferBuilder, oldMatrix, x1, y1, z1, minU, maxV, class_4608.field_21444, light, normalVec.x, normalVec.y, normalVec.z);
        NMSHelper.addVertex(bufferBuilder, oldMatrix, x2, y1, z1, maxU, maxV, class_4608.field_21444, light, normalVec.x, normalVec.y, normalVec.z);
        NMSHelper.addVertex(bufferBuilder, matrix, x2, y2, z2, maxU, minV += vPerPart * (float)part, class_4608.field_21444, light, normalVec.x, normalVec.y, normalVec.z);
        NMSHelper.addVertex(bufferBuilder, matrix, x1, y2, z2, minU, minV, class_4608.field_21444, light, normalVec.x, normalVec.y, normalVec.z);
    }

    private static void addLeftVertex(class_4588 bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float minU = 0.0f;
        float maxU = 0.015625f;
        float minV = 0.03125f;
        float maxV = 0.53125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / 16.0f;
        maxV = minV + vPerPart * (float)(part + 1);
        Vector3 normalVec = CustomCapeRenderLayer.getNormalVec(matrix, matrix, oldMatrix, new Vector3(x2, y1, z1), new Vector3(x2, y1, z2), new Vector3(x2, y2, z1), light == 0xF000F0);
        NMSHelper.addVertex(bufferBuilder, matrix, x2, y1, z1, minU, maxV, class_4608.field_21444, light, normalVec.x, normalVec.y, normalVec.z);
        NMSHelper.addVertex(bufferBuilder, matrix, x2, y1, z2, maxU, maxV, class_4608.field_21444, light, normalVec.x, normalVec.y, normalVec.z);
        NMSHelper.addVertex(bufferBuilder, oldMatrix, x2, y2, z2, maxU, minV += vPerPart * (float)part, class_4608.field_21444, light, normalVec.x, normalVec.y, normalVec.z);
        NMSHelper.addVertex(bufferBuilder, oldMatrix, x2, y2, z1, minU, minV, class_4608.field_21444, light, normalVec.x, normalVec.y, normalVec.z);
    }

    private static void addRightVertex(class_4588 bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int part, int light) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float minU = 0.171875f;
        float maxU = 0.1875f;
        float minV = 0.03125f;
        float maxV = 0.53125f;
        float deltaV = maxV - minV;
        float vPerPart = deltaV / 16.0f;
        maxV = minV + vPerPart * (float)(part + 1);
        Vector3 normalVec = CustomCapeRenderLayer.getNormalVec(matrix, matrix, oldMatrix, new Vector3(x2, y1, z2), new Vector3(x2, y1, z1), new Vector3(x2, y2, z2), light == 0xF000F0);
        NMSHelper.addVertex(bufferBuilder, matrix, x2, y1, z2, minU, maxV, class_4608.field_21444, light, normalVec.x, normalVec.y, normalVec.z);
        NMSHelper.addVertex(bufferBuilder, matrix, x2, y1, z1, maxU, maxV, class_4608.field_21444, light, normalVec.x, normalVec.y, normalVec.z);
        NMSHelper.addVertex(bufferBuilder, oldMatrix, x2, y2, z1, maxU, minV += vPerPart * (float)part, class_4608.field_21444, light, normalVec.x, normalVec.y, normalVec.z);
        NMSHelper.addVertex(bufferBuilder, oldMatrix, x2, y2, z2, minU, minV, class_4608.field_21444, light, normalVec.x, normalVec.y, normalVec.z);
    }

    private static void addBottomVertex(class_4588 bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int light) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float minU = 0.171875f;
        float maxU = 0.328125f;
        float minV = 0.0f;
        float maxV = 0.03125f;
        Vector3 normalVec = CustomCapeRenderLayer.getNormalVec(oldMatrix, oldMatrix, matrix, new Vector3(x1, y2, z2), new Vector3(x2, y2, z2), new Vector3(x1, y1, z1), light == 0xF000F0);
        NMSHelper.addVertex(bufferBuilder, oldMatrix, x1, y2, z2, maxU, minV, class_4608.field_21444, light, normalVec.x, normalVec.y, normalVec.z);
        NMSHelper.addVertex(bufferBuilder, oldMatrix, x2, y2, z2, minU, minV, class_4608.field_21444, light, normalVec.x, normalVec.y, normalVec.z);
        NMSHelper.addVertex(bufferBuilder, matrix, x2, y1, z1, minU, maxV, class_4608.field_21444, light, normalVec.x, normalVec.y, normalVec.z);
        NMSHelper.addVertex(bufferBuilder, matrix, x1, y1, z1, maxU, maxV, class_4608.field_21444, light, normalVec.x, normalVec.y, normalVec.z);
    }

    private static void addTopVertex(class_4588 bufferBuilder, Matrix4f matrix, Matrix4f oldMatrix, float x1, float y1, float z1, float x2, float y2, float z2, int light) {
        float i;
        if (x1 < x2) {
            i = x1;
            x1 = x2;
            x2 = i;
        }
        if (y1 < y2) {
            i = y1;
            y1 = y2;
            y2 = i;
        }
        float minU = 0.015625f;
        float maxU = 0.171875f;
        float minV = 0.0f;
        float maxV = 0.03125f;
        Vector3 normalVec = CustomCapeRenderLayer.getNormalVec(oldMatrix, oldMatrix, matrix, new Vector3(x1, y2, z1), new Vector3(x2, y2, z1), new Vector3(x1, y1, z2), light == 0xF000F0);
        NMSHelper.addVertex(bufferBuilder, oldMatrix, x1, y2, z1, maxU, maxV, class_4608.field_21444, light, normalVec.x, normalVec.y, normalVec.z);
        NMSHelper.addVertex(bufferBuilder, oldMatrix, x2, y2, z1, minU, maxV, class_4608.field_21444, light, normalVec.x, normalVec.y, normalVec.z);
        NMSHelper.addVertex(bufferBuilder, matrix, x2, y1, z2, minU, minV, class_4608.field_21444, light, normalVec.x, normalVec.y, normalVec.z);
        NMSHelper.addVertex(bufferBuilder, matrix, x1, y1, z2, maxU, minV, class_4608.field_21444, light, normalVec.x, normalVec.y, normalVec.z);
    }

    private static Vector3 getNormalVec(Matrix4f matrix1, Matrix4f matrix2, Matrix4f matrix3, Vector3 vector1, Vector3 vector2, Vector3 vector3, boolean inverse) {
        Vector3 vector1Transformed = CustomCapeRenderLayer.transform(matrix1, new Vector4(vector1.x, vector1.y, vector1.z, 1.0f)).toVec3();
        Vector3 vector2Transformed = CustomCapeRenderLayer.transform(matrix2, new Vector4(vector2.x, vector2.y, vector2.z, 1.0f)).toVec3();
        Vector3 vector3Transformed = CustomCapeRenderLayer.transform(matrix3, new Vector4(vector3.x, vector3.y, vector3.z, 1.0f)).toVec3();
        vector2Transformed.subtract(vector1Transformed);
        vector3Transformed.subtract(vector1Transformed);
        vector2Transformed.cross(vector3Transformed);
        vector2Transformed.normalize();
        return inverse ? vector2Transformed.mul(-1.0f) : vector2Transformed;
    }

    private static Vector4 transform(Matrix4f matrix, Vector4 vector) {
        Vector4f vector4f = matrix.transform(new Vector4f(vector.x, vector.y, vector.z, vector.w));
        return new Vector4(vector4f.x, vector4f.y, vector4f.z, vector4f.w);
    }

    private CapeRenderer getCapeRenderer(CapeRenderInfo capeRenderInfo, class_4597 multiBufferSource) {
        for (ModSupport support : SupportManager.getSupportedMods()) {
            if (!support.shouldBeUsed(capeRenderInfo)) continue;
            return support.getRenderer();
        }
        if (capeRenderInfo.getCapeTexture() == null || !capeRenderInfo.isCapeVisible()) {
            return null;
        }
        CustomCapeRenderLayer.vanillaCape.vertexConsumer = multiBufferSource.getBuffer(class_1921.method_23576((class_2960)capeRenderInfo.getCapeTexture()));
        return vanillaCape;
    }
}

