/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.tile;

import com.tom.storagemod.Config;
import com.tom.storagemod.Content;
import com.tom.storagemod.StorageMod;
import com.tom.storagemod.block.ITrim;
import com.tom.storagemod.tile.AbstractInventoryCableConnectorBlockEntity;
import com.tom.storagemod.tile.InventoryProxyBlockEntity;
import com.tom.storagemod.util.IProxy;
import com.tom.storagemod.util.InfoHandler;
import com.tom.storagemod.util.InventoryConnectorConfigUtil;
import com.tom.storagemod.util.MergedStorage;
import com.tom.storagemod.util.Priority;
import com.tom.storagemod.util.TickerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_3545;
import org.jetbrains.annotations.Nullable;

public class InventoryConnectorBlockEntity
extends class_2586
implements TickerUtil.TickableServer,
SidedStorageBlockEntity {
    private MergedStorage handlers = new MergedStorage();
    private List<LinkedInv> linkedInvs = new ArrayList<LinkedInv>();

    public InventoryConnectorBlockEntity(class_2338 pos, class_2680 state) {
        super(Content.connectorTile.get(), pos, state);
    }

    @Override
    public void updateServer() {
        long time = this.field_11863.method_8510();
        if (time % 20L == 0L) {
            Stack<class_2338> toCheck = new Stack<class_2338>();
            HashSet<class_2338> checkedBlocks = new HashSet<class_2338>();
            toCheck.add(this.field_11867);
            checkedBlocks.add(this.field_11867);
            this.handlers.clear();
            HashSet<LinkedInv> toRM = new HashSet<LinkedInv>();
            Collections.sort(this.linkedInvs);
            for (LinkedInv inv : this.linkedInvs) {
                MergedStorage ih;
                if (inv.time + 40L < time) {
                    toRM.add(inv);
                    continue;
                }
                Storage<ItemVariant> w = inv.handler.get();
                if (w == null) continue;
                Storage<ItemVariant> ihr = IProxy.resolve(w);
                if (ihr instanceof MergedStorage && this.checkHandlers(ih = (MergedStorage)ihr, 0)) {
                    if (this.handlers.getStorages().contains(InfoHandler.INSTANCE)) continue;
                    this.handlers.add(InfoHandler.INSTANCE);
                    continue;
                }
                this.handlers.add(w);
            }
            this.linkedInvs.removeAll(toRM);
            int range = StorageMod.CONFIG.invRange * StorageMod.CONFIG.invRange;
            while (!toCheck.isEmpty()) {
                class_2338 cp = (class_2338)toCheck.pop();
                for (class_2350 d : class_2350.values()) {
                    class_2745 type;
                    class_2248 block;
                    class_2586 te;
                    class_2338 p = cp.method_10093(d);
                    if (checkedBlocks.contains(p) || !(p.method_10262((class_2382)this.field_11867) < (double)range)) continue;
                    checkedBlocks.add(p);
                    class_2680 state = this.field_11863.method_8320(p);
                    if (state.method_26204() instanceof ITrim) {
                        toCheck.add(p);
                        continue;
                    }
                    if (!InventoryConnectorConfigUtil.canConnect(state.method_26204()) || (te = this.field_11863.method_8321(p)) instanceof InventoryConnectorBlockEntity || te instanceof InventoryProxyBlockEntity || te instanceof AbstractInventoryCableConnectorBlockEntity || te == null || StorageMod.CONFIG.onlyTrims) continue;
                    Storage inv = (Storage)ItemStorage.SIDED.find(this.field_11863, p, state, te, (Object)d.method_10153());
                    if (te instanceof class_2595 && (block = state.method_26204()) instanceof class_2281 && (type = (class_2745)state.method_11654((class_2769)class_2281.field_10770)) != class_2745.field_12569) {
                        class_2745 otype;
                        class_2338 opos = p.method_10093(class_2281.method_9758((class_2680)state));
                        class_2680 ostate = this.method_10997().method_8320(opos);
                        if (state.method_26204() == ostate.method_26204() && (otype = (class_2745)ostate.method_11654((class_2769)class_2281.field_10770)) != class_2745.field_12569 && type != otype && state.method_11654((class_2769)class_2281.field_10768) == ostate.method_11654((class_2769)class_2281.field_10768)) {
                            toCheck.add(opos);
                            checkedBlocks.add(opos);
                        }
                    }
                    if (inv != null) {
                        MergedStorage ih;
                        Storage<ItemVariant> ihr = IProxy.resolve((Storage<ItemVariant>)inv);
                        if (ihr instanceof MergedStorage && this.checkHandlers(ih = (MergedStorage)ihr, 0)) {
                            if (this.handlers.getStorages().contains(InfoHandler.INSTANCE)) continue;
                            this.handlers.add(InfoHandler.INSTANCE);
                            continue;
                        }
                        toCheck.add(p);
                        this.handlers.add((Storage<ItemVariant>)inv);
                    }
                    if (!Config.getMultiblockInvs().contains(state.method_26204())) continue;
                    this.skipBlocks(p, checkedBlocks, toCheck, state.method_26204());
                }
            }
        }
    }

    private void skipBlocks(class_2338 pos, Set<class_2338> checkedBlocks, Stack<class_2338> edges, class_2248 block) {
        Stack<class_2338> toCheck = new Stack<class_2338>();
        toCheck.add(pos);
        edges.add(pos);
        while (!toCheck.isEmpty()) {
            class_2338 cp = (class_2338)toCheck.pop();
            for (class_2350 d : class_2350.values()) {
                class_2680 state;
                class_2338 p = cp.method_10093(d);
                if (checkedBlocks.contains(p) || !(p.method_10262((class_2382)pos) < (double)StorageMod.CONFIG.invRange) || (state = this.field_11863.method_8320(p)).method_26204() != block) continue;
                checkedBlocks.add(p);
                edges.add(p);
                toCheck.add(p);
            }
        }
    }

    private boolean checkHandlers(MergedStorage ih, int depth) {
        if (depth > 3 || ih == this.handlers) {
            return true;
        }
        for (Storage<ItemVariant> lo : ih.getStorages()) {
            MergedStorage i;
            Storage<ItemVariant> ihr = IProxy.resolve(lo);
            if (ihr == this.handlers) {
                return true;
            }
            if (!(ihr instanceof MergedStorage) || !this.checkHandlers(i = (MergedStorage)ihr, depth + 1)) continue;
            return true;
        }
        return false;
    }

    public void addLinked(LinkedInv inv) {
        this.linkedInvs.add(inv);
    }

    public void unLink(LinkedInv linv) {
        this.linkedInvs.remove(linv);
    }

    public Storage<ItemVariant> getInventory() {
        return this.handlers;
    }

    public class_3545<Integer, Integer> getUsage() {
        int slots = 0;
        int free = 0;
        Iterator<StorageView<ItemVariant>> iterator = this.handlers.iterator();
        while (iterator.hasNext()) {
            StorageView<ItemVariant> view = iterator.next();
            ++slots;
            if (!view.isResourceBlank()) continue;
            ++free;
        }
        return new class_3545((Object)slots, (Object)free);
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(class_2350 side) {
        return this.handlers;
    }

    public static class LinkedInv
    implements Comparable<LinkedInv> {
        public Supplier<Storage<ItemVariant>> handler;
        public long time;
        public Priority priority = Priority.NORMAL;

        @Override
        public int compareTo(LinkedInv o) {
            return -this.priority.compareTo(o.priority);
        }
    }
}

