/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.gui;

import com.google.common.collect.Lists;
import com.tom.storagemod.Content;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.platform.PlatformRecipeMenu;
import com.tom.storagemod.tile.StorageTerminalBlockEntity;
import com.tom.storagemod.util.DataSlots;
import com.tom.storagemod.util.IDataReceiver;
import com.tom.storagemod.util.StoredItemStack;
import com.tom.storagemod.util.TerminalSyncManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5421;
import net.minecraft.class_8566;

public class StorageTerminalMenu
extends PlatformRecipeMenu
implements IDataReceiver,
TerminalSyncManager.InteractHandler {
    protected StorageTerminalBlockEntity te;
    protected int playerSlotsStart;
    protected List<SlotStorage> storageSlotList = new ArrayList<SlotStorage>();
    public List<StoredItemStack> itemList = Lists.newArrayList();
    public List<StoredItemStack> itemListClient = Lists.newArrayList();
    public List<StoredItemStack> itemListClientSorted = Lists.newArrayList();
    public List<SlotData> slotData = new ArrayList<SlotData>();
    public TerminalSyncManager sync = new TerminalSyncManager();
    private int lines;
    protected class_1661 pinv;
    public Runnable onPacket;
    public int terminalData;
    public int beaconLvl;
    public String search;
    public boolean noSort;

    public StorageTerminalMenu(int id, class_1661 inv, StorageTerminalBlockEntity te) {
        this(Content.storageTerminal.get(), id, inv, te);
        this.addPlayerSlots(inv, 8, 120);
    }

    public StorageTerminalMenu(class_3917<?> type, int id, class_1661 inv, StorageTerminalBlockEntity te) {
        super(type, id);
        this.te = te;
        this.pinv = inv;
        this.addStorageSlots();
        this.method_17362(DataSlots.create(v -> {
            this.terminalData = v;
            if (this.onPacket != null) {
                this.onPacket.run();
            }
        }, () -> te != null ? te.getSorting() : 0));
        this.method_17362(DataSlots.create(v -> {
            this.beaconLvl = v;
        }, () -> te != null ? te.getBeaconLevel() : -1));
    }

    public StorageTerminalMenu(class_3917<?> type, int id, class_1661 inv) {
        this(type, id, inv, null);
    }

    protected void addStorageSlots() {
        this.addStorageSlots(5, 8, 18);
    }

    public StorageTerminalMenu(int id, class_1661 inv) {
        this(Content.storageTerminal.get(), id, inv);
        this.addPlayerSlots(inv, 8, 120);
    }

    protected void addPlayerSlots(class_1661 playerInventory, int x, int y) {
        int i;
        this.playerSlotsStart = this.field_7761.size() - 1;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)playerInventory, j + i * 9 + 9, x + j * 18, y + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)playerInventory, i, x + i * 18, y + 58));
        }
    }

    protected class_1735 method_7621(class_1735 slotIn) {
        this.slotData.add(new SlotData(slotIn));
        return super.method_7621(slotIn);
    }

    public void setOffset(int x, int y) {
        this.slotData.forEach(d -> d.setOffset(x, y));
    }

    public final void addStorageSlots(int lines, int x, int y) {
        this.storageSlotList.clear();
        this.lines = lines;
        for (int i = 0; i < lines; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new SlotStorage(this.te, i * 9 + j, x + j * 18, y + i * 18));
            }
        }
        this.scrollTo(0.0f);
    }

    protected final void addSlotToContainer(SlotStorage slotStorage) {
        this.storageSlotList.add(slotStorage);
    }

    public boolean method_7597(class_1657 playerIn) {
        return this.te == null || this.te.canInteractWith(playerIn);
    }

    public final void scrollTo(float p_148329_1_) {
        int i = (this.itemListClientSorted.size() + 9 - 1) / 9 - this.lines;
        int j = (int)((double)(p_148329_1_ * (float)i) + 0.5);
        if (j < 0) {
            j = 0;
        }
        for (int k = 0; k < this.lines; ++k) {
            for (int l = 0; l < 9; ++l) {
                int i1 = l + (k + j) * 9;
                if (i1 >= 0 && i1 < this.itemListClientSorted.size()) {
                    this.setSlotContents(l + k * 9, this.itemListClientSorted.get(i1));
                    continue;
                }
                this.setSlotContents(l + k * 9, null);
            }
        }
    }

    public final void setSlotContents(int id, StoredItemStack stack) {
        this.storageSlotList.get((int)id).stack = stack;
    }

    public final SlotStorage getSlotByID(int id) {
        return this.storageSlotList.get(id);
    }

    public void method_7623() {
        if (this.te == null) {
            return;
        }
        Map<StoredItemStack, Long> itemsCount = this.te.getStacks();
        this.sync.update(itemsCount, (class_3222)this.pinv.field_7546, !this.te.getLastSearch().equals(this.search) ? tag -> {
            this.search = this.te.getLastSearch();
            tag.method_10582("s", this.search);
        } : null);
        super.method_7623();
    }

    public final void receiveClientNBTPacket(class_2487 message) {
        if (this.sync.receiveUpdate(message)) {
            this.itemList = this.sync.getAsList();
            if (this.noSort) {
                this.itemListClient.forEach(s -> s.setCount(this.sync.getAmount((StoredItemStack)s)));
            } else {
                this.itemListClient = new ArrayList<StoredItemStack>(this.itemList);
            }
            this.pinv.method_5431();
        }
        if (message.method_10545("s")) {
            this.search = message.method_10558("s");
        }
        if (this.onPacket != null) {
            this.onPacket.run();
        }
    }

    public final class_1799 method_7601(class_1657 playerIn, int index) {
        if (this.field_7761.size() > index) {
            if (index > this.playerSlotsStart && this.te != null) {
                if (this.field_7761.get(index) != null && ((class_1735)this.field_7761.get(index)).method_7681()) {
                    class_1735 slot = (class_1735)this.field_7761.get(index);
                    class_1799 slotStack = slot.method_7677();
                    StoredItemStack c = this.te.pushStack(new StoredItemStack(slotStack, slotStack.method_7947()));
                    class_1799 itemstack = c != null ? c.getActualStack() : class_1799.field_8037;
                    slot.method_7673(itemstack);
                    if (!playerIn.method_37908().field_9236) {
                        this.method_7623();
                    }
                }
            } else {
                return this.shiftClickItems(playerIn, index);
            }
        }
        return class_1799.field_8037;
    }

    protected class_1799 shiftClickItems(class_1657 playerIn, int index) {
        return class_1799.field_8037;
    }

    public void method_7654(class_1662 itemHelperIn) {
    }

    public void method_7657() {
    }

    public boolean method_7652(class_1860<? super class_8566> recipeIn) {
        return false;
    }

    public int method_7655() {
        return 0;
    }

    public int method_7653() {
        return 0;
    }

    public int method_7656() {
        return 0;
    }

    public int method_7658() {
        return 0;
    }

    public void sendMessage(class_2487 compound) {
        NetworkHandler.sendDataToServer(compound);
    }

    @Override
    public void receive(class_2487 message) {
        if (this.pinv.field_7546.method_7325()) {
            return;
        }
        if (message.method_10545("s")) {
            this.te.setLastSearch(message.method_10558("s"));
        }
        this.sync.receiveInteract(message, this);
        if (message.method_10545("c")) {
            class_2487 d = message.method_10562("c");
            this.te.setSorting(d.method_10550("d"));
        }
    }

    public class_5421 method_30264() {
        return class_5421.field_25763;
    }

    public boolean method_32339(int p_150635_) {
        return false;
    }

    @Override
    public void onInteract(StoredItemStack clicked, SlotAction act, boolean mod) {
        class_3222 player = (class_3222)this.pinv.field_7546;
        player.method_14234();
        if (act == SlotAction.SPACE_CLICK) {
            for (int i = this.playerSlotsStart + 1; i < this.playerSlotsStart + 28; ++i) {
                this.method_7601((class_1657)player, i);
            }
        } else if (act == SlotAction.PULL_OR_PUSH_STACK) {
            class_1799 stack = this.method_34255();
            if (!stack.method_7960()) {
                StoredItemStack rem = this.te.pushStack(new StoredItemStack(stack));
                class_1799 itemstack = rem == null ? class_1799.field_8037 : rem.getActualStack();
                this.method_34254(itemstack);
            } else {
                if (clicked == null) {
                    return;
                }
                StoredItemStack pulled = this.te.pullStack(clicked, clicked.getMaxStackSize());
                if (pulled != null) {
                    this.method_34254(pulled.getActualStack());
                }
            }
        } else if (act == SlotAction.PULL_ONE) {
            class_1799 stack = this.method_34255();
            if (clicked == null) {
                return;
            }
            if (mod) {
                StoredItemStack pulled = this.te.pullStack(clicked, 1L);
                if (pulled != null) {
                    class_1799 itemstack = pulled.getActualStack();
                    this.method_7616(itemstack, this.playerSlotsStart + 1, this.field_7761.size(), true);
                    if (itemstack.method_7947() > 0) {
                        this.te.pushOrDrop(itemstack);
                    }
                    player.method_31548().method_5431();
                }
            } else if (!stack.method_7960()) {
                StoredItemStack pulled;
                if (class_1799.method_31577((class_1799)stack, (class_1799)clicked.getStack()) && stack.method_7947() + 1 <= stack.method_7914() && (pulled = this.te.pullStack(clicked, 1L)) != null) {
                    stack.method_7933(1);
                }
            } else {
                StoredItemStack pulled = this.te.pullStack(clicked, 1L);
                if (pulled != null) {
                    this.method_34254(pulled.getActualStack());
                }
            }
        } else if (act == SlotAction.GET_HALF) {
            class_1799 stack = this.method_34255();
            if (!stack.method_7960()) {
                class_1799 stack1 = stack.method_7971(Math.max(Math.min(stack.method_7947(), stack.method_7914()) / 2, 1));
                class_1799 itemstack = this.te.pushStack(stack1);
                stack.method_7933(!itemstack.method_7960() ? itemstack.method_7947() : 0);
                this.method_34254(stack);
            } else {
                if (clicked == null) {
                    return;
                }
                StoredItemStack pulled = this.te.pullStack(clicked, Math.max(Math.min(clicked.getQuantity(), (long)clicked.getMaxStackSize()) / 2L, 1L));
                if (pulled != null) {
                    this.method_34254(pulled.getActualStack());
                }
            }
        } else if (act == SlotAction.GET_QUARTER) {
            class_1799 stack = this.method_34255();
            if (!stack.method_7960()) {
                class_1799 stack1 = stack.method_7971(Math.max(Math.min(stack.method_7947(), stack.method_7914()) / 4, 1));
                class_1799 itemstack = this.te.pushStack(stack1);
                stack.method_7933(!itemstack.method_7960() ? itemstack.method_7947() : 0);
                this.method_34254(stack);
            } else {
                if (clicked == null) {
                    return;
                }
                StoredItemStack pulled = this.te.pullStack(clicked, Math.max(Math.min(clicked.getQuantity(), (long)clicked.getMaxStackSize()) / 4L, 1L));
                if (pulled != null) {
                    this.method_34254(pulled.getActualStack());
                }
            }
        } else {
            if (clicked == null) {
                return;
            }
            StoredItemStack pulled = this.te.pullStack(clicked, clicked.getMaxStackSize());
            if (pulled != null) {
                class_1799 itemstack = pulled.getActualStack();
                this.method_7616(itemstack, this.playerSlotsStart + 1, this.field_7761.size(), true);
                if (itemstack.method_7947() > 0) {
                    this.te.pushOrDrop(itemstack);
                }
                player.method_31548().method_5431();
            }
        }
    }

    public StorageTerminalBlockEntity getTerminal() {
        return this.te;
    }

    public record SlotData(class_1735 slot, int x, int y) {
        public SlotData(class_1735 s) {
            this(s, s.field_7873, s.field_7872);
        }

        public void setOffset(int x, int y) {
            this.slot.field_7873 = this.x + x;
            this.slot.field_7872 = this.y + y;
        }
    }

    public static class SlotStorage {
        public int xDisplayPosition;
        public int yDisplayPosition;
        private final int slotIndex;
        public final StorageTerminalBlockEntity inventory;
        public StoredItemStack stack;

        public SlotStorage(StorageTerminalBlockEntity inventory, int slotIndex, int xPosition, int yPosition) {
            this.xDisplayPosition = xPosition;
            this.yDisplayPosition = yPosition;
            this.slotIndex = slotIndex;
            this.inventory = inventory;
        }

        public class_1799 pullFromSlot(long max) {
            if (this.stack == null || max < 1L || this.inventory == null) {
                return class_1799.field_8037;
            }
            StoredItemStack r = this.inventory.pullStack(this.stack, max);
            if (r != null) {
                return r.getActualStack();
            }
            return class_1799.field_8037;
        }

        public class_1799 pushStack(class_1799 pushStack) {
            if (this.inventory == null) {
                return pushStack;
            }
            StoredItemStack r = this.inventory.pushStack(new StoredItemStack(pushStack, pushStack.method_7947()));
            if (r != null) {
                return r.getActualStack();
            }
            return class_1799.field_8037;
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }
    }

    public static enum SlotAction {
        PULL_OR_PUSH_STACK,
        PULL_ONE,
        SPACE_CLICK,
        SHIFT_PULL,
        GET_HALF,
        GET_QUARTER;

        public static final SlotAction[] VALUES;

        static {
            VALUES = SlotAction.values();
        }
    }
}

