/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod;

import com.tom.storagemod.StorageMod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

@me.shedaniel.autoconfig.annotation.Config(name="toms_storage")
public class Config
implements ConfigData {
    public boolean onlyTrims = false;
    public int invRange = 16;
    public int wirelessRange = 16;
    public int invConnectorMaxCables = 2048;
    public List<String> multiblockInv = new ArrayList<String>();
    public int advWirelessRange = 64;
    @ConfigEntry.Gui.Tooltip
    public int wirelessTermBeaconLvl = 1;
    @ConfigEntry.Gui.Tooltip
    public int wirelessTermBeaconLvlDim = 4;
    public int invLinkBeaconLvl = 1;
    public int invLinkBeaconLvlDim = 2;
    public List<String> blockedBlocks = new ArrayList<String>(Arrays.asList("create:belt"));
    public List<String> blockedMods = new ArrayList<String>();

    public void validatePostLoad() throws ConfigData.ValidationException {
        if (this.invRange < 4 || this.invRange > 64) {
            this.invRange = 16;
            StorageMod.LOGGER.warn("Inventory Connector Range out of bounds, resetting to default");
        }
        if (this.wirelessRange < 4 || this.wirelessRange > 64) {
            this.wirelessRange = 16;
            StorageMod.LOGGER.warn("Wireless Range out of bounds, resetting to default");
        }
        if (this.invConnectorMaxCables < 4) {
            this.invConnectorMaxCables = 2048;
            StorageMod.LOGGER.warn("Inventory Cable Range out of bounds, resetting to default");
        }
        if (this.advWirelessRange < 16 || this.advWirelessRange > 512) {
            this.advWirelessRange = 64;
            StorageMod.LOGGER.warn("Adv Wireless Range out of bounds, resetting to default");
        }
        if (this.wirelessTermBeaconLvl < -1 || this.wirelessTermBeaconLvl > 4) {
            this.wirelessTermBeaconLvl = 1;
            StorageMod.LOGGER.warn("wirelessTermBeaconLvl out of bounds, resetting to default");
        }
        if (this.wirelessTermBeaconLvlDim < -1 || this.wirelessTermBeaconLvlDim > 4) {
            this.wirelessTermBeaconLvlDim = 4;
            StorageMod.LOGGER.warn("wirelessTermBeaconLvlDim out of bounds, resetting to default");
        }
        if (this.invLinkBeaconLvl < -1 || this.invLinkBeaconLvl > 4) {
            this.invLinkBeaconLvl = 1;
            StorageMod.LOGGER.warn("invLinkBeaconLvl out of bounds, resetting to default");
        }
        if (this.invLinkBeaconLvlDim < -1 || this.invLinkBeaconLvlDim > 4) {
            this.invLinkBeaconLvlDim = 2;
            StorageMod.LOGGER.warn("invLinkBeaconLvlDim out of bounds, resetting to default");
        }
        StorageMod.LOGGER.info("Config loaded");
    }

    private void reloadConfig() {
        StorageMod.multiblockInvs = this.multiblockInv.stream().map(class_2960::method_12829).filter(e -> e != null).map(id -> (class_2248)class_7923.field_41175.method_10223(id)).filter(e -> e != null && e != class_2246.field_10124).collect(Collectors.toSet());
        StorageMod.blockedBlocks = this.blockedBlocks.stream().map(class_2960::method_12829).filter(e -> e != null).map(id -> (class_2248)class_7923.field_41175.method_10223(id)).filter(e -> e != null && e != class_2246.field_10124).collect(Collectors.toSet());
    }

    public static Set<class_2248> getMultiblockInvs() {
        if (StorageMod.multiblockInvs == null) {
            StorageMod.CONFIG.reloadConfig();
        }
        return StorageMod.multiblockInvs;
    }

    public Set<class_2248> getBlockedBlocks() {
        if (StorageMod.blockedBlocks == null) {
            StorageMod.CONFIG.reloadConfig();
        }
        return StorageMod.blockedBlocks;
    }

    public List<String> getBlockedMods() {
        return this.blockedMods;
    }

    public static Config get() {
        return StorageMod.CONFIG;
    }
}

