/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_optimization;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.conczin.immersive_optimization.Constants;
import net.conczin.immersive_optimization.config.Config;
import net.conczin.immersive_optimization.mixin.EntityTickListAccessor;
import net.conczin.immersive_optimization.mixin.ServerLevelAccessor;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class TickScheduler {
    public static TickScheduler INSTANCE = new TickScheduler();
    public static final int THREAD_SLEEP = 500;
    public static final int MAX_STRESS_TICKS = 600;
    public static final int CLEAR_BLOCK_ENTITIES_INTERVAL = 207;
    public static final int CLEAR_ENTITIES_INTERVAL = 12007;
    public MinecraftServer server;
    public FrustumProxy frustum;
    public final Map<class_2960, LevelData> levelData = new ConcurrentHashMap<class_2960, LevelData>();

    public static void setServer(MinecraftServer server) {
        TickScheduler.INSTANCE.server = server;
        INSTANCE.reset();
        Thread worker = new Thread((Runnable)new Worker(INSTANCE, server), "Immersive Optimization Worker");
        worker.setPriority(1);
        worker.setDaemon(true);
        worker.start();
    }

    @Nullable
    public LevelData getLevelData(class_1937 level) {
        return this.levelData.get(level.method_27983().method_29177());
    }

    public void reset() {
        this.levelData.clear();
        this.frustum = null;
    }

    public void startLevelTick(class_3218 level) {
        boolean stressed;
        LevelData data = this.getLevelData((class_1937)level);
        if (data == null) {
            return;
        }
        int stressedThreshold = Config.getInstance().stressedThreshold;
        boolean bl = stressed = stressedThreshold > 0 && this.server.method_3830() > (float)stressedThreshold;
        if (data.outOfBudget || stressed) {
            data.stressedTicks = Math.min(600, data.stressedTicks + 2);
            if (stressed) {
                ++data.lifeTimeStressedTicks;
            }
            if (data.outOfBudget) {
                ++data.lifeTimeBudgetTicks;
            }
            data.outOfBudget = false;
        } else {
            data.stressedTicks = Math.max(0, data.stressedTicks - 1);
        }
        ++data.tick;
        data.time = System.nanoTime();
    }

    void tick() {
        int totalEntities = 0;
        for (LevelData data : this.levelData.values()) {
            totalEntities += data.stats.entities;
        }
        for (LevelData data : this.levelData.values()) {
            double budget = Config.getInstance().entityTickBudget;
            data.budget = budget > 0.0 ? (long)(Math.max(0.1, ((double)data.stats.entities + 1.0) / ((double)totalEntities + 1.0)) * budget * 1000000.0) : 0L;
        }
    }

    void tickLevel(class_1937 level) {
        LevelData data = this.levelData.computeIfAbsent(level.method_27983().method_29177(), LevelData::new);
        long tick = level.method_8510();
        Stats previousStats = data.previousStats;
        data.previousStats = data.stats;
        data.stats = previousStats;
        data.stats.reset();
        if (tick % 12007L == 0L) {
            data.budgeted.clear();
        }
        if (tick % 207L == 0L) {
            data.blockEntityPriorities.clear();
        }
        if (!Config.getInstance().enableEntities) {
            data.priorities.clear();
            return;
        }
        Int2IntOpenHashMap newPriorities = new Int2IntOpenHashMap();
        Int2ObjectMap<class_1297> entities = ((EntityTickListAccessor)((ServerLevelAccessor)level).getEntityTickList()).getActive();
        entities.values().forEach(entity -> {
            if (entity != null) {
                int priority = this.getPriority(data, level, (class_1297)entity);
                if (priority > 0) {
                    newPriorities.put(entity.method_5628(), priority);
                }
                data.stats.tickRate += 1.0 / (double)Math.max(1, priority);
                ++data.stats.entities;
            }
        });
        data.priorities = newPriorities;
    }

    public boolean shouldTick(class_1297 entity) {
        if (entity.field_5985 || INSTANCE == null) {
            return true;
        }
        LevelData data = this.getLevelData(entity.method_37908());
        if (data == null) {
            return true;
        }
        int priority = data.priorities.getOrDefault(entity.method_5628(), 0);
        if (priority <= 1) {
            return true;
        }
        if (data.outOfBudget) {
            data.budgeted.put(entity.method_5628(), data.budgeted.getOrDefault(entity.method_5628(), 0) + 1);
            return false;
        }
        long delta = System.nanoTime() - data.time;
        if (data.budget > 0L && delta > data.budget) {
            data.outOfBudget = true;
        }
        int budgeted = data.budgeted.getOrDefault(entity.method_5628(), 0);
        if ((data.tick + (long)entity.method_5628()) % (long)Math.max(1, priority - budgeted) == 0L) {
            if (budgeted > 0) {
                data.budgeted.put(entity.method_5628(), budgeted - 1);
            }
            return true;
        }
        return false;
    }

    public int getPriority(LevelData data, class_1937 level, class_1297 entity) {
        Config config = Config.getInstance();
        class_2960 id = class_7923.field_41177.method_10221((Object)entity.method_5864());
        if (!config.entities.getOrDefault(id.toString(), true).booleanValue()) {
            return 0;
        }
        if (!config.entities.getOrDefault(id.method_12836(), true).booleanValue()) {
            return 0;
        }
        double minDistance = 999999.0;
        for (class_1657 player : level.method_18456()) {
            minDistance = Math.min(minDistance, player.method_5858(entity));
        }
        class_238 box = entity.method_5829();
        int blocksPerLevel = config.blocksPerLevel;
        if (config.enableDistanceCulling && !entity.method_5640(minDistance)) {
            blocksPerLevel = config.blocksPerLevelDistanceCulled;
            ++data.stats.distanceCulledEntities;
        }
        if (config.enableViewportCulling && blocksPerLevel > config.blocksPerLevelViewportCulled && level.method_18456().size() == 1 && this.frustum != null && !this.frustum.isVisible(box)) {
            blocksPerLevel = config.blocksPerLevelViewportCulled;
            ++data.stats.viewportCulledEntities;
        }
        double antiStress = 1.0 - (double)data.stressedTicks / 600.0;
        int finalBlocksPerLevel = (int)((double)blocksPerLevel * antiStress);
        int distanceLevel = (int)((Math.sqrt(minDistance) - (double)config.minDistance) / (double)Math.max(2, finalBlocksPerLevel));
        return Math.min(config.maxLevel, Math.max(1, distanceLevel + 1));
    }

    public boolean shouldTick(class_1937 level, long pos) {
        if (!Config.getInstance().enableBlockEntities) {
            return true;
        }
        LevelData data = this.getLevelData(level);
        if (data == null) {
            return true;
        }
        int priority = data.blockEntityPriorities.computeIfAbsent(pos, p -> this.getBlockEntityPriority(level, (long)p));
        return priority < 1 || (level.method_8510() + pos) % (long)priority == 0L;
    }

    private int getBlockEntityPriority(class_1937 level, long p) {
        int x = class_1923.method_8325((long)p);
        int z = class_1923.method_8332((long)p);
        double minDistance = Double.MAX_VALUE;
        for (class_1657 player : level.method_18456()) {
            double dz;
            double dx = class_4076.method_42615((double)player.method_23317()) - x;
            double distance = dx * dx + (dz = (double)(class_4076.method_42615((double)player.method_23321()) - z)) * dz;
            if (!(distance < minDistance)) continue;
            minDistance = distance;
        }
        return Math.min((int)((Math.sqrt(minDistance * 16.0) - (double)Config.getInstance().minDistance) / (double)Config.getInstance().blocksPerLevelBlockEntities) + 1, Config.getInstance().maxLevel);
    }

    public static class Worker
    implements Runnable {
        TickScheduler scheduler;
        MinecraftServer server;

        public Worker(TickScheduler scheduler, MinecraftServer server) {
            this.scheduler = scheduler;
            this.server = server;
        }

        @Override
        public void run() {
            while (this.server.method_3806()) {
                try {
                    this.scheduler.tick();
                    for (class_3218 level : this.server.method_3738()) {
                        this.scheduler.tickLevel((class_1937)level);
                    }
                    Thread.sleep(500L);
                }
                catch (ArrayIndexOutOfBoundsException | ConcurrentModificationException runtimeException) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Constants.LOG.info("Shutting down Immersive Optimization worker");
        }
    }

    public static class LevelData {
        public boolean active;
        public long tick = 0L;
        public long time = 0L;
        public long budget = 50000000L;
        public boolean outOfBudget = false;
        public Stats stats = new Stats();
        public Stats previousStats = new Stats();
        public int stressedTicks = 0;
        public int lifeTimeStressedTicks = 0;
        public int lifeTimeBudgetTicks = 0;
        public Map<Integer, Integer> budgeted = new ConcurrentHashMap<Integer, Integer>();
        public Int2IntOpenHashMap priorities = new Int2IntOpenHashMap();
        public Map<Long, Integer> blockEntityPriorities = new ConcurrentHashMap<Long, Integer>();

        public LevelData(class_2960 location) {
            this.active = Config.getInstance().dimensions.getOrDefault(location.toString(), true);
        }

        public String toLog() {
            return "Rate %2.1f%%, %d entities, %d stress, %d stressed, %d budgeted | culled %2.1f%% distance, %2.1f%% viewport".formatted(this.previousStats.tickRate / (double)this.previousStats.entities * 100.0, this.previousStats.entities, this.stressedTicks, this.lifeTimeStressedTicks, this.lifeTimeBudgetTicks, Float.valueOf((float)this.previousStats.distanceCulledEntities / (float)this.previousStats.entities * 100.0f), Float.valueOf((float)this.previousStats.viewportCulledEntities / (float)this.previousStats.entities * 100.0f));
        }
    }

    public static interface FrustumProxy {
        public boolean isVisible(class_238 var1);
    }

    public static class Stats {
        public double tickRate = 0.0;
        public int entities = 0;
        public int distanceCulledEntities = 0;
        public int viewportCulledEntities = 0;

        public void reset() {
            this.tickRate = 0.0;
            this.entities = 0;
            this.distanceCulledEntities = 0;
            this.viewportCulledEntities = 0;
        }
    }
}

