/*
 * Decompiled with CFR 0.152.
 */
package fr.hugman.dawn.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.terraformersmc.terraform.shapes.api.Position;
import com.terraformersmc.terraform.shapes.api.Shape;
import com.terraformersmc.terraform.shapes.api.layer.Layer;
import com.terraformersmc.terraform.shapes.impl.layer.transform.TranslateLayer;
import fr.hugman.dawn.Dawn;
import fr.hugman.dawn.registry.DawnRegistries;
import fr.hugman.dawn.shape.ConfiguredShape;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2247;
import net.minecraft.class_2257;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3829;
import net.minecraft.class_7157;

public class ShapeCommand {
    private static final int MAX_BLOCKS = 32768;
    private static final DynamicCommandExceptionType INVALID_SHAPE_EXCEPTION = new DynamicCommandExceptionType(id -> class_2561.method_43469((String)"commands.shape.fail.invalid_id", (Object[])new Object[]{id}));
    private static final SimpleCommandExceptionType TOO_COMPLEX_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.shape.fail.too_complex"));
    private static final Dynamic2CommandExceptionType TOO_BIG_EXCEPTION = new Dynamic2CommandExceptionType((maxCount, count) -> class_2561.method_43469((String)"commands.shape.fail.too_much", (Object[])new Object[]{maxCount, count}));
    public static final SuggestionProvider<class_2168> SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9270(DawnRegistries.CONFIGURED_SHAPE.getIds(), (SuggestionsBuilder)builder);
    public static final String NAME = "shape";
    public static final String CONFIGURED_SHAPE_ARG = "configured_shape";
    public static final String POS_ARG = "pos";
    public static final String FILL_ARG = "fill";
    public static final String BLOCK_ARG = "block";

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)NAME).requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)CONFIGURED_SHAPE_ARG, (ArgumentType)class_2232.method_9441()).suggests(SUGGESTION_PROVIDER).then(class_2170.method_9244((String)POS_ARG, (ArgumentType)class_2262.method_9698()).then(class_2170.method_9247((String)FILL_ARG).then(class_2170.method_9244((String)BLOCK_ARG, (ArgumentType)class_2257.method_9653((class_7157)registryAccess)).executes(context -> ShapeCommand.fillShape((class_2168)context.getSource(), class_2232.method_9443((CommandContext)context, (String)CONFIGURED_SHAPE_ARG), class_2262.method_9696((CommandContext)context, (String)POS_ARG), class_2257.method_9655((CommandContext)context, (String)BLOCK_ARG))))))));
    }

    private static int fillShape(class_2168 source, class_2960 identifier, class_2338 origin, class_2247 stateArgument) throws CommandSyntaxException {
        List positions;
        ConfiguredShape configuredShape = DawnRegistries.CONFIGURED_SHAPE.get(identifier);
        if (configuredShape == null) {
            throw INVALID_SHAPE_EXCEPTION.create((Object)identifier);
        }
        class_3218 world = source.method_9225();
        Shape shape = configuredShape.get(source.method_9225().method_8409());
        shape = shape.applyLayer((Layer)new TranslateLayer(Position.of((class_2338)origin)));
        Dawn.LOGGER.info("Trying to stream shape");
        try {
            positions = shape.stream().toList();
        }
        catch (OutOfMemoryError e) {
            throw TOO_COMPLEX_EXCEPTION.create();
        }
        int i = positions.size();
        if (i > 32768) {
            throw TOO_BIG_EXCEPTION.create((Object)32768, (Object)i);
        }
        for (Position pos : positions) {
            class_2338 blockPos = pos.toBlockPos();
            class_3829.method_16825((Object)world.method_8321(blockPos));
            stateArgument.method_9495(world, blockPos, 2);
        }
        source.method_9226(() -> class_2561.method_43469((String)"commands.shape.fill.success", (Object[])new Object[]{identifier, i, stateArgument.method_9494().method_26204().method_9518()}), true);
        return i;
    }
}

