/*
 * Decompiled with CFR 0.152.
 */
package wraith.alloyforgery.recipe;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_3859;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import wraith.alloyforgery.AlloyForgery;
import wraith.alloyforgery.recipe.AlloyForgeRecipe;
import wraith.alloyforgery.utils.RecipeInjector;

public class BlastFurnaceRecipeAdapter
implements RecipeInjector.AddRecipes {
    private static final class_6862<class_1792> DUSTS_TAG = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960("c", "dusts"));
    public static final class_2960 BLACKLISTED_BLASTING_RECIPES = AlloyForgery.id("blacklisted_blasting_recipes");
    public static final class_2960 BLACKLISTED_INCREASED_OUTPUT = AlloyForgery.id("blacklisted_increased_blasting_outputs");

    @Override
    public void addRecipes(RecipeInjector instance) {
        class_1863 manager = instance.manager();
        List alloyForgeryRecipes = manager.method_30027((class_3956)AlloyForgeRecipe.Type.INSTANCE);
        for (class_3859 recipe : manager.method_30027(class_3956.field_17547)) {
            if (!BlastFurnaceRecipeAdapter.isUniqueRecipe(alloyForgeryRecipes, recipe) || recipe.isIn(BLACKLISTED_BLASTING_RECIPES)) continue;
            class_2960 secondaryID = recipe.method_8114();
            String path = secondaryID.method_12832();
            if (path.contains("blasting")) {
                path = path.replace("blasting", "forging");
            }
            class_1799 mainOutput = recipe.method_8110(null);
            ImmutableMap.Builder extraOutput = ImmutableMap.builder();
            if (!recipe.isIn(BLACKLISTED_INCREASED_OUTPUT) && !BlastFurnaceRecipeAdapter.isDustRecipe(recipe)) {
                class_1799 increasedOutput = mainOutput.method_7972();
                increasedOutput.method_7933(1);
                extraOutput.put((Object)new AlloyForgeRecipe.OverrideRange(3), (Object)increasedOutput);
            }
            AlloyForgeRecipe convertRecipe = new AlloyForgeRecipe(AlloyForgery.id(path), Map.of((class_1856)recipe.method_8117().get(0), 1), mainOutput, 1, Math.round(BlastFurnaceRecipeAdapter.getFuelPerTick(recipe)), (ImmutableMap<AlloyForgeRecipe.OverrideRange, class_1799>)extraOutput.build()).setSecondaryID(secondaryID);
            instance.addRecipe(convertRecipe);
        }
    }

    private static float getFuelPerTick(class_3859 recipe) {
        return (float)recipe.method_8167() / 200.0f * 10.0f;
    }

    private static boolean isUniqueRecipe(List<AlloyForgeRecipe> alloyForgeryRecipes, class_1860<?> blastRecipe) {
        class_1799[] stacks = ((class_1856)blastRecipe.method_8117().get(0)).method_8105();
        List<AlloyForgeRecipe> matchedRecipes = alloyForgeryRecipes.stream().filter(recipe -> {
            if (recipe.getIngredientsMap().size() > 1) {
                return false;
            }
            for (class_1799 stack : stacks) {
                if (!((class_1856)recipe.method_8117().get(0)).method_8093(stack)) continue;
                return true;
            }
            return false;
        }).toList();
        return matchedRecipes.isEmpty();
    }

    private static boolean isDustRecipe(class_1860<?> blastRecipe) {
        if (blastRecipe.method_8114().method_12832().contains("dust")) {
            return true;
        }
        class_1856 inputIngredient = (class_1856)blastRecipe.method_8117().get(0);
        for (class_1799 stack : inputIngredient.method_8105()) {
            if (stack.method_31573(DUSTS_TAG)) {
                return true;
            }
            class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
            if (!id.method_12832().contains("dust")) continue;
            return true;
        }
        return false;
    }
}

