/*
 * Decompiled with CFR 0.152.
 */
package net.deadlydiamond98.healpgood.entities.health;

import java.util.Calendar;
import net.deadlydiamond98.healpgood.entities.health.HealthEntity;
import net.deadlydiamond98.healpgood.util.HealthConfig;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class HealthRenderer<T extends class_1297>
extends class_897<HealthEntity> {
    private static boolean baglification = HealthConfig.baglification;
    private static boolean seasonal = HealthConfig.holidayHearts;

    public HealthRenderer(class_5617.class_5618 ctx) {
        super(ctx);
        this.field_4673 = 0.15f;
        this.field_4672 = 0.75f;
    }

    public void render(HealthEntity entity, float yaw, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light) {
        matrices.method_22903();
        matrices.method_22905(-1.0f, -1.0f, 1.0f);
        matrices.method_22904(0.0, -0.25, 0.0);
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        matrices.method_22907(class_7833.field_40716.rotationDegrees(camera.method_19330()));
        double ageInTicks = (float)entity.field_6012 + tickDelta;
        float bobbingHeight = (float)Math.sin(ageInTicks / 10.0) * 0.1f + 0.1f;
        matrices.method_22904(0.0, (double)(bobbingHeight / 2.0f), 0.0);
        float textureHeight = 0.07692308f;
        float textureWidth = 0.11111111f;
        float minV = textureHeight * (float)entity.currentFramey;
        float maxV = minV + textureHeight;
        float minU = textureWidth * (float)entity.currentFramex;
        float maxU = minU + textureWidth;
        class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_23580((class_2960)this.getTexture(entity)));
        class_4587.class_4665 matrixEntry = matrices.method_23760();
        Matrix4f modelMatrix = matrixEntry.method_23761();
        Matrix3f normalMatrix = matrixEntry.method_23762();
        vertexConsumer.method_22918(modelMatrix, -0.25f, 0.25f, 0.0f).method_1336(255, 255, 255, 255).method_22913(minU, maxV).method_22922(class_4608.field_21444).method_22916(light).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
        vertexConsumer.method_22918(modelMatrix, 0.25f, 0.25f, 0.0f).method_1336(255, 255, 255, 255).method_22913(maxU, maxV).method_22922(class_4608.field_21444).method_22916(light).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
        vertexConsumer.method_22918(modelMatrix, 0.25f, -0.25f, 0.0f).method_1336(255, 255, 255, 255).method_22913(maxU, minV).method_22922(class_4608.field_21444).method_22916(light).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
        vertexConsumer.method_22918(modelMatrix, -0.25f, -0.25f, 0.0f).method_1336(255, 255, 255, 255).method_22913(minU, minV).method_22922(class_4608.field_21444).method_22916(light).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
        matrices.method_22909();
        super.method_3936((class_1297)entity, yaw, tickDelta, matrices, vertexConsumers, light);
    }

    public class_2960 getTexture(HealthEntity entity) {
        Calendar calender = Calendar.getInstance();
        if (HealthRenderer.isBaglification() || calender.get(2) == 3 && calender.get(5) == 1 && HealthRenderer.isSeasonal()) {
            return new class_2960("healpgood", "textures/item/bagelification.png");
        }
        if (calender.get(2) == 5 && HealthRenderer.isSeasonal()) {
            return new class_2960("healpgood", "textures/item/pride_hearts.png");
        }
        if (calender.get(2) == 11 && HealthRenderer.isSeasonal()) {
            return new class_2960("healpgood", "textures/item/christmas_heart.png");
        }
        return new class_2960("healpgood", "textures/item/heart.png");
    }

    public static void setBaglification(boolean baglificat) {
        baglification = baglificat;
    }

    public static boolean isBaglification() {
        return baglification;
    }

    public static void setSeasonal(boolean season) {
        seasonal = season;
    }

    public static boolean isSeasonal() {
        return seasonal;
    }
}

