/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.mixin;

import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.config.SOFConfig;
import de.siphalor.spiceoffabric.foodhistory.FoodHistory;
import de.siphalor.spiceoffabric.util.IHungerManager;
import de.siphalor.spiceoffabric.util.IServerPlayerEntity;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1702.class})
public abstract class MixinHungerManager
implements IHungerManager {
    @Shadow
    private float field_7753;
    @Unique
    @Nullable
    protected class_3222 player = null;
    @Unique
    protected FoodHistory foodHistory = new FoodHistory();

    @Shadow
    public abstract void method_7585(int var1, float var2);

    @Override
    public void spiceOfFabric_setPlayer(class_3222 serverPlayerEntity) {
        this.player = serverPlayerEntity;
    }

    @Override
    public void spiceOfFabric_clearHistory() {
        this.foodHistory.reset();
    }

    @Override
    public void spiceOfFabric_setSaturationLevel(float level) {
        this.field_7753 = level;
    }

    @Override
    public FoodHistory spiceOfFabric_getFoodHistory() {
        return this.foodHistory;
    }

    @Override
    public void spiceOfFabric_setFoodHistory(FoodHistory foodHistory) {
        this.foodHistory = foodHistory;
    }

    @Inject(method={"readNbt"}, at={@At(value="RETURN")})
    public void onDeserialize(class_2487 data, CallbackInfo callbackInfo) {
        if (data.method_10573("spiceOfFabric_history", 10)) {
            this.foodHistory = FoodHistory.read(data.method_10562("spiceOfFabric_history"));
            if (this.player != null && SOFConfig.carrot.enable) {
                class_1324 healthAttribute = this.player.method_5996(class_5134.field_23716);
                if (healthAttribute == null) {
                    SpiceOfFabric.LOGGER.error("Players must have a maximum health!");
                    return;
                }
                if (data.method_10545("spiceOfFabric_version")) {
                    class_1322 modifier = healthAttribute.method_6199(SpiceOfFabric.PLAYER_HEALTH_MODIFIER_UUID);
                    if (modifier == null) {
                        SpiceOfFabric.updateMaxHealth(this.player, false, false);
                    }
                } else {
                    healthAttribute.method_6200(SpiceOfFabric.PLAYER_HEALTH_MODIFIER_UUID);
                    healthAttribute.method_6192(20.0);
                    healthAttribute.method_26837(new class_1322(SpiceOfFabric.PLAYER_HEALTH_MODIFIER_UUID, "spiceoffabric", (double)this.foodHistory.getCarrotHealthOffset((class_1657)this.player), class_1322.class_1323.field_6328));
                }
            }
        }
        if (this.player != null) {
            ((IServerPlayerEntity)this.player).spiceOfFabric_scheduleFoodHistorySync();
        }
    }

    @Inject(method={"writeNbt"}, at={@At(value="RETURN")})
    public void onSerialize(class_2487 data, CallbackInfo callbackInfo) {
        data.method_10566("spiceOfFabric_history", (class_2520)this.foodHistory.write(new class_2487()));
        data.method_10566("spiceOfFabric_version", (class_2520)class_2497.method_23247((int)1));
    }
}

