/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.item;

import com.mojang.datafixers.util.Pair;
import de.siphalor.capsaicin.api.food.CamoFoodContext;
import de.siphalor.capsaicin.api.food.CamoFoodItem;
import de.siphalor.capsaicin.api.food.DynamicFoodPropertiesAccess;
import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.container.FoodContainerScreenHandler;
import de.siphalor.spiceoffabric.container.ItemStackInventory;
import de.siphalor.spiceoffabric.foodhistory.FoodHistory;
import de.siphalor.spiceoffabric.util.IServerPlayerEntity;
import de.siphalor.spiceoffabric.util.IndexedValue;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_4174;
import net.minecraft.class_5328;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoodContainerItem
extends class_1792
implements CamoFoodItem {
    private static final String INVENTORY_NBT_KEY = "inventory";
    private static final class_2583 LORE_STYLE = class_2583.field_24360.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(false));
    private static final class_2561 LORE_EMPTY = class_2561.method_43471((String)"spiceoffabric.food_container.lore.empty").method_10862(LORE_STYLE);
    private static final String LORE_GENERAL_KEY = "spiceoffabric.food_container.lore.general";
    private static final IndexedValue<class_1799> NO_STACK = new IndexedValue<class_1799>(-1, class_1799.field_8037);
    private final class_3917<?> screenHandlerType;
    private final int size;

    public FoodContainerItem(class_1792.class_1793 settings, int size, class_3917<?> screenHandlerType) {
        super(settings);
        this.screenHandlerType = screenHandlerType;
        this.size = size;
    }

    public class_3917<?> getScreenHandlerType() {
        return this.screenHandlerType;
    }

    public int getSize() {
        return this.size;
    }

    public class_1799 getNextFoodStack(class_1799 stack, class_1657 player) {
        return this.getNextFoodStack(this.getInventory(stack), player).value();
    }

    private IndexedValue<class_1799> getNextFoodStack(ItemStackInventory inventory, class_1657 player) {
        FoodHistory foodHistory = FoodHistory.get(player);
        if (foodHistory == null) {
            return NO_STACK;
        }
        ArrayList<IndexedValue<Pair<class_1799, class_4174>>> filteredInv = new ArrayList<IndexedValue<Pair<class_1799, class_4174>>>(inventory.method_5439());
        DynamicFoodPropertiesAccess foodPropertiesAccess = DynamicFoodPropertiesAccess.create();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960()) continue;
            class_4174 foodComponent = foodPropertiesAccess.withStack(stack).getModifiedFoodComponent();
            if (foodComponent == null) {
                SpiceOfFabric.LOGGER.warn("Non-food stack " + stack + " found in food container " + this);
                continue;
            }
            if (stack.method_7960() || !player.method_7332(foodComponent.method_19233())) continue;
            filteredInv.add(new IndexedValue<Pair>(i, Pair.of((Object)stack, (Object)foodComponent)));
        }
        if (filteredInv.isEmpty()) {
            return NO_STACK;
        }
        int requiredFood = 20 - player.method_7344().method_7586();
        return this.findMostAppropriateFood(filteredInv, requiredFood);
    }

    private IndexedValue<class_1799> findMostAppropriateFood(List<IndexedValue<Pair<class_1799, class_4174>>> foods, int requiredFood) {
        IndexedValue<class_1799> bestStack = NO_STACK;
        int bestDelta = Integer.MAX_VALUE;
        int bestConsumeTime = Integer.MAX_VALUE;
        for (IndexedValue<Pair<class_1799, class_4174>> value : foods) {
            class_1799 stack = (class_1799)value.value().getFirst();
            int delta = requiredFood - ((class_4174)value.value().getSecond()).method_19230();
            int consumeTime = stack.method_7935();
            if (delta <= 0) {
                if (delta <= bestDelta && bestDelta <= 0 && (delta != bestDelta || consumeTime >= bestConsumeTime)) continue;
                bestDelta = delta;
                bestConsumeTime = consumeTime;
                bestStack = new IndexedValue<class_1799>(value.index(), stack);
                continue;
            }
            if (bestDelta <= 0 || delta >= bestDelta && (delta != bestDelta || consumeTime >= bestConsumeTime)) continue;
            bestDelta = delta;
            bestConsumeTime = consumeTime;
            bestStack = new IndexedValue<class_1799>(value.index(), stack);
        }
        return bestStack;
    }

    public boolean isInventoryEmpty(class_1799 stack) {
        return this.getInventory(stack).method_5442();
    }

    public ItemStackInventory getInventory(class_1799 stack) {
        return new ItemStackInventory(stack, INVENTORY_NBT_KEY, this.size);
    }

    public void method_33261(class_1542 entity) {
        ItemStackInventory inventory = this.getInventory(entity.method_6983());
        class_5328.method_33263((class_1542)entity, (Stream)inventory.getContainedStacks().stream());
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        ItemStackInventory inventory = this.getInventory(stack);
        if (inventory.method_5442()) {
            tooltip.add(LORE_EMPTY);
        } else {
            int count = 0;
            int filled = 0;
            for (int i = 0; i < inventory.method_5439(); ++i) {
                class_1799 invStack = inventory.method_5438(i);
                if (invStack.method_7960()) continue;
                count += invStack.method_7947();
                ++filled;
            }
            tooltip.add((class_2561)class_2561.method_43469((String)LORE_GENERAL_KEY, (Object[])new Object[]{filled, this.size, count}).method_10862(LORE_STYLE));
        }
    }

    public boolean method_19263() {
        return true;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stackInHand = user.method_5998(hand);
        class_1799 nextFoodItem = this.getNextFoodStack(stackInHand, user);
        if (nextFoodItem.method_7960()) {
            class_3222 player;
            long currentTime = System.currentTimeMillis();
            if (user instanceof class_3222 && this.checkLastEatTime(player = (class_3222)user, currentTime)) {
                this.updateLastEatTime(player, currentTime);
                this.openScreen(stackInHand, user, hand == class_1268.field_5808 ? user.method_31548().field_7545 : 40);
                return class_1271.method_22427((Object)stackInHand);
            }
        } else if (nextFoodItem.method_19267()) {
            class_4174 foodComponent = nextFoodItem.method_7909().method_19264();
            if (foodComponent != null && user.method_7332(foodComponent.method_19233())) {
                user.method_6019(hand);
                return class_1271.method_22428((Object)stackInHand);
            }
            return class_1271.method_22431((Object)stackInHand);
        }
        return class_1271.method_22430((Object)stackInHand);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (!world.field_9236 && user instanceof class_3222) {
            long currentTime;
            class_3222 player = (class_3222)user;
            int maxUseTime = this.method_7881(stack);
            if (maxUseTime - remainingUseTicks <= 5 && this.checkLastEatTime(player, currentTime = System.currentTimeMillis())) {
                this.updateLastEatTime(player, currentTime);
                class_1661 inv = player.method_31548();
                for (int i = 0; i < inv.method_5439(); ++i) {
                    if (inv.method_5438(i) != stack) continue;
                    this.openScreen(stack, (class_1657)player, i);
                    return;
                }
            }
        }
        super.method_7840(stack, world, user, remainingUseTicks);
    }

    public boolean checkLastEatTime(class_3222 user, long currentTime) {
        long lastEatTime = ((IServerPlayerEntity)user).spiceOfFabric_getLastContainerEatTime();
        return currentTime - lastEatTime >= 1000L;
    }

    public void updateLastEatTime(class_3222 user, long currentTime) {
        ((IServerPlayerEntity)user).spiceOfFabric_setLastContainerEatTime(currentTime);
    }

    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        class_1799 newStack;
        if (!(user instanceof class_1657)) {
            return stack;
        }
        class_1657 player = (class_1657)user;
        ItemStackInventory inventory = this.getInventory(stack);
        IndexedValue<class_1799> foodStack = this.getNextFoodStack(inventory, player);
        if (foodStack.value().method_7960()) {
            return stack;
        }
        if (player instanceof class_3222) {
            ((IServerPlayerEntity)player).spiceOfFabric_setLastContainerEatTime(System.currentTimeMillis());
        }
        if ((newStack = foodStack.value().method_7910(world, user)) != foodStack.value()) {
            if (inventory.method_5437(foodStack.index(), newStack)) {
                inventory.method_5447(foodStack.index(), newStack);
            } else {
                player.method_31548().method_7398(newStack);
                inventory.method_5441(foodStack.index());
            }
        } else {
            inventory.method_5431();
        }
        return stack;
    }

    protected void openScreen(final class_1799 stack, final class_1657 user, final int invIndex) {
        user.method_6021();
        user.method_17355((class_3908)new FoodContainerScreenHandler.Factory(this, stack));
        user.field_7512.method_7596(new class_1712(){

            public void method_7635(class_1703 handler, int updateSlotId, class_1799 updateStack) {
                class_1735 updateSlot = handler.method_7611(updateSlotId);
                if (!(user instanceof class_3222)) {
                    return;
                }
                class_3222 serverPlayer = (class_3222)user;
                if (updateSlot.method_34266() == invIndex && updateSlot.field_7871 == user.method_31548()) {
                    if (updateStack.method_7960() || !class_1799.method_7973((class_1799)updateStack, (class_1799)stack)) {
                        FoodContainerItem.closeScreen(serverPlayer);
                    }
                } else if (class_1799.method_7973((class_1799)updateStack, (class_1799)stack)) {
                    FoodContainerItem.closeScreen(serverPlayer);
                }
            }

            public void method_7633(class_1703 handler, int property, int value) {
            }
        });
    }

    private static void closeScreen(class_3222 player) {
        player.method_7346();
    }

    @Nullable
    public class_1799 getCamoFoodStack(@NotNull class_1799 stack, CamoFoodContext context) {
        class_1309 class_13092 = context.user();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            return this.getNextFoodStack(stack, player);
        }
        return stack;
    }
}

