/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftbranks.api.FTBRanksAPI;
import dev.ftb.mods.ftbranks.api.PermissionValue;
import dev.ftb.mods.ftbranks.api.Rank;
import dev.ftb.mods.ftbranks.api.RankCondition;
import dev.ftb.mods.ftbranks.impl.FTBRanksAPIImpl;
import dev.ftb.mods.ftbranks.impl.condition.DefaultCondition;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2191;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class FTBRanksCommands {
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_RANK = new DynamicCommandExceptionType(object -> class_2561.method_43470((String)("Unknown rank: " + object.toString())));

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext, class_2170.class_5364 selection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ftbranks").requires(source -> source.method_9211() != null && source.method_9211().method_3724() || source.method_9259(2))).then(class_2170.method_9247((String)"reload").executes(context -> FTBRanksCommands.reloadRanks((class_2168)context.getSource())))).then(class_2170.method_9247((String)"refresh_readme").executes(context -> FTBRanksCommands.refreshReadme((class_2168)context.getSource())))).then(class_2170.method_9247((String)"list_all_ranks").executes(context -> FTBRanksCommands.listAllRanks((class_2168)context.getSource())))).then(class_2170.method_9247((String)"create").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"power", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> FTBRanksCommands.createRank((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), IntegerArgumentType.getInteger((CommandContext)context, (String)"power"))))).executes(context -> FTBRanksCommands.createRank((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), 1))))).then(class_2170.method_9247((String)"delete").then(class_2170.method_9244((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> FTBRanksCommands.suggestRanks(builder)).executes(context -> FTBRanksCommands.deleteRank((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"rank")))))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"players", (ArgumentType)class_2191.method_9329()).then(class_2170.method_9244((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> FTBRanksCommands.suggestRanks(builder)).executes(context -> FTBRanksCommands.addRank((class_2168)context.getSource(), class_2191.method_9330((CommandContext)context, (String)"players"), StringArgumentType.getString((CommandContext)context, (String)"rank"))))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"players", (ArgumentType)class_2191.method_9329()).then(class_2170.method_9244((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> FTBRanksCommands.suggestRanks(builder)).executes(context -> FTBRanksCommands.removeRank((class_2168)context.getSource(), class_2191.method_9330((CommandContext)context, (String)"players"), StringArgumentType.getString((CommandContext)context, (String)"rank"))))))).then(class_2170.method_9247((String)"list_ranks_of").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> FTBRanksCommands.listRanksOf((class_2168)context.getSource(), class_2186.method_9315((CommandContext)context, (String)"player")))))).then(class_2170.method_9247((String)"list_players_with").then(class_2170.method_9244((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> FTBRanksCommands.suggestRanks(builder)).executes(context -> FTBRanksCommands.listPlayersWith((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"rank")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"node").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> FTBRanksCommands.suggestRanks(builder)).then(class_2170.method_9244((String)"node", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> FTBRanksCommands.setNode((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"rank"), StringArgumentType.getString((CommandContext)context, (String)"node"), StringArgumentType.getString((CommandContext)context, (String)"value")))))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> FTBRanksCommands.suggestRanks(builder)).then(class_2170.method_9244((String)"node", (ArgumentType)StringArgumentType.word()).executes(context -> FTBRanksCommands.setNode((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"rank"), StringArgumentType.getString((CommandContext)context, (String)"node"), null)))))).then(class_2170.method_9247((String)"list").then(class_2170.method_9244((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> FTBRanksCommands.suggestRanks(builder)).executes(context -> FTBRanksCommands.listNodes((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"rank"))))))).then(class_2170.method_9247((String)"condition").then(class_2170.method_9244((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> FTBRanksCommands.suggestRanks(builder)).then(class_2170.method_9244((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> FTBRanksCommands.setCondition((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"rank"), StringArgumentType.getString((CommandContext)context, (String)"value"))))))).then(class_2170.method_9247((String)"show_rank").then(class_2170.method_9244((String)"rank", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> FTBRanksCommands.suggestRanks(builder)).executes(context -> FTBRanksCommands.showRank((class_2168)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"rank"))))));
    }

    private static CompletableFuture<Suggestions> suggestRanks(SuggestionsBuilder builder) {
        return class_2172.method_9264(FTBRanksAPI.manager().getAllRanks().stream().map(Rank::getId), (SuggestionsBuilder)builder);
    }

    private static String normalizeRankName(String name) {
        return name.toLowerCase().replace("+", "_plus").replaceAll("[^a-z0-9_]", "_").replaceAll("_{2,}", "_");
    }

    private static int reloadRanks(class_2168 source) {
        try {
            FTBRanksAPIImpl.manager.reload();
            source.method_9226(() -> class_2561.method_43470((String)"Ranks reloaded from disk!"), true);
            for (class_3222 p : source.method_9211().method_3760().method_14571()) {
                source.method_9211().method_3760().method_14576(p);
            }
            return 1;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            source.method_9213((class_2561)class_2561.method_43470((String)ex.getLocalizedMessage()));
            return 0;
        }
    }

    private static int refreshReadme(class_2168 source) {
        try {
            FTBRanksAPIImpl.manager.refreshReadme();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        source.method_9226(() -> class_2561.method_43470((String)"README file refreshed!"), false);
        return 1;
    }

    private static int listAllRanks(class_2168 source) {
        source.method_9226(() -> class_2561.method_43470((String)"Ranks:"), false);
        for (Rank rank : FTBRanksAPIImpl.manager.getAllRanks()) {
            source.method_9226(() -> class_2561.method_43470((String)("- " + rank.getName())).method_27692(rank.getCondition().isDefaultCondition() ? class_124.field_1075 : class_124.field_1054), false);
        }
        return 1;
    }

    private static int createRank(class_2168 source, String name, int power) {
        String id = FTBRanksCommands.normalizeRankName(name);
        if (FTBRanksAPIImpl.manager.getRank(id).isPresent()) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Rank '" + name + "' is already taken!")));
            return 0;
        }
        FTBRanksAPIImpl.manager.createRank(id, name, power);
        source.method_9226(() -> class_2561.method_43470((String)("Rank '" + id + "' created!")), false);
        return 1;
    }

    private static int deleteRank(class_2168 source, String rankName) throws CommandSyntaxException {
        Rank rank = FTBRanksCommands.getRank(rankName);
        FTBRanksAPI.manager().deleteRank(rank.getId());
        source.method_9226(() -> class_2561.method_43470((String)("Rank '" + rank.getName() + "' deleted!")), false);
        return 1;
    }

    private static int addRank(class_2168 source, Collection<GameProfile> players, String rankName) throws CommandSyntaxException {
        Rank rank = FTBRanksCommands.getRank(rankName);
        for (GameProfile profile : players) {
            if (!rank.add(profile)) continue;
            source.method_9226(() -> class_2561.method_43470((String)String.format("Player %s added to rank '%s'!", profile.getName(), rank.getName())), false);
        }
        return 1;
    }

    private static int removeRank(class_2168 source, Collection<GameProfile> players, String rankName) throws CommandSyntaxException {
        Rank rank = FTBRanksCommands.getRank(rankName);
        for (GameProfile profile : players) {
            if (!rank.remove(profile)) continue;
            source.method_9226(() -> class_2561.method_43470((String)String.format("Player %s removed from rank '%s'!", profile.getName(), rank.getName())), false);
        }
        return 1;
    }

    private static int listRanksOf(class_2168 source, class_3222 player) {
        source.method_9226(() -> class_2561.method_43470((String)String.format("Ranks added to player '%s':", player.method_7334().getName())), false);
        for (Rank rank : FTBRanksAPIImpl.manager.getAllRanks()) {
            if (!rank.isActive(player)) continue;
            source.method_9226(() -> class_2561.method_43470((String)("- " + rank.getName())).method_27692(rank.getCondition().isDefaultCondition() ? class_124.field_1075 : class_124.field_1054), false);
        }
        return 1;
    }

    private static int listPlayersWith(class_2168 source, String rankName) throws CommandSyntaxException {
        Rank rank = FTBRanksCommands.getRank(rankName);
        source.method_9226(() -> class_2561.method_43470((String)String.format("Players with rank '%s':", rank.getName())), false);
        for (class_3222 player : source.method_9211().method_3760().method_14571()) {
            if (!rank.isActive(player)) continue;
            source.method_9226(() -> class_2561.method_43470((String)"- ").method_27692(class_124.field_1054).method_10852(player.method_5476()), false);
        }
        return 1;
    }

    private static int listNodes(class_2168 source, String rankName) throws CommandSyntaxException {
        Rank rank = FTBRanksCommands.getRank(rankName);
        Collection<String> nodes = rank.getPermissions();
        if (nodes.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)String.format("No permission nodes in rank '%s'", rankName)).method_27692(class_124.field_1065), false);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)String.format("%d permission node(s) in rank '%s':", nodes.size(), rankName)).method_27692(class_124.field_1060), false);
            source.method_9226(() -> class_2561.method_43470((String)"-".repeat(20)).method_27692(class_124.field_1060), false);
            nodes.forEach(node -> source.method_9226(() -> class_2561.method_43470((String)String.format("%s = %s", node, rank.getPermission((String)node))).method_27692(class_124.field_1054), false));
            source.method_9226(() -> class_2561.method_43470((String)"-".repeat(20)).method_27692(class_124.field_1060), false);
        }
        return 1;
    }

    private static int setNode(class_2168 source, String rankName, String node, String value) throws CommandSyntaxException {
        Rank rank = FTBRanksCommands.getRank(rankName);
        try {
            rank.setPermission(node, PermissionValue.parse(value));
            if (value != null) {
                source.method_9226(() -> class_2561.method_43470((String)String.format("Permission node '%s'='%s' added to rank '%s'", node, rank.getPermission(node), rank)), false);
            } else {
                source.method_9226(() -> class_2561.method_43470((String)String.format("Permission node '%s' removed from rank '%s'", node, rank)), false);
            }
        }
        catch (IllegalArgumentException e) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)e.getMessage())).create();
        }
        return 1;
    }

    private static int setCondition(class_2168 source, String rankName, String value) throws CommandSyntaxException {
        Rank rank = FTBRanksCommands.getRank(rankName);
        try {
            RankCondition condition = value.equals("default") || value.equals("\"\"") ? new DefaultCondition(rank) : (value.startsWith("{") || value.contains(" ") ? FTBRanksAPI.manager().createCondition(rank, (class_2520)SNBT.readLines(Collections.singletonList(value))) : FTBRanksAPI.manager().createCondition(rank, (class_2520)class_2519.method_23256((String)value)));
            rank.setCondition(condition);
            source.method_9226(() -> class_2561.method_43470((String)String.format("Condition '%s' added to rank '%s'", value, rank)), false);
        }
        catch (Exception e) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)e.getMessage())).create();
        }
        return 1;
    }

    private static int showRank(class_2168 source, String rankName) throws CommandSyntaxException {
        Rank rank = FTBRanksCommands.getRank(rankName);
        source.method_9226(() -> class_2561.method_43470((String)"=".repeat(50)).method_27692(class_124.field_1060), false);
        source.method_9226(() -> class_2561.method_43470((String)"Rank ID: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)rank.getId()).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)", Rank Name: ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)rank.getName()).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)", Power: ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(rank.getPower())).method_27692(class_124.field_1068)), true);
        String condStr = rank.getCondition().asString();
        class_5250 c = condStr.isEmpty() ? class_2561.method_43470((String)"(none: players must be added)").method_27695(new class_124[]{class_124.field_1068, class_124.field_1056}) : class_2561.method_43470((String)condStr).method_27692(class_124.field_1068);
        source.method_9226(() -> FTBRanksCommands.lambda$showRank$49((class_2561)c), false);
        source.method_9226(() -> class_2561.method_43470((String)"Permission nodes:").method_27692(class_124.field_1054), false);
        rank.getPermissions().stream().sorted().forEach(node -> source.method_9226(() -> class_2561.method_43470((String)(" - " + node + ": " + String.valueOf(rank.getPermission((String)node)))), false));
        return 0;
    }

    private static Rank getRank(String rankName) throws CommandSyntaxException {
        return FTBRanksAPI.manager().getRank(rankName).orElseThrow(() -> ERROR_UNKNOWN_RANK.create((Object)rankName));
    }

    private static /* synthetic */ class_2561 lambda$showRank$49(class_2561 c) {
        return class_2561.method_43470((String)"Condition: ").method_10852(c).method_27692(class_124.field_1054);
    }
}

