/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.stats;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.stats.BaseMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.stats.LimbMaterialStats;

public class GripMaterialStats
extends BaseMaterialStats {
    public static final MaterialStatsId ID = new MaterialStatsId(TConstruct.getResource("grip"));
    public static final GripMaterialStats DEFAULT = new GripMaterialStats(1.0f, 0.0f, 0.0f);
    private static final String DURABILITY_PREFIX = GripMaterialStats.makeTooltipKey(TConstruct.getResource("durability"));
    private static final List<class_2561> DESCRIPTION = ImmutableList.of((Object)GripMaterialStats.makeTooltip(TConstruct.getResource("handle.durability.description")), (Object)ToolStats.ACCURACY.getDescription(), (Object)ToolStats.ATTACK_DAMAGE.getDescription());
    private final float durability;
    private final float accuracy;
    private final float meleeAttack;

    public GripMaterialStats(class_2540 buffer) {
        this.durability = buffer.readFloat();
        this.accuracy = buffer.readFloat();
        this.meleeAttack = buffer.readFloat();
    }

    @Override
    public void encode(class_2540 buffer) {
        buffer.writeFloat(this.durability);
        buffer.writeFloat(this.accuracy);
        buffer.writeFloat(this.meleeAttack);
    }

    @Override
    public MaterialStatsId getIdentifier() {
        return ID;
    }

    @Override
    public List<class_2561> getLocalizedInfo() {
        ArrayList info = Lists.newArrayList();
        info.add(IToolStat.formatColoredMultiplier(DURABILITY_PREFIX, this.durability));
        info.add(IToolStat.formatColoredBonus(LimbMaterialStats.ACCURACY_PREFIX, this.accuracy, 0.5f));
        info.add(ToolStats.ATTACK_DAMAGE.formatValue(this.meleeAttack));
        return info;
    }

    @Override
    public List<class_2561> getLocalizedDescriptions() {
        return DESCRIPTION;
    }

    public GripMaterialStats(float durability, float accuracy, float meleeAttack) {
        this.durability = durability;
        this.accuracy = accuracy;
        this.meleeAttack = meleeAttack;
    }

    public float getDurability() {
        return this.durability;
    }

    public float getAccuracy() {
        return this.accuracy;
    }

    public float getMeleeAttack() {
        return this.meleeAttack;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GripMaterialStats)) {
            return false;
        }
        GripMaterialStats other = (GripMaterialStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getDurability(), other.getDurability()) != 0) {
            return false;
        }
        if (Float.compare(this.getAccuracy(), other.getAccuracy()) != 0) {
            return false;
        }
        return Float.compare(this.getMeleeAttack(), other.getMeleeAttack()) == 0;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof GripMaterialStats;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getDurability());
        result = result * 59 + Float.floatToIntBits(this.getAccuracy());
        result = result * 59 + Float.floatToIntBits(this.getMeleeAttack());
        return result;
    }

    public String toString() {
        return "GripMaterialStats(durability=" + this.getDurability() + ", accuracy=" + this.getAccuracy() + ", meleeAttack=" + this.getMeleeAttack() + ")";
    }

    public GripMaterialStats withDurability(float durability) {
        return this.durability == durability ? this : new GripMaterialStats(durability, this.accuracy, this.meleeAttack);
    }

    public GripMaterialStats withAccuracy(float accuracy) {
        return this.accuracy == accuracy ? this : new GripMaterialStats(this.durability, accuracy, this.meleeAttack);
    }

    public GripMaterialStats withMeleeAttack(float meleeAttack) {
        return this.meleeAttack == meleeAttack ? this : new GripMaterialStats(this.durability, this.accuracy, meleeAttack);
    }
}

