/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5134;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.data.ModifierMaxLevel;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.tools.modifiers.defense.AbstractProtectionModifier;

public class MeleeProtectionModifier
extends AbstractProtectionModifier<ModifierMaxLevel> {
    private static final UUID SPEED_UUID = UUID.fromString("6f030b1e-e9e1-11ec-8fea-0242ac120002");
    private static final TinkerDataCapability.TinkerDataKey<ModifierMaxLevel> KEY = TConstruct.createKey("melee_protection");

    public MeleeProtectionModifier() {
        super(KEY);
    }

    private static boolean doesApply(class_1282 source) {
        if (source.method_48789(class_8103.field_42243) || source.method_48789(class_8103.field_42247) || source.method_48789(class_8103.field_42242)) {
            return false;
        }
        if (source.method_5529() != null) {
            return !source.method_49708(class_8111.field_42330);
        }
        return !source.method_48789(class_8103.field_42241) && !source.method_48789(class_8103.field_42246) && !source.method_49708(class_8111.field_42349) && !source.method_48789(class_8103.field_42249);
    }

    @Override
    protected void set(ModifierMaxLevel data, class_1304 slot, float scaledLevel, EquipmentChangeContext context) {
        class_1324 instance;
        float oldMax = data.getMax();
        super.set(data, slot, scaledLevel, context);
        float newMax = data.getMax();
        if (oldMax != newMax && (instance = context.getEntity().method_5996(class_5134.field_23723)) != null) {
            instance.method_6200(SPEED_UUID);
            if (newMax != 0.0f) {
                instance.method_26835(new class_1322(SPEED_UUID, "tconstruct.melee_protection", 0.03 * (double)newMax, class_1322.class_1323.field_6330));
            }
        }
    }

    @Override
    protected void reset(ModifierMaxLevel data, EquipmentChangeContext context) {
        super.reset(data, context);
        class_1324 instance = context.getEntity().method_5996(class_5134.field_23723);
        if (instance != null) {
            instance.method_6200(SPEED_UUID);
        }
    }

    @Override
    public float getProtectionModifier(IToolStackView tool, int level, EquipmentContext context, class_1304 slotType, class_1282 source, float modifierValue) {
        if (MeleeProtectionModifier.doesApply(source)) {
            modifierValue = (float)((double)modifierValue + (double)this.getScaledLevel(tool, level) * 2.5);
        }
        return modifierValue;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable class_1657 player, List<class_2561> tooltip, TooltipKey tooltipKey, class_1836 tooltipFlag) {
        AbstractProtectionModifier.addResistanceTooltip(this, tool, level, 2.5f, tooltip);
    }

    @Override
    protected ModifierMaxLevel createData() {
        return new ModifierMaxLevel();
    }
}

