/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.tool;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3956;
import net.minecraft.class_47;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.modifiers.impl.TankModifier;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipe;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipeCache;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.smeltery.block.entity.module.EntityMeltingModule;

public class MeltingModifier
extends TankModifier {
    private static final int MAX_TEMPERATURE = 1000;
    private static IMeltingRecipe lastRecipe = null;
    private static final MeltingContainer inventory = new MeltingContainer();

    public MeltingModifier() {
        super(81000L);
    }

    @Override
    public class_2561 getDisplayName(int level) {
        return super.getDisplayName();
    }

    private static FluidStack meltItem(class_1799 stack, class_1937 world) {
        inventory.setStack(stack);
        IMeltingRecipe recipe = lastRecipe;
        if (recipe == null || !recipe.method_8115((class_1263)inventory, world)) {
            recipe = world.method_8433().method_8132((class_3956)TinkerRecipeTypes.MELTING.get(), (class_1263)inventory, world).orElse(null);
            if (recipe == null) {
                inventory.setStack(class_1799.field_8037);
                return FluidStack.EMPTY;
            }
            lastRecipe = recipe;
        }
        FluidStack result = FluidStack.EMPTY;
        if (recipe.getTemperature(inventory) <= 1000) {
            result = recipe.getOutput(inventory);
        }
        inventory.setStack(class_1799.field_8037);
        return result;
    }

    @Override
    public ObjectArrayList<class_1799> processLoot(IToolStackView tool, int level, ObjectArrayList<class_1799> generatedLoot, class_47 context) {
        FluidStack current = this.getFluid(tool);
        int capacity = this.getCapacity(tool);
        if (current.getAmount() >= (long)capacity) {
            return generatedLoot;
        }
        class_3218 world = context.method_299();
        ObjectListIterator iterator = generatedLoot.iterator();
        while (iterator.hasNext()) {
            FluidStack filled;
            long maxCopies;
            class_1799 stack = (class_1799)iterator.next();
            FluidStack output = MeltingModifier.meltItem(stack, (class_1937)world);
            if (output.isEmpty() || !current.isEmpty() && !current.isFluidEqual(output) || (maxCopies = Math.min(((long)capacity - current.getAmount()) / output.getAmount(), (long)stack.method_7947())) <= 0L || (filled = this.fill(tool, current, output, output.getAmount() * maxCopies)).isEmpty()) continue;
            current = filled;
            stack.method_7934((int)maxCopies);
            if (!stack.method_7960()) continue;
            iterator.remove();
        }
        return generatedLoot;
    }

    @Override
    public int afterEntityHit(IToolStackView tool, int level, ToolAttackContext context, float damageDealt) {
        class_1309 target;
        if (damageDealt > 0.0f && context.isFullyCharged() && (target = context.getLivingTarget()) != null) {
            int damagePerOutput;
            FluidStack output;
            EntityMeltingRecipe recipe = EntityMeltingRecipeCache.findRecipe(context.getAttacker().method_37908().method_8433(), target.method_5864());
            if (recipe != null) {
                output = recipe.getOutput(target);
                damagePerOutput = recipe.getDamage();
            } else {
                output = EntityMeltingModule.getDefaultFluid();
                damagePerOutput = 2;
            }
            long fluidAmount = damageDealt < (float)(damagePerOutput * 2) ? (long)((int)((float)output.getAmount() * damageDealt / (float)damagePerOutput)) : output.getAmount() * 2L;
            this.fill(tool, this.getFluid(tool), output, fluidAmount);
        }
        return 0;
    }

    private static class MeltingContainer
    implements IMeltingContainer {
        private class_1799 stack;

        private MeltingContainer() {
        }

        @Override
        public IMeltingContainer.IOreRate getOreRate() {
            return Config.COMMON.melterOreRate;
        }

        public class_1799 getStack() {
            return this.stack;
        }

        public void setStack(class_1799 stack) {
            this.stack = stack;
        }
    }
}

