/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.logic;

import com.google.common.collect.Multiset;
import io.github.fabricators_of_create.porting_lib.core.event.BaseEvent;
import io.github.fabricators_of_create.porting_lib.entity.events.EntityEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingEntityEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.PlayerEvents;
import io.github.fabricators_of_create.porting_lib.entity.events.ProjectileImpactEvent;
import io.github.fabricators_of_create.porting_lib.event.common.GrindstoneEvents;
import io.github.fabricators_of_create.porting_lib.util.EntityHelper;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2276;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3922;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4481;
import net.minecraft.class_4482;
import net.minecraft.class_5134;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.data.ModifierMaxLevel;
import slimeknights.tconstruct.library.modifiers.dynamic.MobDisguiseModifier;
import slimeknights.tconstruct.library.tools.capability.EntityModifierCapability;
import slimeknights.tconstruct.library.tools.capability.PersistentDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.helper.ArmorUtil;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.utils.BlockSideHitListener;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.defense.ProjectileProtectionModifier;
import slimeknights.tconstruct.tools.modifiers.upgrades.armor.HasteModifier;

public class ToolEvents {
    public static void init() {
        PlayerEvents.BREAK_SPEED.register(ToolEvents::onBreakSpeed);
        TinkerToolEvent.ToolHarvestEvent.EVENT.register(ToolEvents::onHarvest);
        LivingEntityEvents.HURT.register(ToolEvents::enderDragonDamage);
        LivingEntityEvents.HURT.register(ToolEvents::livingAttack);
        LivingEntityEvents.HURT.register(ToolEvents::livingHurt);
        LivingEntityEvents.TICK.register(ToolEvents::livingWalk);
        LivingEntityEvents.LivingVisibilityEvent.VISIBILITY.register(ToolEvents::livingVisibility);
        EntityEvents.PROJECTILE_IMPACT.register(ToolEvents::projectileHit);
        GrindstoneEvents.ON_PLACE_ITEM.register(ToolEvents::onGrindstoneChange);
    }

    static void onBreakSpeed(PlayerEvents.BreakSpeed event) {
        float armorHaste;
        List<ModifierEntry> modifiers;
        ToolStack tool;
        class_1799 stack;
        class_1657 player = event.getPlayer();
        if (player.method_5777(class_3486.field_15517) && ModifierUtil.getTotalModifierLevel((class_1309)player, TinkerDataKeys.AQUA_AFFINITY) > 0 && !class_1890.method_8200((class_1309)player)) {
            event.setNewSpeed(event.getNewSpeed() * 5.0f);
        }
        if ((stack = player.method_6047()).method_31573(TinkerTags.Items.HARVEST) && !(tool = ToolStack.from(stack)).isBroken() && !(modifiers = tool.getModifierList()).isEmpty()) {
            float miningSpeedModifier = Modifier.getMiningModifier((class_1309)player);
            boolean isEffective = stack.method_7951(event.getState());
            class_2350 direction = BlockSideHitListener.getSideHit(player);
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getHook(TinkerHooks.BREAK_SPEED).onBreakSpeed(tool, entry, event, direction, isEffective, miningSpeedModifier);
                if (!event.isCanceled()) continue;
                return;
            }
        }
        if ((armorHaste = ModifierUtil.getTotalModifierFloat((class_1309)player, HasteModifier.HASTE)) > 0.0f) {
            event.setNewSpeed(event.getNewSpeed() * (1.0f + 0.1f * armorHaste));
        }
    }

    static void onHarvest(TinkerToolEvent.ToolHarvestEvent event) {
        if (event.getResult() != BaseEvent.Result.DEFAULT) {
            return;
        }
        class_2680 state = event.getState();
        class_2248 block = state.method_26204();
        class_3218 world = event.getWorld();
        class_2338 pos = event.getPos();
        if (block == class_2246.field_10261) {
            class_2350 facing = event.getContext().method_8038();
            if (facing.method_10166() == class_2350.class_2351.field_11052) {
                facing = event.getContext().method_8042().method_10153();
            }
            world.method_8396(null, pos, class_3417.field_14619, class_3419.field_15245, 1.0f, 1.0f);
            world.method_8652(pos, (class_2680)class_2246.field_10147.method_9564().method_11657((class_2769)class_2276.field_10748, (Comparable)facing), 11);
            class_1542 itemEntity = new class_1542((class_1937)world, (double)pos.method_10263() + 0.5 + (double)facing.method_10148() * 0.65, (double)pos.method_10264() + 0.1, (double)pos.method_10260() + 0.5 + (double)facing.method_10165() * 0.65, new class_1799((class_1935)class_1802.field_8706, 4));
            itemEntity.method_18800(0.05 * (double)facing.method_10148() + world.field_9229.method_43058() * 0.02, 0.05, 0.05 * (double)facing.method_10165() + world.field_9229.method_43058() * 0.02);
            world.method_8649((class_1297)itemEntity);
            event.setResult(BaseEvent.Result.ALLOW);
        }
        if (block instanceof class_4481) {
            class_4481 beehive = (class_4481)block;
            int level = (Integer)state.method_11654((class_2769)class_4481.field_20420);
            if (level >= 5) {
                world.method_8396(null, pos, class_3417.field_20611, class_3419.field_15254, 1.0f, 1.0f);
                class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)class_1802.field_20414, 3));
                if (!class_3922.method_23895((class_1937)world, (class_2338)pos)) {
                    if (beehive.method_23894((class_1937)world, pos)) {
                        beehive.method_23893((class_1937)world, pos);
                    }
                    beehive.method_21841((class_1937)world, state, pos, event.getPlayer(), class_4482.class_4484.field_21052);
                } else {
                    beehive.method_23754((class_1937)world, state, pos);
                }
                event.setResult(BaseEvent.Result.ALLOW);
            } else {
                event.setResult(BaseEvent.Result.DENY);
            }
        }
    }

    static float enderDragonDamage(class_1282 source, class_1309 entity, float amount) {
        if (!((Boolean)Config.COMMON.dropDragonScales.get()).booleanValue()) {
            return amount;
        }
        if (entity.method_5864() == class_1299.field_6116 && amount > 0.0f && !entity.method_37908().field_9236 && source.method_49708(class_8111.field_42332) && source.method_5529() != null && source.method_5529().method_5864() == class_1299.field_6097) {
            ModifierUtil.dropItem((class_1297)entity, new class_1799(TinkerModifiers.dragonScale, 1 + entity.method_37908().field_9229.method_43048(8)));
        }
        return amount;
    }

    static float livingAttack(class_1282 source, class_1309 entity, float amount) {
        class_1309 livingAttacker;
        class_1297 attacker;
        if (entity.method_37908().method_8608() || entity.method_29504()) {
            return amount;
        }
        if (entity.method_5679(source)) {
            return amount;
        }
        boolean isDirectDamage = source.method_5529() != null && !source.method_49708(class_8111.field_42330);
        EquipmentContext context = new EquipmentContext(entity);
        if (context.hasModifiableArmor()) {
            class_1304 slot;
            IToolStackView shield;
            IToolStackView toolStack;
            for (class_1304 slotType : class_1304.values()) {
                if (!ModifierUtil.validArmorSlot(entity, slotType) || (toolStack = context.getToolInSlot(slotType)) == null || toolStack.isBroken()) continue;
                for (ModifierEntry entry : toolStack.getModifierList()) {
                    if (!entry.getHook(TinkerHooks.DAMAGE_BLOCK).isDamageBlocked(toolStack, entry, context, slotType, source, amount)) continue;
                    return 0.0f;
                }
            }
            for (class_1304 slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
                toolStack = context.getToolInSlot(slotType);
                if (toolStack == null || toolStack.isBroken()) continue;
                for (ModifierEntry entry : toolStack.getModifierList()) {
                    entry.getHook(TinkerHooks.DAMAGE_TAKEN).onDamageTaken(toolStack, entry, context, slotType, source, amount, isDirectDamage);
                }
            }
            if (entity.method_6039() && (shield = context.getToolInSlot(slot = Util.getSlotType(entity.method_6058()))) != null && !shield.isBroken()) {
                for (ModifierEntry entry : shield.getModifierList()) {
                    entry.getHook(TinkerHooks.DAMAGE_TAKEN).onDamageTaken(shield, entry, context, slot, source, amount, isDirectDamage);
                }
            }
        }
        if ((attacker = source.method_5529()) instanceof class_1309 && (context = new EquipmentContext(livingAttacker = (class_1309)attacker)).hasModifiableArmor()) {
            for (class_1304 slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
                IToolStackView toolStack = context.getToolInSlot(slotType);
                if (toolStack == null || toolStack.isBroken()) continue;
                for (ModifierEntry entry : toolStack.getModifierList()) {
                    entry.getHook(TinkerHooks.DAMAGE_DEALT).onDamageDealt(toolStack, entry, context, slotType, entity, source, amount, isDirectDamage);
                }
            }
        }
        return amount;
    }

    private static int getArmorDamage(float damage) {
        if ((damage /= 4.0f) < 1.0f) {
            return 1;
        }
        return (int)damage;
    }

    static float livingHurt(class_1282 source, class_1309 entity, float originalDamage) {
        EquipmentContext context = new EquipmentContext(entity);
        int vanillaModifier = 0;
        float modifierValue = 0.0f;
        if (context.hasModifiableArmor()) {
            if (!source.method_48789(class_8103.field_42243)) {
                vanillaModifier = class_1890.method_8219((Iterable)entity.method_5661(), (class_1282)source);
                modifierValue = vanillaModifier;
            }
            for (class_1304 slotType : class_1304.values()) {
                IToolStackView tool;
                if (!ModifierUtil.validArmorSlot(entity, slotType) || (tool = context.getToolInSlot(slotType)) == null || tool.isBroken()) continue;
                for (ModifierEntry entry : tool.getModifierList()) {
                    modifierValue = entry.getHook(TinkerHooks.PROTECTION).getProtectionModifier(tool, entry, context, slotType, source, modifierValue);
                }
            }
            if (entity.method_5864().method_20210(TinkerTags.EntityTypes.SMALL_ARMOR)) {
                modifierValue *= 4.0f;
            }
        } else if (!source.method_48789(class_8103.field_42243) && entity.method_5864().method_20210(TinkerTags.EntityTypes.SMALL_ARMOR)) {
            vanillaModifier = class_1890.method_8219((Iterable)entity.method_5661(), (class_1282)source);
            modifierValue = vanillaModifier * 4;
        }
        float cap = 20.0f;
        if (modifierValue > 0.0f) {
            cap = Math.min(20.0f + context.getTinkerData().resolve().map(data -> data.get(TinkerDataKeys.PROTECTION_CAP)).orElse(Float.valueOf(0.0f)).floatValue(), 23.75f);
        }
        if ((float)vanillaModifier != modifierValue || cap > 20.0f && vanillaModifier > 20 || cap < 20.0f && (float)vanillaModifier > cap) {
            int damageMissed;
            float armor = 0.0f;
            float toughness = 0.0f;
            if (!source.method_48789(class_8103.field_42241)) {
                armor = entity.method_6096();
                toughness = (float)entity.method_26825(class_5134.field_23725);
            }
            float finalDamage = ArmorUtil.getDamageForEvent(originalDamage, armor, toughness, vanillaModifier, modifierValue, cap);
            if (!source.method_48789(class_8103.field_42241) && (damageMissed = ToolEvents.getArmorDamage(originalDamage) - ToolEvents.getArmorDamage(finalDamage)) > 0 && entity instanceof class_1657) {
                for (class_1304 slotType : ModifiableArmorMaterial.ARMOR_SLOTS) {
                    IToolStackView tool = context.getToolInSlot(slotType);
                    if (!(tool == null || source.method_48789(class_8103.field_42246) && tool.getItem().method_24358())) {
                        ToolDamageUtil.damageAnimated(tool, damageMissed, entity, slotType);
                        continue;
                    }
                    class_1799 armorStack = entity.method_6118(slotType);
                    if (armorStack.method_7960() || source.method_48789(class_8103.field_42246) && armorStack.method_7909().method_24358() || !(armorStack.method_7909() instanceof class_1738)) continue;
                    armorStack.method_7956(damageMissed, entity, e -> e.method_20235(slotType));
                }
            }
            return finalDamage;
        }
        return originalDamage;
    }

    static void livingWalk(class_1309 living) {
        class_1799 boots;
        class_2338 pos = living.method_24515();
        class_2338 lastPos = EntityHelper.getLastPos((class_1309)living);
        if (!living.method_7325() && !living.method_37908().method_8608() && living.method_5805() && !Objects.equals(lastPos, pos) && !(boots = living.method_6118(class_1304.field_6166)).method_7960() && boots.method_31573(TinkerTags.Items.BOOTS)) {
            ToolStack tool = ToolStack.from(boots);
            for (ModifierEntry entry : tool.getModifierList()) {
                entry.getHook(TinkerHooks.BOOT_WALK).onWalk(tool, entry, living, lastPos, pos);
            }
        }
    }

    static void livingVisibility(LivingEntityEvents.LivingVisibilityEvent event) {
        class_1297 lookingEntity = event.getLookingEntity();
        if (lookingEntity == null) {
            return;
        }
        class_1309 living = event.getEntity();
        TinkerDataCapability.CAPABILITY.maybeGet((Object)living).ifPresent(data -> {
            float max;
            ModifierMaxLevel projData;
            Multiset<class_1299<?>> disguises = data.get(MobDisguiseModifier.DISGUISES);
            if (disguises != null && disguises.contains((Object)lookingEntity.method_5864())) {
                event.modifyVisibility((double)0.65f);
            }
            if ((projData = data.get(ProjectileProtectionModifier.PROJECTILE_DATA)) != null && (max = projData.getMax()) > 0.0f) {
                event.modifyVisibility(Math.max(0.0, 1.0 - (double)max * 0.05));
            }
        });
    }

    static void projectileHit(ProjectileImpactEvent event) {
        class_1676 projectile = event.getProjectile();
        ModifierNBT modifiers = EntityModifierCapability.getOrEmpty((class_1297)projectile);
        if (!modifiers.isEmpty()) {
            class_1309 l;
            NamespacedNBT nbt = PersistentDataCapability.getOrWarn((class_1297)projectile);
            class_239 hit = event.getRayTraceResult();
            class_239.class_240 type = hit.method_17783();
            class_1297 class_12972 = projectile.method_24921();
            class_1309 attacker = class_12972 instanceof class_1309 ? (l = (class_1309)class_12972) : null;
            switch (type) {
                case field_1331: {
                    class_3966 entityHit = (class_3966)hit;
                    if (entityHit.method_17782().method_5864() == class_1299.field_6091 && modifiers.getLevel(TinkerModifiers.enderference.getId()) <= 0) break;
                    class_1309 target = ToolAttackUtil.getLivingEntity(entityHit.method_17782());
                    for (ModifierEntry entry : modifiers.getModifiers()) {
                        if (!entry.getHook(TinkerHooks.PROJECTILE_HIT).onProjectileHitEntity(modifiers, nbt, entry, projectile, entityHit, attacker, target)) continue;
                        event.setCanceled(true);
                    }
                    break;
                }
                case field_1332: {
                    class_3965 blockHit = (class_3965)hit;
                    for (ModifierEntry entry : modifiers.getModifiers()) {
                        if (!entry.getHook(TinkerHooks.PROJECTILE_HIT).onProjectileHitBlock(modifiers, nbt, entry, projectile, blockHit, attacker)) continue;
                        event.setCanceled(true);
                    }
                    break;
                }
            }
        }
    }

    static void onGrindstoneChange(GrindstoneEvents.OnplaceItem event) {
        if (event.getTopItem().method_31573(TinkerTags.Items.MODIFIABLE) || event.getBottomItem().method_31573(TinkerTags.Items.MODIFIABLE)) {
            event.setCanceled(true);
        }
    }
}

