/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.block.entity.table;

import io.github.fabricators_of_create.porting_lib.event.common.ItemCraftedCallback;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemHandlerHelper;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3956;
import org.apache.commons.lang3.StringUtils;
import slimeknights.mantle.network.packet.ISimplePacket;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.SoundUtils;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.helper.TooltipUtil;
import slimeknights.tconstruct.shared.inventory.ConfigurableInvWrapperCapability;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.block.TinkerStationBlock;
import slimeknights.tconstruct.tables.block.entity.inventory.LazyResultContainer;
import slimeknights.tconstruct.tables.block.entity.inventory.TinkerStationContainerWrapper;
import slimeknights.tconstruct.tables.block.entity.table.RetexturedTableBlockEntity;
import slimeknights.tconstruct.tables.menu.TinkerStationContainerMenu;
import slimeknights.tconstruct.tables.network.UpdateTinkerStationRecipePacket;

public class TinkerStationBlockEntity
extends RetexturedTableBlockEntity
implements LazyResultContainer.ILazyCrafter {
    public static final int TINKER_SLOT = 0;
    public static final int INPUT_SLOT = 1;
    private static final class_2561 NAME = TConstruct.makeTranslation("gui", "tinker_station");
    @Nullable
    private ITinkerStationRecipe lastRecipe;
    private final LazyResultContainer craftingResult;
    private final TinkerStationContainerWrapper inventoryWrapper;
    private ValidatedResult currentError;
    private String itemName;

    public TinkerStationBlockEntity(class_2338 pos, class_2680 state) {
        int n;
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof TinkerStationBlock) {
            TinkerStationBlock station = (TinkerStationBlock)class_22482;
            n = station.getSlotCount();
        } else {
            n = 6;
        }
        this(pos, state, n);
    }

    public TinkerStationBlockEntity(class_2338 pos, class_2680 state, int slots) {
        super((class_2591)TinkerTables.tinkerStationTile.get(), pos, state, NAME, slots);
        this.currentError = ValidatedResult.PASS;
        this.itemName = "";
        this.itemHandler = new ConfigurableInvWrapperCapability((class_1263)this, false, false);
        this.inventoryWrapper = new TinkerStationContainerWrapper(this);
        this.craftingResult = new LazyResultContainer(this);
    }

    public class_2561 getDefaultName() {
        if (this.field_11863 == null) {
            return super.getDefaultName();
        }
        return class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }

    public int getInputCount() {
        return this.method_5439() - 1;
    }

    public void resize(int size) {
        super.resize(size);
        this.inventoryWrapper.resize();
    }

    @Nullable
    public class_1703 createMenu(int menuId, class_1661 playerInventory, class_1657 playerEntity) {
        return new TinkerStationContainerMenu(menuId, playerInventory, this);
    }

    @Override
    public class_1799 calcResult(@Nullable class_1657 player) {
        if (this.field_11863 == null) {
            return class_1799.field_8037;
        }
        class_1799 result = class_1799.field_8037;
        this.currentError = ValidatedResult.PASS;
        if (!this.field_11863.field_9236 && this.field_11863.method_8503() != null) {
            class_1863 manager = this.field_11863.method_8503().method_3772();
            ITinkerStationRecipe recipe = this.lastRecipe;
            if (recipe == null || !recipe.matches(this.inventoryWrapper, this.field_11863)) {
                recipe = manager.method_8132((class_3956)TinkerRecipeTypes.TINKER_STATION.get(), (class_1263)this.inventoryWrapper, this.field_11863).orElse(null);
            }
            boolean needsSync = true;
            if (recipe != null) {
                ValidatedResult validatedResult;
                if (this.lastRecipe != recipe) {
                    this.lastRecipe = recipe;
                    this.syncToRelevantPlayers(this::syncRecipe);
                    needsSync = false;
                }
                if ((validatedResult = recipe.getValidatedResult(this.inventoryWrapper, this.field_11863.method_30349())).isSuccess()) {
                    result = validatedResult.getResult();
                } else if (validatedResult.hasError()) {
                    this.currentError = validatedResult;
                }
            }
            if (needsSync) {
                this.syncToRelevantPlayers(x$0 -> this.syncScreen((class_1657)x$0));
            }
        } else if (this.lastRecipe != null && this.lastRecipe.matches(this.inventoryWrapper, this.field_11863)) {
            ValidatedResult validatedResult = this.lastRecipe.getValidatedResult(this.inventoryWrapper, this.field_11863.method_30349());
            if (validatedResult.isSuccess()) {
                result = validatedResult.getResult();
            } else if (validatedResult.hasError()) {
                this.currentError = validatedResult;
            }
        }
        if (!result.method_7960() && !this.itemName.isEmpty()) {
            TooltipUtil.setDisplayName(result, this.itemName);
        }
        return result;
    }

    @Override
    public void onCraft(class_1657 player, class_1799 result, int amount) {
        if (amount == 0 || this.lastRecipe == null || this.field_11863 == null) {
            return;
        }
        result.method_7982(this.field_11863, player, amount);
        ((ItemCraftedCallback)ItemCraftedCallback.EVENT.invoker()).onCraft(player, result, (class_1263)this.inventoryWrapper);
        this.playCraftSound(player);
        this.inventoryWrapper.setPlayer(player);
        this.lastRecipe.updateInputs(result, this.inventoryWrapper, !this.field_11863.field_9236);
        this.inventoryWrapper.setPlayer(null);
        class_1799 tinkerable = this.method_5438(0);
        if (!tinkerable.method_7960()) {
            int shrinkToolSlot = this.lastRecipe.shrinkToolSlotBy();
            if (tinkerable.method_7947() <= shrinkToolSlot) {
                this.method_5447(0, class_1799.field_8037);
            } else {
                this.method_5447(0, ItemHandlerHelper.copyStackWithSize((class_1799)tinkerable, (int)(tinkerable.method_7947() - shrinkToolSlot)));
            }
        }
        this.itemName = "";
    }

    @Override
    public void method_5447(int slot, class_1799 itemstack) {
        super.method_5447(slot, itemstack);
        this.craftingResult.method_5448();
        this.inventoryWrapper.refreshInput(slot);
    }

    @Override
    protected void playCraftSound(class_1657 player) {
        SoundUtils.playSoundForAll((class_1297)player, this.getInputCount() > 4 ? class_3417.field_14559 : Sounds.SAW.getSound(), 0.8f, 0.8f + 0.4f * player.method_37908().field_9229.method_43057());
    }

    public void setItemName(String name) {
        this.itemName = name;
        class_1799 result = this.craftingResult.getResult();
        if (!result.method_7960()) {
            if (StringUtils.isBlank((CharSequence)name)) {
                class_1799 input = this.method_5438(0);
                name = !input.method_7960() ? TooltipUtil.getDisplayName(input) : "";
            }
            TooltipUtil.setDisplayName(result, name);
        }
    }

    public void syncRecipe(class_1657 player) {
        if (this.lastRecipe != null && this.field_11863 != null && !this.field_11863.field_9236 && player instanceof class_3222) {
            class_3222 server = (class_3222)player;
            TinkerNetwork.getInstance().sendTo((ISimplePacket)new UpdateTinkerStationRecipePacket(this.field_11867, this.lastRecipe), server);
        }
    }

    public void updateRecipe(ITinkerStationRecipe recipe) {
        this.lastRecipe = recipe;
        this.craftingResult.method_5448();
    }

    @Nullable
    public ITinkerStationRecipe getLastRecipe() {
        return this.lastRecipe;
    }

    public LazyResultContainer getCraftingResult() {
        return this.craftingResult;
    }

    public ValidatedResult getCurrentError() {
        return this.currentError;
    }

    public String getItemName() {
        return this.itemName;
    }
}

