/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.block.entity.inventory;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3956;
import slimeknights.mantle.recipe.container.ISingleStackContainer;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tables.block.entity.table.TinkerStationBlockEntity;

public class TinkerStationContainerWrapper
implements IMutableTinkerStationContainer {
    private final TinkerStationBlockEntity station;
    private MaterialRecipe[] materials;
    private boolean[] searchedMaterial;
    @Nullable
    private ToolStack tool;
    private MaterialRecipe lastMaterialRecipe;
    @Nullable
    private class_1657 player;

    public TinkerStationContainerWrapper(TinkerStationBlockEntity station) {
        this.station = station;
        int count = station.getInputCount();
        this.materials = new MaterialRecipe[count];
        this.searchedMaterial = new boolean[count];
    }

    @Nullable
    private MaterialRecipe findMaterialRecipe(class_1799 stack) {
        class_1937 world = this.station.method_10997();
        if (world == null) {
            return null;
        }
        ISingleStackContainer inv = () -> stack;
        if (this.lastMaterialRecipe != null && this.lastMaterialRecipe.matches(inv, world)) {
            return this.lastMaterialRecipe;
        }
        Optional newRecipe = world.method_8433().method_8132((class_3956)TinkerRecipeTypes.MATERIAL.get(), (class_1263)inv, world);
        if (newRecipe.isPresent()) {
            this.lastMaterialRecipe = (MaterialRecipe)newRecipe.get();
            return this.lastMaterialRecipe;
        }
        return null;
    }

    public void refreshInput(int slot) {
        if (slot == 0) {
            this.tool = null;
        } else if (slot >= 1 && slot < this.station.getInputCount() + 1) {
            this.materials[slot - 1] = null;
            this.searchedMaterial[slot - 1] = false;
        }
    }

    public void resize() {
        int count = this.station.getInputCount();
        if (count != this.materials.length) {
            this.materials = new MaterialRecipe[count];
            this.searchedMaterial = new boolean[count];
        }
    }

    @Override
    public class_1799 getTinkerableStack() {
        return this.station.method_5438(0);
    }

    @Override
    public ToolStack getTinkerable() {
        if (this.tool == null) {
            this.tool = ToolStack.from(this.getTinkerableStack());
        }
        return this.tool;
    }

    @Override
    public class_1799 getInput(int index) {
        if (index < 0 || index >= this.station.getInputCount()) {
            return class_1799.field_8037;
        }
        return this.station.method_5438(index + 1);
    }

    @Override
    public int getInputCount() {
        return this.station.getInputCount();
    }

    @Override
    @Nullable
    public MaterialRecipe getInputMaterial(int index) {
        if (index < 0 || index >= this.station.getInputCount()) {
            return null;
        }
        if (!this.searchedMaterial[index]) {
            this.materials[index] = this.findMaterialRecipe(this.getInput(index));
            this.searchedMaterial[index] = true;
        }
        return this.materials[index];
    }

    @Override
    public void setInput(int index, class_1799 stack) {
        if (index >= 0 && index < this.station.getInputCount()) {
            this.station.method_5447(index + 1, stack);
        }
    }

    @Override
    public void giveItem(class_1799 stack) {
        if (this.player != null) {
            this.player.method_31548().method_7398(stack);
        }
    }

    public void setPlayer(@Nullable class_1657 player) {
        this.player = player;
    }
}

