/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.block.entity.inventory;

import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.tconstruct.tables.block.entity.inventory.IChestItemHandler;

public abstract class ScalingChestItemHandler
extends ItemStackHandler
implements IChestItemHandler,
TransactionContext.CloseCallback {
    protected static final int DEFAULT_MAX = 256;
    private int visualSize = 1;
    @Nullable
    private MantleBlockEntity parent;
    private final List<Integer> snapshots = new ArrayList<Integer>();

    public ScalingChestItemHandler(int size) {
        super(size);
    }

    public ScalingChestItemHandler() {
        this(256);
    }

    public abstract boolean isItemValid(int var1, ItemVariant var2, int var3);

    protected void onLoad() {
        int newLimit = this.getSlotCount();
        if (newLimit > 1 && this.getStackInSlot(newLimit - 1).method_7960()) {
            while (newLimit > 1 && this.getStackInSlot(newLimit - 2).method_7960()) {
                --newLimit;
            }
        }
        this.visualSize = newLimit;
    }

    private void updateVisualSize(int slotChanged, class_1799 stack) {
        int maxSlots = this.getSlotCount();
        if (slotChanged >= maxSlots) {
            return;
        }
        if (stack.method_7960()) {
            if (slotChanged + 1 == this.visualSize || slotChanged + 2 == this.visualSize && this.getStackInSlot(this.visualSize - 1).method_7960()) {
                while (this.visualSize > 1 && this.getStackInSlot(this.visualSize - 2).method_7960()) {
                    --this.visualSize;
                }
            }
        } else if (this.visualSize < maxSlots && this.visualSize < slotChanged + 2) {
            this.visualSize = slotChanged + 2;
        }
    }

    public void setStackInSlot(int slot, class_1799 stack) {
        super.setStackInSlot(slot, stack);
        this.updateVisualSize(slot, stack);
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        long totalInserted = 0L;
        for (int i = 0; i < this.getSlotCount(); ++i) {
            long inserted = this.insertSlot(i, resource, maxAmount, transaction);
            totalInserted += inserted;
            maxAmount -= inserted;
        }
        return totalInserted;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        long totalExtracted = 0L;
        for (int i = 0; i < this.getSlotCount(); ++i) {
            long extracted = this.extractSlot(i, resource, maxAmount, transaction);
            totalExtracted += extracted;
            maxAmount -= extracted;
        }
        return totalExtracted;
    }

    protected ItemStackHandlerSlot makeSlot(int index, class_1799 stack) {
        return new ScalingChestItemSlot(index, this, stack);
    }

    public long insertSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext transaction) {
        long result = super.insertSlot(slot, resource, maxAmount, transaction);
        this.updateSnapshots(transaction);
        this.updateVisualSize(slot, this.getStackInSlot(slot));
        return result;
    }

    public long extractSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext transaction) {
        long result = super.extractSlot(slot, resource, maxAmount, transaction);
        this.updateSnapshots(transaction);
        this.updateVisualSize(slot, this.getStackInSlot(slot));
        return result;
    }

    protected void onContentsChanged(int slot) {
        if (this.parent != null) {
            this.parent.setChangedFast();
        }
    }

    public void updateSnapshots(TransactionContext transaction) {
        while (this.snapshots.size() <= transaction.nestingDepth()) {
            this.snapshots.add(null);
        }
        if (this.snapshots.get(transaction.nestingDepth()) == null) {
            Integer snapshot = this.visualSize;
            Objects.requireNonNull(snapshot, "Snapshot may not be null!");
            this.snapshots.set(transaction.nestingDepth(), snapshot);
            transaction.addCloseCallback((TransactionContext.CloseCallback)this);
        }
    }

    public void onClose(TransactionContext transaction, TransactionContext.Result result) {
        Integer snapshot = this.snapshots.set(transaction.nestingDepth(), null);
        if (result.wasAborted()) {
            this.visualSize = snapshot;
        } else if (transaction.nestingDepth() > 0 && this.snapshots.get(transaction.nestingDepth() - 1) == null) {
            this.snapshots.set(transaction.nestingDepth() - 1, snapshot);
            transaction.getOpenTransaction(transaction.nestingDepth() - 1).addCloseCallback((TransactionContext.CloseCallback)this);
        }
    }

    @Override
    public int getVisualSize() {
        return this.visualSize;
    }

    @Override
    public void setParent(@Nullable MantleBlockEntity parent) {
        this.parent = parent;
    }

    public class ScalingChestItemSlot
    extends ItemStackHandlerSlot {
        protected ScalingChestItemHandler scalingHandler;

        public ScalingChestItemSlot(int index, ScalingChestItemHandler handler, class_1799 initial) {
            super(index, (ItemStackHandler)handler, initial);
            this.scalingHandler = handler;
        }

        public long insert(ItemVariant insertedVariant, long maxAmount, TransactionContext transaction) {
            long result = super.insert(insertedVariant, maxAmount, transaction);
            this.scalingHandler.updateSnapshots(transaction);
            ScalingChestItemHandler.this.updateVisualSize(this.getIndex(), this.getStack());
            return result;
        }

        public long extract(ItemVariant variant, long maxAmount, TransactionContext transaction) {
            long result = super.extract(variant, maxAmount, transaction);
            this.scalingHandler.updateSnapshots(transaction);
            ScalingChestItemHandler.this.updateVisualSize(this.getIndex(), this.getStack());
            return result;
        }
    }
}

