/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.item;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantItemStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import slimeknights.tconstruct.smeltery.item.CopperCanItem;

public class CopperCanFluidHandler
extends SingleVariantItemStorage<FluidVariant> {
    private final ContainerItemContext container;

    public CopperCanFluidHandler(ContainerItemContext container) {
        super(container);
        this.container = container;
    }

    public long getCapacity(FluidVariant variant) {
        return 9000L;
    }

    private class_3611 getFluid(ItemVariant variant) {
        return CopperCanItem.getFluid(variant.getNbt());
    }

    @Nullable
    private class_2487 getFluidTag() {
        return CopperCanItem.getFluidTag(this.container.getItemVariant().getNbt());
    }

    protected FluidVariant getBlankResource() {
        return FluidVariant.blank();
    }

    protected FluidVariant getResource(ItemVariant currentVariant) {
        return FluidVariant.of((class_3611)this.getFluid(currentVariant), (class_2487)this.getFluidTag());
    }

    protected long getAmount(ItemVariant currentVariant) {
        return this.getFluid(currentVariant) == class_3612.field_15906 ? 0L : 9000L;
    }

    public long insert(FluidVariant insertedResource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)insertedResource, (long)maxAmount);
        if (maxAmount < 9000L) {
            return 0L;
        }
        return super.insert((TransferVariant)insertedResource, 9000L, transaction);
    }

    public long extract(FluidVariant extractedResource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)extractedResource, (long)maxAmount);
        if (maxAmount < 9000L) {
            return 0L;
        }
        class_3611 fluid = this.getFluid(this.container.getItemVariant());
        if (fluid == class_3612.field_15906 || fluid != extractedResource.getFluid()) {
            return 0L;
        }
        return super.extract((TransferVariant)extractedResource, 9000L, transaction);
    }

    protected ItemVariant getUpdatedVariant(ItemVariant currentVariant, FluidVariant newResource, long newAmount) {
        return ItemVariant.of((class_1799)CopperCanItem.setFluid(currentVariant.toStack(), new FluidStack(newResource.getFluid(), newAmount, newResource.copyNbt())));
    }

    public ContainerItemContext getContainer() {
        return this.container;
    }
}

