/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.tank;

import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2487;
import slimeknights.tconstruct.smeltery.block.entity.ChannelBlockEntity;

public class ChannelTank
extends FluidTank {
    private final List<Long> lockSnapshots = new ArrayList<Long>();
    private static final String TAG_LOCKED = "locked";
    private long locked;
    private final ChannelBlockEntity parent;

    public ChannelTank(int capacity, ChannelBlockEntity parent) {
        super((long)capacity, fluid -> !FluidVariantAttributes.isLighterThanAir((FluidVariant)fluid.getType()));
        this.parent = parent;
    }

    public void freeFluid() {
        this.locked = 0L;
    }

    public long getMaxUsable() {
        return Math.max(this.stack.getAmount() - this.locked, 0L);
    }

    public long insert(FluidVariant insertedVariant, long maxAmount, TransactionContext tx) {
        boolean wasEmpty = this.isEmpty();
        long amount = super.insert(insertedVariant, maxAmount, tx);
        this.updateSnapshots(tx);
        this.updateLockSnapshots(tx);
        this.locked += amount;
        tx.addOuterCloseCallback(result -> {
            if (result.wasCommitted() && wasEmpty && !this.isEmpty()) {
                this.parent.sendFluidUpdate();
            }
        });
        return amount;
    }

    public long extract(FluidVariant extractedVariant, long maxAmount, TransactionContext tx) {
        boolean wasEmpty = this.isEmpty();
        long extracted = super.extract(extractedVariant, maxAmount, tx);
        this.updateLockSnapshots(tx);
        tx.addOuterCloseCallback(result -> {
            if (result.wasCommitted() && !wasEmpty && this.isEmpty()) {
                this.parent.sendFluidUpdate();
            }
        });
        return extracted;
    }

    public FluidTank readFromNBT(class_2487 nbt) {
        this.locked = nbt.method_10537(TAG_LOCKED);
        super.readFromNBT(nbt);
        return this;
    }

    public class_2487 writeToNBT(class_2487 nbt) {
        nbt = super.writeToNBT(nbt);
        nbt.method_10544(TAG_LOCKED, this.locked);
        return nbt;
    }

    public void updateLockSnapshots(TransactionContext transaction) {
        while (this.lockSnapshots.size() <= transaction.nestingDepth()) {
            this.lockSnapshots.add(null);
        }
        if (this.lockSnapshots.get(transaction.nestingDepth()) == null) {
            long snapshot = this.locked;
            this.lockSnapshots.set(transaction.nestingDepth(), snapshot);
            transaction.addCloseCallback(this::closeLock);
        }
    }

    public void closeLock(TransactionContext transaction, TransactionContext.Result result) {
        long snapshot = this.lockSnapshots.set(transaction.nestingDepth(), null);
        if (result.wasAborted()) {
            this.locked = snapshot;
        } else if (transaction.nestingDepth() > 0 && this.lockSnapshots.get(transaction.nestingDepth() - 1) == null) {
            this.lockSnapshots.set(transaction.nestingDepth() - 1, snapshot);
            transaction.getOpenTransaction(transaction.nestingDepth() - 1).addCloseCallback(this::closeLock);
        }
    }
}

