/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.controller;

import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.block.entity.controller.HeatingStructureBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.module.ByproductMeltingModuleInventory;
import slimeknights.tconstruct.smeltery.block.entity.module.MeltingModuleInventory;
import slimeknights.tconstruct.smeltery.block.entity.multiblock.FoundryMultiblock;
import slimeknights.tconstruct.smeltery.block.entity.multiblock.HeatingStructureMultiblock;

public class FoundryBlockEntity
extends HeatingStructureBlockEntity {
    private static final long CAPACITY_PER_BLOCK = 72000L;
    private static final class_2561 NAME = TConstruct.makeTranslation("gui", "foundry");
    private static final int BLOCKS_PER_FUEL = 18;

    public FoundryBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591<? extends HeatingStructureBlockEntity>)((class_2591)TinkerSmeltery.foundry.get()), pos, state, NAME);
    }

    @Override
    protected HeatingStructureMultiblock<?> createMultiblock() {
        return new FoundryMultiblock(this);
    }

    @Override
    protected MeltingModuleInventory createMeltingInventory() {
        return new ByproductMeltingModuleInventory((MantleBlockEntity)this, this.tank, Config.COMMON.foundryOreRate);
    }

    @Override
    protected boolean isDebugItem(class_1799 stack) {
        return stack.method_31573(TinkerTags.Items.FOUNDRY_DEBUG);
    }

    @Override
    protected void heat() {
        if (this.structure == null || this.field_11863 == null) {
            return;
        }
        if (this.structure.hasTanks()) {
            boolean entityMelted = false;
            if (this.tick == 12) {
                entityMelted = this.entityModule.interactWithEntities();
            }
            switch (this.tick % 4) {
                case 0: {
                    if (this.fuelModule.hasFuel()) break;
                    if (entityMelted) {
                        this.fuelModule.findFuel(true);
                        break;
                    }
                    if (!this.meltingInventory.canHeat(this.fuelModule.findFuel(false))) break;
                    this.fuelModule.findFuel(true);
                    break;
                }
                case 1: {
                    if (this.fuelModule.hasFuel()) {
                        this.meltingInventory.heatItems(this.fuelModule.getTemperature());
                        break;
                    }
                    this.meltingInventory.coolItems();
                    break;
                }
                case 3: {
                    boolean hasFuel = this.fuelModule.hasFuel();
                    class_2680 state = this.method_11010();
                    if ((Boolean)state.method_11654((class_2769)ControllerBlock.ACTIVE) != hasFuel) {
                        this.field_11863.method_8501(this.field_11867, (class_2680)state.method_11657((class_2769)ControllerBlock.ACTIVE, (Comparable)Boolean.valueOf(hasFuel)));
                    }
                    this.fuelModule.decreaseFuel(this.fuelRate);
                    break;
                }
            }
        }
    }

    @Override
    protected void setStructure(@Nullable HeatingStructureMultiblock.StructureData structure) {
        super.setStructure(structure);
        if (structure != null) {
            int dx = structure.getInnerX();
            int dy = structure.getInnerY();
            int dz = structure.getInnerZ();
            this.tank.setCapacity(72000L * (long)(dx + 2) * (long)(dy + 1) * (long)(dz + 2));
            this.meltingInventory.resize(dx * dy * dz, this.dropItem);
            this.fuelRate = 1 + (2 * ((dx + 2) * dy) + 2 * (dy * dz) + (dx + 2) * (dz + 2)) / 18;
        }
    }
}

