/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.component;

import io.github.fabricators_of_create.porting_lib.common.util.NonNullConsumer;
import io.github.fabricators_of_create.porting_lib.util.LazyOptional;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SidedStorageBlockEntity;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.block.entity.IRetexturedBlockEntity;
import slimeknights.mantle.client.model.data.IModelData;
import slimeknights.mantle.client.model.data.ModelDataMap;
import slimeknights.mantle.client.model.data.SinglePropertyData;
import slimeknights.mantle.util.RetexturedHelper;
import slimeknights.mantle.util.WeakConsumerWrapper;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.entity.component.SmelteryComponentBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.tank.IDisplayFluidListener;
import slimeknights.tconstruct.smeltery.block.entity.tank.ISmelteryTankHandler;

public abstract class SmelteryInputOutputBlockEntity<T>
extends SmelteryComponentBlockEntity
implements IRetexturedBlockEntity {
    private final BlockApiLookup<Storage<T>, @Nullable class_2350> capability;
    protected final Storage<T> emptyInstance = Storage.empty();
    protected final NonNullConsumer<LazyOptional<T>> listener = new WeakConsumerWrapper((Object)this, (te, cap) -> te.clearHandler());
    @javax.annotation.Nullable
    private Storage<T> capabilityHolder = null;
    private final IModelData modelData = this.getRetexturedModelData();
    @Nonnull
    private class_2248 texture = class_2246.field_10124;

    protected SmelteryInputOutputBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, BlockApiLookup<Storage<T>, @Nullable class_2350> capability) {
        super(type, pos, state);
        this.capability = capability;
    }

    private void clearHandler() {
        if (this.capabilityHolder != null) {
            this.capabilityHolder = null;
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.clearHandler();
    }

    @Override
    protected void setMaster(@javax.annotation.Nullable class_2338 master, @javax.annotation.Nullable class_2248 block) {
        assert (this.field_11863 != null);
        boolean masterChanged = false;
        if (!Objects.equals(this.getMasterPos(), master)) {
            this.clearHandler();
            masterChanged = true;
        }
        super.setMaster(master, block);
        if (masterChanged) {
            this.field_11863.method_8408(this.field_11867, this.method_11010().method_26204());
        }
    }

    protected Storage<T> getCapability(class_1937 level, class_2338 pos) {
        return (Storage)this.capability.find(level, pos, null);
    }

    protected Storage<T> getCachedCapability() {
        if (this.capabilityHolder == null) {
            class_2338 master;
            if (this.validateMaster() && (master = this.getMasterPos()) != null && this.field_11863 != null) {
                this.capabilityHolder = this.getCapability(this.field_11863, master);
                return this.capabilityHolder;
            }
            this.capabilityHolder = null;
        }
        return this.capabilityHolder;
    }

    public IModelData getRetexturedModelData() {
        return new SinglePropertyData(RetexturedHelper.BLOCK_PROPERTY);
    }

    public String getTextureName() {
        return RetexturedHelper.getTextureName((class_2248)this.texture);
    }

    public void updateTexture(String name) {
        class_2248 oldTexture = this.texture;
        this.texture = RetexturedHelper.getBlock((String)name);
        if (oldTexture != this.texture) {
            this.setChangedFast();
            RetexturedHelper.onTextureUpdated((class_2586)this);
        }
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    protected void saveSynced(class_2487 tags) {
        super.saveSynced(tags);
        if (this.texture != class_2246.field_10124) {
            tags.method_10582("texture", this.getTextureName());
        }
    }

    @Override
    public void method_11014(class_2487 tags) {
        super.method_11014(tags);
        if (tags.method_10573("texture", 8)) {
            this.texture = RetexturedHelper.getBlock((String)tags.method_10558("texture"));
            RetexturedHelper.onTextureUpdated((class_2586)this);
        }
    }

    public IModelData getRenderData() {
        return this.modelData;
    }

    public IModelData getModelData() {
        return this.modelData;
    }

    @Nonnull
    public class_2248 getTexture() {
        return this.texture;
    }

    public static class ChuteBlockEntity
    extends SmelteryInputOutputBlockEntity<ItemVariant>
    implements SidedStorageBlockEntity {
        public ChuteBlockEntity(class_2338 pos, class_2680 state) {
            this((class_2591)TinkerSmeltery.chute.get(), pos, state);
        }

        protected ChuteBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
            super(type, pos, state, ItemStorage.SIDED);
        }

        @javax.annotation.Nullable
        public Storage<ItemVariant> getItemStorage(@javax.annotation.Nullable class_2350 direction) {
            return this.getCachedCapability();
        }
    }

    public static abstract class SmelteryFluidIO
    extends SmelteryInputOutputBlockEntity<FluidVariant>
    implements SidedStorageBlockEntity {
        protected SmelteryFluidIO(class_2591<?> type, class_2338 pos, class_2680 state) {
            super(type, pos, state, FluidStorage.SIDED);
        }

        protected Storage<FluidVariant> makeWrapper(SlottedStorage<FluidVariant> capability) {
            return capability;
        }

        @Override
        protected Storage<FluidVariant> getCapability(class_1937 level, class_2338 pos) {
            SlottedStorage<FluidVariant> capability;
            class_2586 parent = level.method_8321(pos);
            if (parent instanceof ISmelteryTankHandler && (capability = ((ISmelteryTankHandler)parent).getFluidCapability()) != null) {
                return this.makeWrapper(capability);
            }
            return null;
        }

        @Override
        public IModelData getRenderData() {
            return this.getModelData();
        }

        @Override
        public IModelData getRetexturedModelData() {
            return new ModelDataMap.Builder().withProperty(RetexturedHelper.BLOCK_PROPERTY).withProperty(IDisplayFluidListener.PROPERTY).build();
        }

        @javax.annotation.Nullable
        public Storage<FluidVariant> getFluidStorage(@javax.annotation.Nullable class_2350 direction) {
            return this.getCachedCapability();
        }
    }
}

