/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;

public class HeldModifiableItemIterator {
    private static final SimpleCommandExceptionType FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)TConstruct.makeTranslation("command", "held_modifiable.failed"));
    private static final DynamicCommandExceptionType NONLIVING_ENTITY_EXCEPTION = new DynamicCommandExceptionType(error -> TConstruct.makeTranslation("command", "held_modifiable.failed.nonliving", error));
    private static final DynamicCommandExceptionType ITEMLESS_EXCEPTION = new DynamicCommandExceptionType(error -> TConstruct.makeTranslation("command", "held_modifiable.failed.no_item", error));
    private static final DynamicCommandExceptionType INVALID_ITEM = new DynamicCommandExceptionType(error -> TConstruct.makeTranslation("command", "held_modifiable.failed.invalid_item", error));

    public static List<class_1309> apply(CommandContext<class_2168> context, HeldModifiableBehavior behavior) throws CommandSyntaxException {
        return HeldModifiableItemIterator.apply(class_2186.method_9317(context, (String)"targets"), behavior);
    }

    public static List<class_1309> apply(Collection<? extends class_1297> targets, HeldModifiableBehavior behavior) throws CommandSyntaxException {
        ArrayList<class_1309> successes = new ArrayList<class_1309>();
        for (class_1297 class_12972 : targets) {
            if (class_12972 instanceof class_1309) {
                class_1309 living = (class_1309)class_12972;
                class_1799 stack = living.method_6047();
                if (!stack.method_7960()) {
                    if (stack.method_31573(TinkerTags.Items.MODIFIABLE)) {
                        if (!behavior.accept(living, stack)) continue;
                        successes.add(living);
                        continue;
                    }
                    throw INVALID_ITEM.create((Object)class_12972.method_5477().getString());
                }
                throw ITEMLESS_EXCEPTION.create((Object)class_12972.method_5477().getString());
            }
            throw NONLIVING_ENTITY_EXCEPTION.create((Object)class_12972.method_5477().getString());
        }
        if (successes.isEmpty()) {
            throw FAILED_EXCEPTION.create();
        }
        return successes;
    }

    public static interface HeldModifiableBehavior {
        public boolean accept(class_1309 var1, class_1799 var2) throws CommandSyntaxException;
    }
}

