/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.rei.melting;

import dev.architectury.fluid.FluidStack;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.plugin.rei.TinkersCategory;

public class MeltingDisplay
implements Display {
    private final List<EntryIngredient> inputEntries;
    private final List<EntryIngredient> outputEntries;
    private final CategoryIdentifier<MeltingDisplay> categoryIdentifier;
    private final int time;
    private final int temperature;
    private final IMeltingContainer.OreRateType oreType;
    private final MeltingRecipe recipe;

    public MeltingDisplay(MeltingRecipe recipe, CategoryIdentifier<MeltingDisplay> id) {
        this.recipe = recipe;
        this.inputEntries = EntryIngredients.ofIngredients(recipe.method_8117());
        this.outputEntries = List.of(EntryIngredients.of((FluidStack)TinkersCategory.toREIFluid(recipe.getOutput())));
        this.categoryIdentifier = id;
        this.time = recipe.getTime();
        this.oreType = recipe.getOreType();
        this.temperature = recipe.getTemperature();
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputEntries;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.outputEntries;
    }

    public CategoryIdentifier<MeltingDisplay> getCategoryIdentifier() {
        return this.categoryIdentifier;
    }

    public int getTime() {
        return this.time;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public IMeltingContainer.OreRateType getOreType() {
        return this.oreType;
    }

    public MeltingRecipe getRecipe() {
        return this.recipe;
    }
}

