/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.rei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import dev.architectury.fluid.FluidStack;
import io.github.fabricators_of_create.porting_lib.mixin.accessors.common.accessor.RecipeManagerAccessor;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryTypeRegistry;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import slimeknights.mantle.recipe.helper.RecipeHelper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.common.registration.CastItemObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipe;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipe;
import slimeknights.tconstruct.library.recipe.fuel.MeltingFuel;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.recipe.modifiers.severing.SeveringRecipe;
import slimeknights.tconstruct.library.recipe.molding.MoldingRecipe;
import slimeknights.tconstruct.library.recipe.partbuilder.IDisplayPartBuilderRecipe;
import slimeknights.tconstruct.library.recipe.worktable.IModifierWorktableRecipe;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.item.IModifiableDisplay;
import slimeknights.tconstruct.plugin.jei.entity.DefaultEntityMeltingRecipe;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;
import slimeknights.tconstruct.plugin.jei.partbuilder.MaterialItemList;
import slimeknights.tconstruct.plugin.rei.AlloyDisplay;
import slimeknights.tconstruct.plugin.rei.AlloyRecipeCategory;
import slimeknights.tconstruct.plugin.rei.MoldingRecipeCategory;
import slimeknights.tconstruct.plugin.rei.MoldingRecipeDisplay;
import slimeknights.tconstruct.plugin.rei.TConstructREIConstants;
import slimeknights.tconstruct.plugin.rei.casting.CastingBasinCategory;
import slimeknights.tconstruct.plugin.rei.casting.CastingDisplay;
import slimeknights.tconstruct.plugin.rei.casting.CastingTableCategory;
import slimeknights.tconstruct.plugin.rei.entity.EntityEntryDefinition;
import slimeknights.tconstruct.plugin.rei.entity.EntityMeltingRecipeCategory;
import slimeknights.tconstruct.plugin.rei.entity.EntityMeltingRecipeDisplay;
import slimeknights.tconstruct.plugin.rei.entity.SeveringCategory;
import slimeknights.tconstruct.plugin.rei.entity.SeveringDisplay;
import slimeknights.tconstruct.plugin.rei.melting.FoundryCategory;
import slimeknights.tconstruct.plugin.rei.melting.MeltingCategory;
import slimeknights.tconstruct.plugin.rei.melting.MeltingDisplay;
import slimeknights.tconstruct.plugin.rei.modifiers.ModifierEntryDefinition;
import slimeknights.tconstruct.plugin.rei.modifiers.ModifierRecipeCategory;
import slimeknights.tconstruct.plugin.rei.modifiers.ModifierRecipeDisplay;
import slimeknights.tconstruct.plugin.rei.modifiers.ModifierWorktableCategory;
import slimeknights.tconstruct.plugin.rei.modifiers.ModifierWorktableDisplay;
import slimeknights.tconstruct.plugin.rei.partbuilder.PartBuilderCategory;
import slimeknights.tconstruct.plugin.rei.partbuilder.PartBuilderDisplay;
import slimeknights.tconstruct.plugin.rei.partbuilder.PatternEntryDefinition;
import slimeknights.tconstruct.shared.TinkerMaterials;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.data.SmelteryCompat;
import slimeknights.tconstruct.tables.TinkerTables;

public class REIPlugin
implements REIClientPlugin {
    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new CastingBasinCategory());
        registry.add((DisplayCategory)new CastingTableCategory());
        registry.add((DisplayCategory)new MoldingRecipeCategory());
        registry.add((DisplayCategory)new MeltingCategory());
        registry.add((DisplayCategory)new AlloyRecipeCategory());
        registry.add((DisplayCategory)new EntityMeltingRecipeCategory());
        registry.add((DisplayCategory)new FoundryCategory());
        registry.add((DisplayCategory)new ModifierRecipeCategory());
        registry.add((DisplayCategory)new SeveringCategory());
        registry.add((DisplayCategory)new PartBuilderCategory());
        registry.add((DisplayCategory)new ModifierWorktableCategory());
        registry.addWorkstations(TConstructREIConstants.PART_BUILDER, new EntryStack[]{EntryStacks.of(TinkerTables.partBuilder)});
        registry.addWorkstations(TConstructREIConstants.MODIFIERS, new EntryStack[]{EntryStacks.of(TinkerTables.tinkerStation)});
        registry.addWorkstations(TConstructREIConstants.MODIFIERS, new EntryStack[]{EntryStacks.of(TinkerTables.tinkersAnvil)});
        registry.addWorkstations(TConstructREIConstants.MODIFIERS, new EntryStack[]{EntryStacks.of(TinkerTables.scorchedAnvil)});
        registry.addWorkstations(TConstructREIConstants.MODIFIER_WORKTABLE, new EntryStack[]{EntryStacks.of(TinkerTables.modifierWorktable)});
        registry.addWorkstations(TConstructREIConstants.MELTING, new EntryStack[]{EntryStacks.of(TinkerSmeltery.searedMelter)});
        registry.addWorkstations(BuiltinPlugin.FUEL, new EntryStack[]{EntryStacks.of(TinkerSmeltery.searedHeater)});
        REIPlugin.addCastingCatalyst(registry, TinkerSmeltery.searedTable, TConstructREIConstants.CASTING_TABLE, (class_3956<MoldingRecipe>)((class_3956)TinkerRecipeTypes.MOLDING_TABLE.get()));
        REIPlugin.addCastingCatalyst(registry, TinkerSmeltery.searedBasin, TConstructREIConstants.CASTING_BASIN, (class_3956<MoldingRecipe>)((class_3956)TinkerRecipeTypes.MOLDING_BASIN.get()));
        REIPlugin.addCatalysts(registry, (EntryStack<class_1799>)EntryStacks.of(TinkerSmeltery.smelteryController), TConstructREIConstants.MELTING, TConstructREIConstants.ALLOY, TConstructREIConstants.ENTITY_MELTING);
        registry.addWorkstations(TConstructREIConstants.ALLOY, new EntryStack[]{EntryStacks.of(TinkerSmeltery.scorchedAlloyer)});
        REIPlugin.addCastingCatalyst(registry, TinkerSmeltery.scorchedTable, TConstructREIConstants.CASTING_TABLE, (class_3956<MoldingRecipe>)((class_3956)TinkerRecipeTypes.MOLDING_TABLE.get()));
        REIPlugin.addCastingCatalyst(registry, TinkerSmeltery.scorchedBasin, TConstructREIConstants.CASTING_BASIN, (class_3956<MoldingRecipe>)((class_3956)TinkerRecipeTypes.MOLDING_BASIN.get()));
        registry.addWorkstations(TConstructREIConstants.FOUNDRY, new EntryStack[]{EntryStacks.of(TinkerSmeltery.foundryController)});
        for (class_6880 item : Objects.requireNonNull(class_7923.field_41178.method_40286(TinkerTags.Items.MELEE))) {
            registry.addWorkstations(TConstructREIConstants.SEVERING, new EntryStack[]{EntryStacks.of((class_1799)IModifiableDisplay.getDisplayStack((class_1792)item.comp_349()))});
        }
    }

    public void registerEntryTypes(EntryTypeRegistry registry) {
        registry.register(TConstructREIConstants.ENTITY_TYPE, (EntryDefinition)new EntityEntryDefinition());
        registry.register(TConstructREIConstants.MODIFIER_TYPE, (EntryDefinition)new ModifierEntryDefinition());
        registry.register(TConstructREIConstants.PATTERN_TYPE, (EntryDefinition)new PatternEntryDefinition());
    }

    public void registerEntries(EntryRegistry registry) {
        class_1863 manager = class_310.method_1551().field_1687.method_8433();
        List<ModifierEntry> modifiers = Collections.emptyList();
        if (((Boolean)Config.CLIENT.showModifiersInJEI.get()).booleanValue()) {
            modifiers = RecipeHelper.getJEIRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.TINKER_STATION.get()), IDisplayModifierRecipe.class).stream().map(recipe -> recipe.getDisplayResult().getModifier()).distinct().sorted(Comparator.comparing(Modifier::getId)).map(mod -> new ModifierEntry((Modifier)mod, 1)).collect(Collectors.toList());
        }
        modifiers.forEach(entry -> registry.addEntry(EntryStack.of(TConstructREIConstants.MODIFIER_TYPE, (Object)entry)));
        REIPlugin.removeFluid(registry, (class_3611)TinkerFluids.moltenSoulsteel.get(), TinkerFluids.moltenSoulsteel.method_8389());
        REIPlugin.removeFluid(registry, (class_3611)TinkerFluids.moltenKnightslime.get(), TinkerFluids.moltenKnightslime.method_8389());
        for (SmelteryCompat compat : SmelteryCompat.values()) {
            Iterable<class_6880<class_1792>> ingot = REIPlugin.getTag(new class_2960("c", compat.getName() + "_ingots"));
            if (!Iterables.isEmpty(ingot)) continue;
            REIPlugin.removeFluid(registry, (class_3611)compat.getFluid().get(), compat.getBucket());
        }
        if (!FabricLoader.getInstance().isModLoaded("ceramics")) {
            REIPlugin.removeFluid(registry, (class_3611)TinkerFluids.moltenPorcelain.get(), TinkerFluids.moltenPorcelain.method_8389());
        }
        REIPlugin.optionalCast(registry, TinkerSmeltery.plateCast);
        REIPlugin.optionalCast(registry, TinkerSmeltery.gearCast);
        REIPlugin.optionalCast(registry, TinkerSmeltery.coinCast);
        REIPlugin.optionalCast(registry, TinkerSmeltery.wireCast);
        REIPlugin.optionalItem(registry, TinkerMaterials.necroniumBone, "uranium_ingots");
    }

    public void registerDisplays(DisplayRegistry registry) {
        assert (class_310.method_1551().field_1687 != null);
        class_1863 manager = class_310.method_1551().field_1687.method_8433();
        List castingBasinRecipes = RecipeHelper.getJEIRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.CASTING_BASIN.get()), IDisplayableCastingRecipe.class);
        castingBasinRecipes.forEach(castingBasinRecipe -> registry.add((Display)new CastingDisplay(TConstructREIConstants.CASTING_BASIN, (IDisplayableCastingRecipe)castingBasinRecipe)));
        List castingTableRecipes = RecipeHelper.getJEIRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.CASTING_TABLE.get()), IDisplayableCastingRecipe.class);
        castingTableRecipes.forEach(castingTableRecipe -> registry.add((Display)new CastingDisplay(TConstructREIConstants.CASTING_TABLE, (IDisplayableCastingRecipe)castingTableRecipe)));
        List meltingRecipes = RecipeHelper.getJEIRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.MELTING.get()), MeltingRecipe.class);
        meltingRecipes.forEach(meltingRecipe -> registry.add((Display)new MeltingDisplay((MeltingRecipe)meltingRecipe, TConstructREIConstants.MELTING), (Object)meltingRecipes));
        meltingRecipes.forEach(meltingRecipe -> registry.add((Display)new MeltingDisplay((MeltingRecipe)meltingRecipe, TConstructREIConstants.FOUNDRY), (Object)meltingRecipes));
        MeltingFuelHandler.setMeltngFuels(RecipeHelper.getRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.FUEL.get()), MeltingFuel.class));
        List entityMeltingRecipes = RecipeHelper.getJEIRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.ENTITY_MELTING.get()), EntityMeltingRecipe.class);
        entityMeltingRecipes.add(new DefaultEntityMeltingRecipe(entityMeltingRecipes));
        entityMeltingRecipes.forEach(entityMeltingRecipe -> registry.add((Display)new EntityMeltingRecipeDisplay((EntityMeltingRecipe)entityMeltingRecipe)));
        List alloyRecipes = RecipeHelper.getJEIRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.ALLOYING.get()), AlloyRecipe.class);
        alloyRecipes.forEach(alloyRecipe -> registry.add((Display)new AlloyDisplay((AlloyRecipe)alloyRecipe)));
        ImmutableList moldingRecipes = ImmutableList.builder().addAll((Iterable)RecipeHelper.getJEIRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.MOLDING_TABLE.get()), MoldingRecipe.class)).addAll((Iterable)RecipeHelper.getJEIRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.MOLDING_BASIN.get()), MoldingRecipe.class)).build();
        moldingRecipes.forEach(moldingRecipe -> registry.add((Display)new MoldingRecipeDisplay((MoldingRecipe)moldingRecipe)));
        List<IDisplayModifierRecipe> modifierRecipes = RecipeHelper.getJEIRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.TINKER_STATION.get()), IDisplayModifierRecipe.class).stream().sorted((r1, r2) -> {
            SlotType t1 = r1.getSlotType();
            SlotType t2 = r2.getSlotType();
            String n1 = t1 == null ? "zzzzzzzzzz" : t1.getName();
            String n2 = t2 == null ? "zzzzzzzzzz" : t2.getName();
            return n1.compareTo(n2);
        }).collect(Collectors.toList());
        modifierRecipes.forEach(modifierRecipe -> registry.add((Display)new ModifierRecipeDisplay((IDisplayModifierRecipe)modifierRecipe)));
        List severingRecipes = RecipeHelper.getJEIRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.SEVERING.get()), SeveringRecipe.class);
        severingRecipes.forEach(severingRecipe -> registry.add((Display)new SeveringDisplay((SeveringRecipe)severingRecipe)));
        List materialRecipes = RecipeHelper.getRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.MATERIAL.get()), MaterialRecipe.class);
        MaterialItemList.setRecipes(materialRecipes);
        List partRecipes = RecipeHelper.getJEIRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.PART_BUILDER.get()), IDisplayPartBuilderRecipe.class);
        partRecipes.forEach(partRecipe -> registry.add((Display)new PartBuilderDisplay((IDisplayPartBuilderRecipe)partRecipe)));
        List modifierWorktableRecipes = RecipeHelper.getJEIRecipes((class_1863)manager, (class_3956)((class_3956)TinkerRecipeTypes.MODIFIER_WORKTABLE.get()), IModifierWorktableRecipe.class);
        modifierWorktableRecipes.forEach(iModifierWorktableRecipe -> registry.add((Display)new ModifierWorktableDisplay((IModifierWorktableRecipe)iModifierWorktableRecipe)));
    }

    public void registerDisplaySerializer(DisplaySerializerRegistry registry) {
        registry.register(TConstructREIConstants.MODIFIERS, (DisplaySerializer)new ModifierRecipeDisplay.Serializer());
    }

    public void registerTransferHandlers(TransferHandlerRegistry registry) {
    }

    private static void removeFluid(EntryRegistry manager, class_3611 fluid, class_1792 bucket) {
        manager.removeEntry(EntryStacks.of((FluidStack)FluidStack.create((class_3611)fluid, (long)81000L)));
        manager.removeEntry(EntryStacks.of((class_1935)bucket));
    }

    private static Iterable<class_6880<class_1792>> getTag(class_2960 name) {
        return REIPlugin.getTag((class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)name));
    }

    private static Iterable<class_6880<class_1792>> getTag(class_6862<class_1792> name) {
        return Objects.requireNonNull(class_7923.field_41178.method_40286(name));
    }

    private static void optionalItem(EntryRegistry manager, class_1935 item, String tagName) {
        Iterable<class_6880<class_1792>> tag = REIPlugin.getTag(new class_2960("c", tagName));
        if (Iterables.isEmpty(tag)) {
            manager.removeEntry(EntryStacks.of((class_1935)item));
        }
    }

    private static void optionalCast(EntryRegistry manager, CastItemObject cast) {
        Iterable<class_6880<class_1792>> tag = REIPlugin.getTag(new class_2960("c", cast.getName().method_12832() + "_blocks"));
        if (Iterables.isEmpty(tag)) {
            manager.addEntries((Collection)cast.values().stream().map(EntryStacks::of).collect(Collectors.toList()));
        }
    }

    private static <T extends class_1860<C>, C extends class_1263> void addCastingCatalyst(CategoryRegistry registry, class_1935 item, CategoryIdentifier<?> ownCategory, class_3956<MoldingRecipe> type) {
        EntryStack stack = EntryStacks.of((class_1935)item);
        registry.addWorkstations(ownCategory, new EntryStack[]{stack});
        assert (class_310.method_1551().field_1687 != null);
        if (!((RecipeManagerAccessor)class_310.method_1551().field_1687.method_8433()).port_lib$byType(type).isEmpty()) {
            registry.addWorkstations(TConstructREIConstants.MOLDING, new EntryStack[]{stack});
        }
    }

    private static void addCatalysts(CategoryRegistry registry, EntryStack<class_1799> entryStack, CategoryIdentifier<?> ... categoryIdentifiers) {
        for (CategoryIdentifier<?> categoryIdentifier : categoryIdentifiers) {
            registry.addWorkstations(categoryIdentifier, new EntryStack[]{entryStack});
        }
    }
}

