/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.rei;

import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import slimeknights.tconstruct.library.recipe.alloying.AlloyRecipe;
import slimeknights.tconstruct.plugin.rei.TConstructREIConstants;
import slimeknights.tconstruct.plugin.rei.TinkersCategory;

public class AlloyDisplay
implements Display {
    private final AlloyRecipe recipe;
    private final List<EntryIngredient> input;
    private final List<EntryIngredient> output;

    public AlloyDisplay(AlloyRecipe recipe) {
        this.recipe = recipe;
        ArrayList fluids = new ArrayList();
        recipe.getDisplayInputs().forEach(fluidStacks -> fluids.addAll(TinkersCategory.toREIFluids(fluidStacks)));
        this.input = Collections.singletonList(EntryIngredients.of((EntryType)VanillaEntryTypes.FLUID, fluids));
        this.output = Collections.singletonList(EntryIngredients.of((FluidStack)TinkersCategory.toREIFluid(recipe.getOutput())));
    }

    public List<EntryIngredient> getInputEntries() {
        return this.input;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.output;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return TConstructREIConstants.ALLOY;
    }

    public int getTemperature() {
        return this.recipe.getTemperature();
    }

    public AlloyRecipe getRecipe() {
        return this.recipe;
    }
}

