/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.melting;

import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.plugin.jei.TConstructJEIConstants;
import slimeknights.tconstruct.plugin.jei.fabric.JEITypes;
import slimeknights.tconstruct.plugin.jei.melting.AbstractMeltingCategory;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MeltingCategory
extends AbstractMeltingCategory {
    private static final class_2561 TITLE = TConstruct.makeTranslation("jei", "melting.title");
    private static final String KEY_TEMPERATURE = TConstruct.makeTranslationKey("jei", "temperature");
    private static final String KEY_MULTIPLIER = TConstruct.makeTranslationKey("jei", "melting.multiplier");
    private static final class_2561 SOLID_TEMPERATURE = class_2561.method_43469((String)KEY_TEMPERATURE, (Object[])new Object[]{800}).method_27692(class_124.field_1080);
    private static final class_2561 SOLID_MULTIPLIER = class_2561.method_43469((String)KEY_MULTIPLIER, (Object[])new Object[]{Float.valueOf(0.8f)}).method_27692(class_124.field_1080);
    private static final class_2561 TOOLTIP_SMELTERY = TConstruct.makeTranslation("jei", "melting.smeltery").method_27695(new class_124[]{class_124.field_1080, class_124.field_1073});
    private static final class_2561 TOOLTIP_MELTER = TConstruct.makeTranslation("jei", "melting.melter").method_27695(new class_124[]{class_124.field_1080, class_124.field_1073});
    private static final IRecipeSlotTooltipCallback ITEM_FUEL_TOOLTIP = (slot, list) -> {
        list.add(1, SOLID_TEMPERATURE);
        list.add(2, SOLID_MULTIPLIER);
    };
    private static final IRecipeSlotTooltipCallback METAL_ORE_TOOLTIP = new MeltingFluidCallback(IMeltingContainer.OreRateType.METAL);
    private static final IRecipeSlotTooltipCallback GEM_ORE_TOOLTIP = new MeltingFluidCallback(IMeltingContainer.OreRateType.GEM);
    private final IDrawable icon;
    private final IDrawableStatic solidFuel;

    public MeltingCategory(IGuiHelper helper) {
        super(helper);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new class_1799(TinkerSmeltery.searedMelter));
        this.solidFuel = helper.drawableBuilder(BACKGROUND_LOC, 164, 0, 18, 20).build();
    }

    public RecipeType<MeltingRecipe> getRecipeType() {
        return TConstructJEIConstants.MELTING;
    }

    public class_2561 getTitle() {
        return TITLE;
    }

    @Override
    public void draw(MeltingRecipe recipe, IRecipeSlotsView slots, class_332 graphics, double mouseX, double mouseY) {
        super.draw(recipe, slots, graphics, mouseX, mouseY);
        int temperature = recipe.getTemperature();
        if (temperature <= 800) {
            this.solidFuel.draw(graphics, 1, 19);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MeltingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 24, 18).addIngredients(recipe.getInput());
        IMeltingContainer.OreRateType oreType = recipe.getOreType();
        Object tooltip = oreType == IMeltingContainer.OreRateType.METAL ? METAL_ORE_TOOLTIP : (oreType == IMeltingContainer.OreRateType.GEM ? GEM_ORE_TOOLTIP : MeltingFluidCallback.INSTANCE);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 96, 4).addTooltipCallback(tooltip).setFluidRenderer(81000L, false, 32, 32).setOverlay((IDrawable)this.tankOverlay, 0, 0).addIngredient(JEITypes.FLUID_STACK, (Object)recipe.getOutput());
        int fuelHeight = 32;
        if (recipe.getTemperature() <= 800) {
            fuelHeight = 15;
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 2, 22).addTooltipCallback(ITEM_FUEL_TOOLTIP).addItemStacks((List)MeltingFuelHandler.SOLID_FUELS.get());
        }
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 4, 4).addTooltipCallback((IRecipeSlotTooltipCallback)FUEL_TOOLTIP).setFluidRenderer(1L, false, 12, fuelHeight).addIngredients(JEITypes.FLUID_STACK, MeltingFuelHandler.getUsableFuels(recipe.getTemperature()));
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    private static class MeltingFluidCallback
    extends AbstractMeltingCategory.MeltingFluidCallback {
        private final IMeltingContainer.OreRateType oreType;

        @Override
        protected boolean appendMaterial(FluidStack stack, List<class_2561> list) {
            long melterAmount;
            class_3611 fluid = stack.getFluid();
            long amount = stack.getAmount();
            long smelteryAmount = Config.COMMON.smelteryOreRate.applyOreBoost(this.oreType, amount);
            if (smelteryAmount != (melterAmount = Config.COMMON.melterOreRate.applyOreBoost(this.oreType, amount))) {
                list.add(TOOLTIP_MELTER);
                boolean shift = FluidTooltipHandler.appendMaterialNoShift((class_3611)fluid, (long)melterAmount, list);
                list.add((class_2561)class_2561.method_43473());
                list.add(TOOLTIP_SMELTERY);
                shift = FluidTooltipHandler.appendMaterialNoShift((class_3611)fluid, (long)smelteryAmount, list) || shift;
                return shift;
            }
            return FluidTooltipHandler.appendMaterialNoShift((class_3611)fluid, (long)smelteryAmount, list);
        }

        public MeltingFluidCallback(IMeltingContainer.OreRateType oreType) {
            this.oreType = oreType;
        }

        public IMeltingContainer.OreRateType getOreType() {
            return this.oreType;
        }
    }
}

